/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.theme.postprocessor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.theme.util.ThemeBuilderUtils;

public abstract class ThemeFilesProcessor {
    private static final Logger LOG = Logger.getLogger(ThemeFilesProcessor.class);
    protected static final String PLUGIN_FILES_KEY = "plugin";
    protected static final String SUBDIR_FILES_KEY = "subdir";
    protected String themeName;
    protected File themeDirectory;
    protected Properties themeProperties;
    protected Map<String, File> themePluginDirsMap;
    protected File workingDir;
    protected String projectVersion;

    public ThemeFilesProcessor(String themeName, File themeDirectory, Properties themeProperties, Map<String, File> themePluginDirsMap, File workingDir, String projectVersion) {
        this.themeName = themeName;
        this.themeDirectory = themeDirectory;
        this.themeProperties = themeProperties;
        this.themePluginDirsMap = themePluginDirsMap;
        this.workingDir = workingDir;
        this.projectVersion = projectVersion;
    }

    public void process() {
        Map<String, List<File>> themeFilesMap = this.collectThemeFiles();
        List<File> themeFiles = this.sortThemeFiles(themeFilesMap.get(PLUGIN_FILES_KEY), themeFilesMap.get(SUBDIR_FILES_KEY));
        File mergedFile = this.createMergedFile(false);
        try {
            this.mergeFiles(themeFiles, mergedFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception encountered while merging files for type: " + this.getFileTypeExtension());
        }
        File minifiedFile = this.createMergedFile(true);
        try {
            this.minify(mergedFile, minifiedFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception encountered while minifying files for type: " + this.getFileTypeExtension());
        }
        List<String> themeFilePaths = ThemeBuilderUtils.getRelativePaths(this.workingDir, themeFiles);
        this.themeProperties.put(this.getFileListingConfigKey(), StringUtils.join(themeFilePaths, (String)","));
    }

    protected Map<String, List<File>> collectThemeFiles() {
        HashMap<String, List<File>> themeFiles = new HashMap<String, List<File>>();
        String[] fileIncludes = this.getFileIncludes();
        String[] fileExcludes = this.getFileExcludes();
        String[] pluginFileExcludes = null;
        if (this.themeProperties.containsKey("pluginFileExcludes")) {
            pluginFileExcludes = ThemeBuilderUtils.getPropertyValueAsArray("pluginFileExcludes", this.themeProperties);
        }
        if (fileExcludes != null) {
            pluginFileExcludes = pluginFileExcludes == null ? fileExcludes : ThemeBuilderUtils.addToArray(pluginFileExcludes, fileExcludes);
        }
        ThemeBuilderUtils.addExtensionToPatterns(fileIncludes, this.getFileTypeExtension());
        ThemeBuilderUtils.addExtensionToPatterns(fileExcludes, this.getFileTypeExtension());
        ThemeBuilderUtils.addExtensionToPatterns(pluginFileExcludes, this.getFileTypeExtension());
        ArrayList<File> pluginThemeFiles = new ArrayList<File>();
        for (Map.Entry<String, File> pluginMapping : this.themePluginDirsMap.entrySet()) {
            String pluginName = pluginMapping.getKey();
            File pluginDirectory = pluginMapping.getValue();
            String[] adjustedFileExcludes = null;
            if (pluginFileExcludes != null) {
                adjustedFileExcludes = new String[pluginFileExcludes.length];
                for (int i = 0; i < pluginFileExcludes.length; ++i) {
                    adjustedFileExcludes[i] = StringUtils.removeStart((String)pluginFileExcludes[i], (String)(pluginName + "/"));
                }
            }
            pluginThemeFiles.addAll(ThemeBuilderUtils.getDirectoryFiles(pluginDirectory, fileIncludes, adjustedFileExcludes));
        }
        themeFiles.put(PLUGIN_FILES_KEY, pluginThemeFiles);
        ArrayList<File> subDirThemeFiles = new ArrayList<File>();
        subDirThemeFiles.addAll(ThemeBuilderUtils.getDirectoryFiles(this.getFileTypeSubDirectory(), fileIncludes, fileExcludes));
        this.addAdditionalFiles(subDirThemeFiles);
        themeFiles.put(SUBDIR_FILES_KEY, subDirThemeFiles);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found " + subDirThemeFiles.size() + "file(s) for theme " + this.themeName));
        }
        return themeFiles;
    }

    protected String[] getFileIncludes() {
        return new String[]{"**/*" + this.getFileTypeExtension()};
    }

    protected String[] getFileExcludes() {
        String[] excludes = null;
        if (this.themeProperties.containsKey(this.getExcludesConfigKey())) {
            String excludesString = this.themeProperties.getProperty(this.getExcludesConfigKey());
            excludes = excludesString.split(",");
        }
        return excludes;
    }

    protected File getFileTypeSubDirectory() {
        File subDirectory = new File(this.themeDirectory, this.getFileTypeDirectoryName());
        if (!subDirectory.exists()) {
            throw new RuntimeException("Directory for file type " + this.getFileTypeDirectoryName() + " does not exist for theme: " + this.themeName);
        }
        return subDirectory;
    }

    protected File createMergedFile(boolean minified) {
        String mergedFileName = this.themeName + "." + this.projectVersion;
        if (minified) {
            mergedFileName = mergedFileName + ".min";
        }
        mergedFileName = mergedFileName + this.getFileTypeExtension();
        return new File(this.getFileTypeSubDirectory(), mergedFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeFiles(List<File> filesToMerge, File mergedFile) throws IOException {
        FileOutputStream out = null;
        OutputStreamWriter outWriter = null;
        InputStreamReader reader = null;
        LOG.info((Object)("Creating merged file: " + mergedFile.getPath()));
        try {
            out = new FileOutputStream(mergedFile);
            outWriter = new OutputStreamWriter(out);
            for (File fileToMerge : filesToMerge) {
                reader = new FileReader(fileToMerge);
                String fileContents = IOUtils.toString((Reader)reader);
                if (fileContents == null || "".equals(fileContents)) continue;
                fileContents = this.processMergeFileContents(fileContents, fileToMerge, mergedFile);
                outWriter.append(fileContents);
                outWriter.flush();
            }
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    protected abstract String getFileTypeExtension();

    protected abstract String getFileTypeDirectoryName();

    protected abstract String getExcludesConfigKey();

    protected abstract String getFileListingConfigKey();

    protected abstract void addAdditionalFiles(List<File> var1);

    protected abstract List<File> sortThemeFiles(List<File> var1, List<File> var2);

    protected abstract String processMergeFileContents(String var1, File var2, File var3) throws IOException;

    protected abstract void minify(File var1, File var2) throws IOException;

    protected List<String> getThemePropertyValue(String propertyKey) {
        return ThemeBuilderUtils.getPropertyValueAsList(propertyKey, this.themeProperties);
    }

    protected List<File> getPropertyValueAsPluginDirs(String propertyKey) {
        ArrayList<File> pluginDirs = null;
        List<String> pluginNames = ThemeBuilderUtils.getPropertyValueAsList(propertyKey, this.themeProperties);
        if (pluginNames != null && !pluginNames.isEmpty()) {
            pluginDirs = new ArrayList<File>();
            for (String pluginName : pluginNames) {
                if (!this.themePluginDirsMap.containsKey(pluginName = pluginName.toLowerCase())) {
                    throw new RuntimeException("Invalid plugin name: " + pluginName + " in configuration for property " + propertyKey);
                }
                pluginDirs.add(this.themePluginDirsMap.get(pluginName));
            }
        }
        return pluginDirs;
    }

    protected List<File> addMissingPluginDirs(List<File> pluginList) {
        ArrayList<File> allPluginDirs = new ArrayList<File>();
        if (pluginList != null) {
            allPluginDirs.addAll(pluginList);
        }
        Collection<File> allPlugins = this.themePluginDirsMap.values();
        for (File pluginDir : allPlugins) {
            if (allPluginDirs.contains(pluginDir)) continue;
            allPluginDirs.add(pluginDir);
        }
        return allPluginDirs;
    }
}

