/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.theme.postprocessor;

import java.io.File;
import java.util.HashMap;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.theme.ThemeTestConstants;
import org.kuali.rice.krad.theme.postprocessor.ThemeCssFilesProcessor;

public class ThemeCssFilesProcessorTest {
    protected ThemeCssFilesProcessor cssFilesProcessor;

    @Before
    public void setUp() throws Exception {
        this.cssFilesProcessor = new ThemeCssFilesProcessor("kboot", ThemeTestConstants.THEME_DIRECTORY, new Properties(), new HashMap(), ThemeTestConstants.WORKING_DIR, "2.3.0");
    }

    @Test
    public void testRewriteCssUrls() throws Exception {
        String cssString = "#fancybox-loading, .fancybox-close, .fancybox-prev span, .fancybox-next span {\n\tbackground-image: url('fancybox_sprite.png');\n} .infoGrowl{\n\tbackground: url(\"images/information-frame.png\") no-repeat scroll 5px 5px transparent;\n\tpadding-left: 25px;\n}";
        String expectedCssString = "#fancybox-loading, .fancybox-close, .fancybox-prev span, .fancybox-next span {\n\tbackground-image: url('../subDir2/fancybox_sprite.png');\n} .infoGrowl{\n\tbackground: url(\"../subDir2/images/information-frame.png\") no-repeat scroll 5px 5px transparent;\n\tpadding-left: 25px;\n}";
        File mergedFile = new File("/basedir/subDir1/merge.css");
        File mergeFile = new File("/basedir/subDir2/foo.css");
        String rewriteCssString = this.cssFilesProcessor.rewriteCssUrls(cssString, mergeFile, mergedFile);
        Assert.assertEquals((String)"Url not rewritten correctly in css string", (Object)expectedCssString, (Object)rewriteCssString);
    }
}

