/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.theme.postprocessor;

import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.SourceFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.theme.postprocessor.ThemeFilesProcessor;
import org.kuali.rice.krad.theme.util.ThemeBuilderUtils;

public class ThemeJsFilesProcessor
extends ThemeFilesProcessor {
    private static final Logger LOG = LogManager.getLogger(ThemeJsFilesProcessor.class);

    public ThemeJsFilesProcessor(String themeName, File themeDirectory, Properties themeProperties, Map<String, File> themePluginDirsMap, File workingDir, String projectVersion) {
        super(themeName, themeDirectory, themeProperties, themePluginDirsMap, workingDir, projectVersion);
    }

    @Override
    protected String getFileTypeExtension() {
        return ".js";
    }

    @Override
    protected String getExcludesConfigKey() {
        return "jsExcludes";
    }

    @Override
    protected String getFileTypeDirectoryName() {
        return "scripts";
    }

    @Override
    protected String getFileListingConfigKey() {
        return "themeJsFiles";
    }

    @Override
    protected void addAdditionalFiles(List<File> themeFiles) {
        File kradScriptDir = new File(this.workingDir, "/krad/scripts");
        themeFiles.addAll(ThemeBuilderUtils.getDirectoryFiles(kradScriptDir, this.getFileIncludes(), null));
    }

    @Override
    protected List<File> sortThemeFiles(List<File> pluginFiles, List<File> subDirFiles) {
        List<String> kradScriptOrder;
        List<String> loadJsFirst = this.getThemePropertyValue("jsLoadFirst");
        List<String> loadJsLast = this.getThemePropertyValue("jsLoadLast");
        List<String> pluginJsLoadOrder = this.getThemePropertyValue("pluginJsLoadOrder");
        List<String> jsLoadOrder = this.getThemePropertyValue("themeJsLoadOrder");
        try {
            kradScriptOrder = this.retrieveKradScriptLoadOrder();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to pull KRAD load order property key", e);
        }
        if (kradScriptOrder != null) {
            if (jsLoadOrder == null) {
                jsLoadOrder = new ArrayList<String>();
            }
            jsLoadOrder.addAll(0, kradScriptOrder);
        }
        return ThemeBuilderUtils.orderFiles(pluginFiles, subDirFiles, loadJsFirst, loadJsLast, pluginJsLoadOrder, jsLoadOrder);
    }

    private List<String> retrieveKradScriptLoadOrder() throws IOException {
        Properties loadProperties;
        ArrayList<String> scriptLoadOrder = new ArrayList();
        File kradScriptsDir = new File(this.workingDir, "/krad/scripts");
        File loadPropertiesFile = new File(kradScriptsDir, "load.properties");
        if (!loadPropertiesFile.exists()) {
            throw new RuntimeException("load.properties file not found in KRAD scripts directory");
        }
        try (FileInputStream fileInputStream = new FileInputStream(loadPropertiesFile);){
            loadProperties = new Properties();
            loadProperties.load(fileInputStream);
        }
        if (loadProperties.containsKey("scriptLoadOrder")) {
            scriptLoadOrder = ThemeBuilderUtils.getPropertyValueAsList("scriptLoadOrder", loadProperties);
        }
        List<String> scriptFileNames = ThemeBuilderUtils.getDirectoryFileNames(kradScriptsDir, null, null);
        for (String scriptFileName : scriptFileNames) {
            String baseScriptFileName = StringUtils.substringBeforeLast((String)scriptFileName, (String)".");
            if (scriptLoadOrder.contains(baseScriptFileName)) continue;
            scriptLoadOrder.add(baseScriptFileName);
        }
        return scriptLoadOrder;
    }

    @Override
    protected String processMergeFileContents(String fileContents, File fileToMerge, File mergedFile) {
        if (fileContents != null && !((String)fileContents).matches("(?s).*;\\s*$")) {
            fileContents = (String)fileContents + ";";
        }
        return fileContents;
    }

    @Override
    protected void minify(File mergedFile, File minifiedFile) throws IOException {
        LOG.info("Populating minified JS file: " + minifiedFile.getPath());
        try (FileInputStream in = new FileInputStream(mergedFile);
             FileOutputStream out = new FileOutputStream(minifiedFile);
             OutputStreamWriter writer = new OutputStreamWriter(out);){
            CompilerOptions options = new CompilerOptions();
            CompilationLevel.WHITESPACE_ONLY.setOptionsForCompilationLevel(options);
            options.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT5);
            options.setExtraAnnotationNames(this.ignoredAnnotations());
            SourceFile input = SourceFile.builder().withPath(mergedFile.getName()).withContent((InputStream)in).withCharset(StandardCharsets.UTF_8).build();
            List externs = Collections.emptyList();
            Compiler compiler = new Compiler();
            compiler.compile(externs, Collections.singletonList(input), options);
            writer.append(compiler.toSource());
            writer.flush();
        }
    }

    private Set<String> ignoredAnnotations() {
        HashSet<String> annotations = new HashSet<String>();
        annotations.add("dtopt");
        annotations.add("result");
        annotations.add("cat");
        annotations.add("parm");
        return annotations;
    }
}

