/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.criteria;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.criteria.AndPredicate;
import org.kuali.rice.core.api.criteria.CompositePredicate;
import org.kuali.rice.core.api.criteria.CountFlag;
import org.kuali.rice.core.api.criteria.CriteriaValue;
import org.kuali.rice.core.api.criteria.EqualIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.EqualPredicate;
import org.kuali.rice.core.api.criteria.GenericQueryResults;
import org.kuali.rice.core.api.criteria.GreaterThanOrEqualPredicate;
import org.kuali.rice.core.api.criteria.GreaterThanPredicate;
import org.kuali.rice.core.api.criteria.InIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.InPredicate;
import org.kuali.rice.core.api.criteria.LessThanOrEqualPredicate;
import org.kuali.rice.core.api.criteria.LessThanPredicate;
import org.kuali.rice.core.api.criteria.LikePredicate;
import org.kuali.rice.core.api.criteria.LookupCustomizer;
import org.kuali.rice.core.api.criteria.MultiValuedPredicate;
import org.kuali.rice.core.api.criteria.NotEqualIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.NotEqualPredicate;
import org.kuali.rice.core.api.criteria.NotInIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.NotInPredicate;
import org.kuali.rice.core.api.criteria.NotLikePredicate;
import org.kuali.rice.core.api.criteria.NotNullPredicate;
import org.kuali.rice.core.api.criteria.NullPredicate;
import org.kuali.rice.core.api.criteria.OrPredicate;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PropertyPathPredicate;
import org.kuali.rice.core.api.criteria.SingleValuedPredicate;
import org.kuali.rice.core.framework.persistence.jpa.criteria.Criteria;
import org.kuali.rice.core.framework.persistence.jpa.criteria.QueryByCriteria;
import org.kuali.rice.krad.criteria.CriteriaLookupDao;

public class CriteriaLookupDaoJpa
implements CriteriaLookupDao {
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public <T> GenericQueryResults<T> lookup(Class<T> queryClass, org.kuali.rice.core.api.criteria.QueryByCriteria criteria) {
        return this.lookup(queryClass, criteria, LookupCustomizer.Builder.create().build());
    }

    @Override
    public <T> GenericQueryResults<T> lookup(Class<T> queryClass, org.kuali.rice.core.api.criteria.QueryByCriteria criteria, LookupCustomizer<T> customizer) {
        if (queryClass == null) {
            throw new IllegalArgumentException("queryClass is null");
        }
        if (criteria == null) {
            throw new IllegalArgumentException("criteria is null");
        }
        if (customizer == null) {
            throw new IllegalArgumentException("customizer is null");
        }
        Criteria parent = new Criteria(queryClass.getClass().getName());
        if (criteria.getPredicate() != null) {
            this.addPredicate(criteria.getPredicate(), parent, (LookupCustomizer.Transform<Predicate, Predicate>)customizer.getPredicateTransform());
        }
        switch (criteria.getCountFlag()) {
            case ONLY: {
                return this.forCountOnly(queryClass, criteria, parent);
            }
            case NONE: {
                return this.forRowResults(queryClass, criteria, parent, criteria.getCountFlag(), customizer.getResultTransform());
            }
            case INCLUDE: {
                return this.forRowResults(queryClass, criteria, parent, criteria.getCountFlag(), customizer.getResultTransform());
            }
        }
        throw new UnsupportedCountFlagException(criteria.getCountFlag());
    }

    private <T> GenericQueryResults<T> forRowResults(Class<T> queryClass, org.kuali.rice.core.api.criteria.QueryByCriteria criteria, Criteria jpaCriteria, CountFlag flag, LookupCustomizer.Transform<T, T> transform) {
        Query jpaQuery = new QueryByCriteria(this.entityManager, jpaCriteria).toQuery();
        GenericQueryResults.Builder results = GenericQueryResults.Builder.create();
        int startAtIndex = criteria.getStartAtIndex() != null ? criteria.getStartAtIndex() + 1 : 1;
        jpaQuery.setFirstResult(startAtIndex);
        if (criteria.getMaxResults() != null) {
            jpaQuery.setMaxResults(criteria.getMaxResults().intValue());
        }
        ArrayList rows = new ArrayList(jpaQuery.getResultList());
        if (flag == CountFlag.INCLUDE) {
            results.setTotalRowCount(Integer.valueOf(rows.size()));
        }
        if (criteria.getMaxResults() != null && rows.size() > criteria.getMaxResults()) {
            results.setMoreResultsAvailable(true);
            rows.remove(criteria.getMaxResults());
        }
        results.setResults(CriteriaLookupDaoJpa.transformResults(rows, transform));
        return results.build();
    }

    private static <T> List<T> transformResults(List<T> results, LookupCustomizer.Transform<T, T> transform) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (T r : results) {
            list.add(transform.apply(r));
        }
        return list;
    }

    private <T> GenericQueryResults<T> forCountOnly(Class<T> queryClass, org.kuali.rice.core.api.criteria.QueryByCriteria criteria, Criteria jpaCriteria) {
        Query jpaQuery = new QueryByCriteria(this.entityManager, jpaCriteria).toQuery();
        GenericQueryResults.Builder results = GenericQueryResults.Builder.create();
        results.setTotalRowCount(Integer.valueOf(jpaQuery.getResultList().size()));
        return results.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addPredicate(Predicate p, Criteria parent, LookupCustomizer.Transform<Predicate, Predicate> transform) {
        if ((p = (Predicate)transform.apply((Object)p)) instanceof PropertyPathPredicate) {
            String pp = ((PropertyPathPredicate)p).getPropertyPath();
            if (p instanceof NotNullPredicate) {
                parent.notNull(pp);
                return;
            } else if (p instanceof NullPredicate) {
                parent.isNull(pp);
                return;
            } else if (p instanceof SingleValuedPredicate) {
                this.addSingleValuePredicate((SingleValuedPredicate)p, parent);
                return;
            } else {
                if (!(p instanceof MultiValuedPredicate)) throw new UnsupportedPredicateException(p);
                this.addMultiValuePredicate((MultiValuedPredicate)p, parent);
            }
            return;
        } else {
            if (!(p instanceof CompositePredicate)) throw new UnsupportedPredicateException(p);
            this.addCompositePredicate((CompositePredicate)p, parent, transform);
        }
    }

    private void addSingleValuePredicate(SingleValuedPredicate p, Criteria parent) {
        Object value = CriteriaLookupDaoJpa.getVal(p.getValue());
        String pp = p.getPropertyPath();
        if (p instanceof EqualPredicate) {
            parent.eq(pp, value);
        } else if (p instanceof EqualIgnoreCasePredicate) {
            parent.eq(this.genUpperFunc(pp), (Object)((String)value).toUpperCase());
        } else if (p instanceof GreaterThanOrEqualPredicate) {
            parent.gte(pp, value);
        } else if (p instanceof GreaterThanPredicate) {
            parent.gt(pp, value);
        } else if (p instanceof LessThanOrEqualPredicate) {
            parent.lte(pp, value);
        } else if (p instanceof LessThanPredicate) {
            parent.lt(pp, value);
        } else if (p instanceof LikePredicate) {
            parent.like(pp, value);
        } else if (p instanceof NotEqualPredicate) {
            parent.ne(pp, value);
        } else if (p instanceof NotEqualIgnoreCasePredicate) {
            parent.ne(this.genUpperFunc(pp), (Object)((String)value).toUpperCase());
        } else if (p instanceof NotLikePredicate) {
            parent.notLike(pp, value);
        } else {
            throw new UnsupportedPredicateException((Predicate)p);
        }
    }

    private void addMultiValuePredicate(MultiValuedPredicate p, Criteria parent) {
        String pp = p.getPropertyPath();
        if (p instanceof InPredicate) {
            Set<?> values = CriteriaLookupDaoJpa.getVals(p.getValues());
            parent.in(pp, values);
        } else if (p instanceof InIgnoreCasePredicate) {
            Set<String> values = CriteriaLookupDaoJpa.toUpper(CriteriaLookupDaoJpa.getValsUnsafe(((InIgnoreCasePredicate)p).getValues()));
            parent.in(this.genUpperFunc(pp), values);
        } else if (p instanceof NotInPredicate) {
            Set<?> values = CriteriaLookupDaoJpa.getVals(p.getValues());
            parent.notIn(pp, values);
        } else if (p instanceof NotInIgnoreCasePredicate) {
            Set<String> values = CriteriaLookupDaoJpa.toUpper(CriteriaLookupDaoJpa.getValsUnsafe(((NotInIgnoreCasePredicate)p).getValues()));
            parent.notIn(this.genUpperFunc(pp), values);
        } else {
            throw new UnsupportedPredicateException((Predicate)p);
        }
    }

    private void addCompositePredicate(CompositePredicate p, Criteria parent, LookupCustomizer.Transform<Predicate, Predicate> transform) {
        for (Predicate ip : p.getPredicates()) {
            Criteria inner = new Criteria(parent.getEntityName());
            this.addPredicate(ip, inner, transform);
            if (p instanceof AndPredicate) {
                parent.and(inner);
                continue;
            }
            if (p instanceof OrPredicate) {
                parent.or(inner);
                continue;
            }
            throw new UnsupportedPredicateException((Predicate)p);
        }
    }

    private static <U extends CriteriaValue<?>> Object getVal(U toConv) {
        Object o = toConv.getValue();
        if (o instanceof DateTime) {
            return new Timestamp(((DateTime)o).getMillis());
        }
        return o;
    }

    private static <T, U extends CriteriaValue<T>> Set<T> getValsUnsafe(Set<? extends U> toConv) {
        return CriteriaLookupDaoJpa.getVals(toConv);
    }

    private static Set<?> getVals(Set<? extends CriteriaValue<?>> toConv) {
        HashSet<Object> values = new HashSet<Object>();
        for (CriteriaValue<?> value : toConv) {
            values.add(CriteriaLookupDaoJpa.getVal(value));
        }
        return values;
    }

    private static Set<String> toUpper(Set<String> strs) {
        HashSet<String> values = new HashSet<String>();
        for (String value : strs) {
            values.add(value.toUpperCase());
        }
        return values;
    }

    private String genUpperFunc(String pp) {
        pp = StringUtils.contains((String)pp, (String)"__JPA_ALIAS[[") ? "UPPER(" + pp + ")" : "UPPER(__JPA_ALIAS[[0]]__." + pp + ")";
        return pp;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    private static class UnsupportedCountFlagException
    extends RuntimeException {
        private UnsupportedCountFlagException(CountFlag flag) {
            super("Unsupported predicate [" + String.valueOf(flag) + "]");
        }
    }

    private static class UnsupportedPredicateException
    extends RuntimeException {
        private UnsupportedPredicateException(Predicate predicate) {
            super("Unsupported predicate [" + String.valueOf(predicate) + "]");
        }
    }
}

