/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import org.kuali.rice.krad.datadictionary.DataDictionaryDefinitionBase;
import org.kuali.rice.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.rice.krad.datadictionary.mask.MaskFormatter;

public class AttributeSecurity
extends DataDictionaryDefinitionBase {
    private static final long serialVersionUID = -7923499408946975318L;
    private boolean readOnly = false;
    private boolean hide = false;
    private boolean mask = false;
    private boolean partialMask = false;
    private MaskFormatter partialMaskFormatter;
    private MaskFormatter maskFormatter;

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isHide() {
        return this.hide;
    }

    public void setHide(boolean hide) {
        this.hide = hide;
    }

    public boolean isMask() {
        return this.mask;
    }

    public void setMask(boolean mask) {
        this.mask = mask;
    }

    public boolean isPartialMask() {
        return this.partialMask;
    }

    public void setPartialMask(boolean partialMask) {
        this.partialMask = partialMask;
    }

    public MaskFormatter getMaskFormatter() {
        return this.maskFormatter;
    }

    public void setMaskFormatter(MaskFormatter maskFormatter) {
        this.maskFormatter = maskFormatter;
    }

    public MaskFormatter getPartialMaskFormatter() {
        return this.partialMaskFormatter;
    }

    public void setPartialMaskFormatter(MaskFormatter partialMaskFormatter) {
        this.partialMaskFormatter = partialMaskFormatter;
    }

    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass) {
        if (this.mask && this.maskFormatter == null) {
            throw new AttributeValidationException("MaskFormatter is required");
        }
        if (this.partialMask && this.partialMaskFormatter == null) {
            throw new AttributeValidationException("PartialMaskFormatter is required");
        }
    }

    public boolean hasAnyRestriction() {
        return this.readOnly || this.mask || this.partialMask || this.hide;
    }

    public boolean hasRestrictionThatRemovesValueFromUI() {
        return this.mask || this.partialMask || this.hide;
    }
}

