/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.datadictionary.ReferenceDefinition;
import org.kuali.rice.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.rice.krad.datadictionary.exception.ClassValidationException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.maintenance.Maintainable;
import org.kuali.rice.krad.maintenance.MaintenanceDocumentAuthorizer;
import org.kuali.rice.krad.maintenance.MaintenanceDocumentAuthorizerBase;
import org.kuali.rice.krad.maintenance.MaintenanceDocumentBase;
import org.kuali.rice.krad.maintenance.MaintenanceDocumentPresentationControllerBase;

public class MaintenanceDocumentEntry
extends DocumentEntry {
    private static final long serialVersionUID = 4990040987835057251L;
    protected Class<?> dataObjectClass;
    protected Class<? extends Maintainable> maintainableClass;
    protected List<String> lockingKeys = new ArrayList<String>();
    protected boolean allowsNewOrCopy = true;
    protected boolean preserveLockingKeysOnCopy = false;
    protected boolean allowsRecordDeletion = false;

    public MaintenanceDocumentEntry() {
        this.setDocumentClass(this.getStandardDocumentBaseClass());
        this.documentAuthorizerClass = MaintenanceDocumentAuthorizerBase.class;
        this.documentPresentationControllerClass = MaintenanceDocumentPresentationControllerBase.class;
    }

    public Class<? extends Document> getStandardDocumentBaseClass() {
        return MaintenanceDocumentBase.class;
    }

    public void setDataObjectClass(Class<?> dataObjectClass) {
        if (dataObjectClass == null) {
            throw new IllegalArgumentException("invalid (null) dataObjectClass");
        }
        this.dataObjectClass = dataObjectClass;
    }

    public Class<?> getDataObjectClass() {
        return this.dataObjectClass;
    }

    @Override
    public Class getEntryClass() {
        return this.dataObjectClass;
    }

    public void setMaintainableClass(Class<? extends Maintainable> maintainableClass) {
        if (maintainableClass == null) {
            throw new IllegalArgumentException("invalid (null) maintainableClass");
        }
        this.maintainableClass = maintainableClass;
    }

    public Class<? extends Maintainable> getMaintainableClass() {
        return this.maintainableClass;
    }

    public List<String> getLockingKeyFieldNames() {
        return this.lockingKeys;
    }

    public boolean getAllowsNewOrCopy() {
        return this.allowsNewOrCopy;
    }

    public void setAllowsNewOrCopy(boolean allowsNewOrCopy) {
        this.allowsNewOrCopy = allowsNewOrCopy;
    }

    @Override
    public void completeValidation() {
        super.completeValidation();
        for (String lockingKey : this.lockingKeys) {
            if (DataDictionary.isPropertyOf(this.dataObjectClass, lockingKey)) continue;
            throw new AttributeValidationException("unable to find attribute '" + lockingKey + "' for lockingKey in dataObjectClass '" + this.dataObjectClass.getName());
        }
        for (ReferenceDefinition reference : this.defaultExistenceChecks) {
            reference.completeValidation((Class)this.dataObjectClass, (Class)null);
        }
        if (this.documentAuthorizerClass != null && !MaintenanceDocumentAuthorizer.class.isAssignableFrom(this.documentAuthorizerClass)) {
            throw new ClassValidationException("This maintenance document for '" + this.getDataObjectClass().getName() + "' has an invalid " + "documentAuthorizerClass ('" + this.documentAuthorizerClass.getName() + "').  " + "Maintenance Documents must use an implementation of MaintenanceDocumentAuthorizer.");
        }
    }

    @Override
    public String toString() {
        return "MaintenanceDocumentEntry for documentType " + this.getDocumentTypeName();
    }

    public List<String> getLockingKeys() {
        return this.lockingKeys;
    }

    public void setLockingKeys(List<String> lockingKeys) {
        for (String lockingKey : lockingKeys) {
            if (lockingKey != null) continue;
            throw new IllegalArgumentException("invalid (null) lockingKey");
        }
        this.lockingKeys = lockingKeys;
    }

    public boolean getPreserveLockingKeysOnCopy() {
        return this.preserveLockingKeysOnCopy;
    }

    public void setPreserveLockingKeysOnCopy(boolean preserveLockingKeysOnCopy) {
        this.preserveLockingKeysOnCopy = preserveLockingKeysOnCopy;
    }

    public boolean getAllowsRecordDeletion() {
        return this.allowsRecordDeletion;
    }

    public void setAllowsRecordDeletion(boolean allowsRecordDeletion) {
        this.allowsRecordDeletion = allowsRecordDeletion;
    }
}

