/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.DataDictionaryDefinitionBase;
import org.kuali.rice.krad.datadictionary.exception.AttributeValidationException;

public class PrimitiveAttributeDefinition
extends DataDictionaryDefinitionBase {
    private static final long serialVersionUID = -715128943756700821L;
    protected String sourceName;
    protected String targetName;

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        if (StringUtils.isBlank((String)sourceName)) {
            throw new IllegalArgumentException("invalid (blank) sourceName");
        }
        this.sourceName = sourceName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        if (StringUtils.isBlank((String)targetName)) {
            throw new IllegalArgumentException("invalid (blank) targetName");
        }
        this.targetName = targetName;
    }

    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass) {
        if (!DataDictionary.isPropertyOf(rootBusinessObjectClass, this.sourceName)) {
            throw new AttributeValidationException("unable to find attribute '" + this.sourceName + "' in relationship class '" + rootBusinessObjectClass + "' (" + "" + ")");
        }
        if (!DataDictionary.isPropertyOf(otherBusinessObjectClass, this.targetName)) {
            throw new AttributeValidationException("unable to find attribute '" + this.targetName + "' in related class '" + otherBusinessObjectClass.getName() + "' (" + "" + ")");
        }
        Class sourceClass = DataDictionary.getAttributeClass(rootBusinessObjectClass, this.sourceName);
        Class targetClass = DataDictionary.getAttributeClass(otherBusinessObjectClass, this.targetName);
        if (null == sourceClass && null != targetClass || null != sourceClass && null == targetClass || !StringUtils.equals((String)sourceClass.getName(), (String)targetClass.getName())) {
            String sourceClassName = rootBusinessObjectClass.getName();
            String targetClassName = otherBusinessObjectClass.getName();
            String sourcePath = sourceClassName + "." + this.sourceName;
            String targetPath = targetClassName + "." + this.targetName;
            if (sourcePath != null && !StringUtils.contains((String)sourcePath, (String)".principalId") && targetPath != null && !StringUtils.contains((String)targetPath, (String)".principalId")) {
                throw new AttributeValidationException("source attribute '" + sourcePath + "' (" + sourceClass + ") and target attribute '" + targetPath + "' (" + targetClass + ") are of differing types (" + "" + ")");
            }
        }
    }

    public String toString() {
        return "PrimitiveAttributeDefinition (" + this.getSourceName() + "," + this.getTargetName() + ")";
    }
}

