/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.PrimitiveAttributeDefinition;
import org.kuali.rice.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.rice.krad.util.ExternalizableBusinessObjectUtils;

public class SupportAttributeDefinition
extends PrimitiveAttributeDefinition {
    private static final long serialVersionUID = -1719022365280776405L;
    protected boolean identifier;

    public boolean isIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(boolean identifier) {
        this.identifier = identifier;
    }

    @Override
    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass) {
        if (!DataDictionary.isPropertyOf(rootBusinessObjectClass, this.getSourceName())) {
            throw new AttributeValidationException("unable to find attribute '" + this.getSourceName() + "' in relationship class '" + rootBusinessObjectClass + "' (" + "" + ")");
        }
        if (!DataDictionary.isPropertyOf(otherBusinessObjectClass, this.getTargetName()) && !ExternalizableBusinessObjectUtils.isExternalizableBusinessObjectInterface((Class)otherBusinessObjectClass)) {
            throw new AttributeValidationException("unable to find attribute '" + this.getTargetName() + "' in related class '" + otherBusinessObjectClass.getName() + "' (" + "" + ")");
        }
    }

    @Override
    public String toString() {
        return "SupportAttributeDefinition (" + this.getSourceName() + "," + this.getTargetName() + "," + this.identifier + ")";
    }
}

