/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.BaseAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.capability.Constrainable;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;

public class ViewAttributeValueReader
extends BaseAttributeValueReader {
    private View view;
    private Object form;
    private List<Constrainable> inputFields = new ArrayList<Constrainable>();
    private Map<String, InputField> inputFieldMap = new HashMap<String, InputField>();

    public ViewAttributeValueReader(View view, Object form) {
        this.view = view;
        this.form = form;
        for (InputField field : view.getAllInputFields()) {
            this.inputFields.add(field);
            this.inputFieldMap.put(field.getName(), field);
        }
    }

    @Override
    public Constrainable getDefinition(String attributeName) {
        InputField field = this.inputFieldMap.get(attributeName);
        if (field != null) {
            return field;
        }
        return null;
    }

    @Override
    public List<Constrainable> getDefinitions() {
        return this.inputFields;
    }

    @Override
    public String getLabel(String attributeName) {
        InputField field = this.inputFieldMap.get(attributeName);
        if (field != null) {
            return field.getLabel();
        }
        return null;
    }

    @Override
    public Object getObject() {
        return this.view;
    }

    @Override
    public Constrainable getEntry() {
        return null;
    }

    @Override
    public String getPath() {
        return this.attributeName;
    }

    @Override
    public Class<?> getType(String attributeName) {
        Object fieldValue = ObjectPropertyUtils.getPropertyValue(this.form, attributeName);
        return fieldValue.getClass();
    }

    @Override
    public boolean isReadable() {
        return this.attributeName == null || !this.attributeName.contains("newCollectionLines");
    }

    @Override
    public <X> X getValue() throws AttributeValidationException {
        X fieldValue = null;
        if (StringUtils.isNotBlank((String)this.attributeName)) {
            fieldValue = (X)ObjectPropertyUtils.getPropertyValue(this.form, this.attributeName);
        }
        return fieldValue;
    }

    @Override
    public <X> X getValue(String attributeName) throws AttributeValidationException {
        X fieldValue = null;
        if (StringUtils.isNotBlank((String)attributeName)) {
            fieldValue = (X)ObjectPropertyUtils.getPropertyValue(this.form, this.attributeName);
        }
        return fieldValue;
    }

    @Override
    public AttributeValueReader clone() {
        ViewAttributeValueReader clone = new ViewAttributeValueReader(this.view, this.form);
        clone.setAttributeName(this.attributeName);
        return clone;
    }
}

