/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.validation.constraint.AllowCharacterConstraint;

public class AlphaPatternConstraint
extends AllowCharacterConstraint {
    protected boolean lowerCase = false;
    protected boolean upperCase = false;

    @Override
    protected String getRegexString() {
        StringBuilder regexString = new StringBuilder("[A-Za-z");
        if (this.lowerCase) {
            regexString = new StringBuilder("[a-z");
        } else if (this.upperCase) {
            regexString = new StringBuilder("[A-Z");
        }
        regexString.append(this.getAllowedCharacterRegex());
        regexString.append("]");
        return regexString.toString();
    }

    @Override
    public String getLabelKey() {
        if (StringUtils.isEmpty((String)this.labelKey)) {
            StringBuilder key = new StringBuilder("");
            if (this.lowerCase) {
                return "validation.alphaPatternLowerCase";
            }
            if (this.upperCase) {
                return "validation.alphaPatternUpperCase";
            }
            return "validation.alphaPattern";
        }
        return this.labelKey;
    }

    public boolean isLowerCase() {
        return this.lowerCase;
    }

    public void setLowerCase(boolean lowerCase) {
        this.lowerCase = lowerCase;
    }

    public boolean isUpperCase() {
        return this.upperCase;
    }

    public void setUpperCase(boolean upperCase) {
        this.upperCase = upperCase;
    }
}

