/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersPatternConstraint;

public class AnyCharacterPatternConstraint
extends ValidCharactersPatternConstraint {
    protected boolean allowWhitespace = false;
    protected boolean omitNewline = false;

    public boolean getAllowWhitespace() {
        return this.allowWhitespace;
    }

    public void setAllowWhitespace(boolean allowWhitespace) {
        this.allowWhitespace = allowWhitespace;
    }

    @Override
    protected String getRegexString() {
        StringBuffer regexString = new StringBuffer("[");
        regexString.append("\\x21-\\x7E");
        if (this.allowWhitespace) {
            regexString.append("\\t\\v\\040");
            if (!this.omitNewline) {
                regexString.append("\\f\\r\\n");
            }
        }
        regexString.append("]");
        return regexString.toString();
    }

    @Override
    public String getLabelKey() {
        String labelKey = super.getLabelKey();
        if (StringUtils.isNotEmpty((String)labelKey)) {
            return labelKey;
        }
        if (!this.allowWhitespace) {
            return "validation.noWhitespace";
        }
        return "validation.anyCharacterPattern";
    }

    public boolean isOmitNewline() {
        return this.omitNewline;
    }

    public void setOmitNewline(boolean omitNewline) {
        this.omitNewline = omitNewline;
    }
}

