/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidDataPatternConstraint;

public class DatePatternConstraint
extends ValidDataPatternConstraint {
    private List<String> allowedFormats;

    @Override
    protected String getRegexString() {
        List<String> dateFormatParams = this.parseConfigValues(ConfigContext.getCurrentContextConfig().getProperty("STRING_TO_DATE_FORMATS"));
        if (this.allowedFormats != null && !this.allowedFormats.isEmpty() && dateFormatParams.containsAll(this.allowedFormats)) {
            dateFormatParams = this.allowedFormats;
        }
        if (dateFormatParams.isEmpty()) {
            // empty if block
        }
        String regex = "";
        int i = 0;
        for (String format : dateFormatParams) {
            regex = i == 0 ? "(^" + this.convertDateFormatToRegex(format.trim()) + "$)" : regex + "|(^" + this.convertDateFormatToRegex(format.trim()) + "$)";
            ++i;
        }
        return regex;
    }

    private String convertDateFormatToRegex(String format) {
        format = format.replace("\\", "\\\\").replace(".", "\\.").replace("-", "\\-").replace("+", "\\+").replace("(", "\\(").replace(")", "\\)").replace("[", "\\[").replace("]", "\\]").replace("|", "\\|").replace("yyyy", "((19|2[0-9])[0-9]{2})").replace("yy", "([0-9]{2})").replaceAll("M{4,}", "([@]+)").replace("MMM", "([@]{3})").replace("MM", "(0[1-9]|1[012])").replace("M", "(0?[1-9]|1[012])").replace("dd", "(0[1-9]|[12][0-9]|3[01])").replace("d", "(0?[1-9]|[12][0-9]|3[01])").replace("hh", "(1[0-2]|0[1-9])").replace("h", "(1[0-2]|0?[1-9])").replace("HH", "(2[0-3]|1[0-9]|0[0-9])").replace("H", "(2[0-3]|1[0-9]|0?[0-9])").replace("kk", "(2[0-4]|1[0-9]|0[1-9])").replace("k", "(2[0-4]|1[0-9]|0?[1-9])").replace("KK", "(1[01]|0[0-9])").replace("K", "(1[01]|0?[0-9])").replace("mm", "([0-5][0-9])").replace("m", "([1-5][0-9]|0?[0-9])").replace("ss", "([0-5][0-9])").replace("s", "([1-5][0-9]|0?[0-9])").replace("SSS", "([0-9][0-9][0-9])").replace("SS", "([0-9][0-9][0-9]?)").replace("S", "([0-9][0-9]?[0-9]?)").replaceAll("E{4,}", "([@]+)").replaceAll("E{1,3}", "([@]{3})").replace("DDD", "(3[0-6][0-5]|[1-2][0-9][0-9]|0[0-9][1-9])").replace("DD", "(3[0-6][0-5]|[1-2][0-9][0-9]|0?[0-9][1-9])").replace("D", "(3[0-6][0-5]|[1-2][0-9][0-9]|0?[0-9]?[1-9])").replace("F", "([1-5])").replace("ww", "(5[0-3]|[1-4][0-9]|0[1-9])").replace("w", "(5[0-3]|[1-4][0-9]|[1-9])").replace("W", "([1-5])").replaceAll("z{4,}", "([@]+)").replaceAll("z{1,3}", "([@]{1,4})").replaceAll("a{1,}", "([aApP][mM])").replaceAll("G{1,}", "([aA][dD]|[bB][cC])").replace(" ", "\\s").replace("@", "a-zA-Z");
        return format;
    }

    private List<String> parseConfigValues(String configValue) {
        if (configValue == null || "".equals(configValue)) {
            return Collections.emptyList();
        }
        return Arrays.asList(configValue.split(";"));
    }

    public List<String> getAllowedFormats() {
        return this.allowedFormats;
    }

    public void setAllowedFormats(List<String> allowedFormats) {
        this.allowedFormats = allowedFormats;
    }

    @Override
    public List<String> getValidationMessageParams() {
        if (this.validationMessageParams == null) {
            this.validationMessageParams = new ArrayList();
            if (this.allowedFormats != null && !this.allowedFormats.isEmpty()) {
                this.validationMessageParams.add(StringUtils.join(this.allowedFormats, (String)", "));
            } else {
                List<String> dateFormatParams = this.parseConfigValues(ConfigContext.getCurrentContextConfig().getProperty("STRING_TO_DATE_FORMATS"));
                this.validationMessageParams.add(StringUtils.join(dateFormatParams, (String)", "));
            }
        }
        return this.validationMessageParams;
    }
}

