/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidDataPatternConstraint;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class FixedPointPatternConstraint
extends ValidDataPatternConstraint {
    protected boolean allowNegative;
    protected int precision;
    protected int scale;

    @Override
    protected String getRegexString() {
        StringBuilder regex = new StringBuilder();
        if (this.isAllowNegative()) {
            regex.append("-?");
        }
        regex.append("(");
        regex.append("[0-9]{0," + (this.getPrecision() - this.getScale()) + "}");
        regex.append("\\.");
        regex.append("[0-9]{1," + this.getScale() + "}");
        regex.append("|[0-9]{1," + (this.getPrecision() - this.getScale()) + "}");
        regex.append(")");
        return regex.toString();
    }

    public boolean isAllowNegative() {
        return this.allowNegative;
    }

    public void setAllowNegative(boolean allowNegative) {
        this.allowNegative = allowNegative;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public List<String> getValidationMessageParams() {
        if (this.validationMessageParams == null) {
            this.validationMessageParams = new ArrayList();
            ConfigurationService configService = KRADServiceLocator.getKualiConfigurationService();
            if (this.allowNegative) {
                this.validationMessageParams.add(configService.getPropertyValueAsString("validation.positiveOrNegative"));
            } else {
                this.validationMessageParams.add(configService.getPropertyValueAsString("validation.positive"));
            }
            this.validationMessageParams.add(Integer.toString(this.precision));
            this.validationMessageParams.add(Integer.toString(this.scale));
        }
        return this.validationMessageParams;
    }
}

