/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.processor;

import org.kuali.rice.core.api.uif.DataType;
import org.kuali.rice.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ValidationUtils;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.LengthConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.MandatoryElementConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.ProcessorResult;

public class LengthConstraintProcessor
extends MandatoryElementConstraintProcessor<LengthConstraint> {
    private static final String MIN_LENGTH_KEY = "validation.minLengthConditional";
    private static final String MAX_LENGTH_KEY = "validation.maxLengthConditional";
    private static final String RANGE_KEY = "validation.lengthRange";
    private static final String CONSTRAINT_NAME = "length constraint";

    @Override
    public ProcessorResult process(DictionaryValidationResult result, Object value, LengthConstraint constraint, AttributeValueReader attributeValueReader) throws AttributeValidationException {
        return new ProcessorResult(this.processSingleLengthConstraint(result, value, constraint, attributeValueReader));
    }

    @Override
    public String getName() {
        return CONSTRAINT_NAME;
    }

    @Override
    public Class<? extends Constraint> getConstraintType() {
        return LengthConstraint.class;
    }

    protected ConstraintValidationResult processSingleLengthConstraint(DictionaryValidationResult result, Object value, LengthConstraint constraint, AttributeValueReader attributeValueReader) throws AttributeValidationException {
        if (ValidationUtils.isNullOrEmpty(value)) {
            return result.addSkipped(attributeValueReader, CONSTRAINT_NAME);
        }
        DataType dataType = constraint.getDataType();
        Object typedValue = value;
        if (dataType != null) {
            typedValue = ValidationUtils.convertToDataType(value, dataType, this.dateTimeService);
        }
        if (typedValue instanceof String) {
            return this.validateLength(result, (String)typedValue, constraint, attributeValueReader);
        }
        return result.addSkipped(attributeValueReader, CONSTRAINT_NAME);
    }

    protected ConstraintValidationResult validateLength(DictionaryValidationResult result, String value, LengthConstraint constraint, AttributeValueReader attributeValueReader) throws IllegalArgumentException {
        String minErrorParameter;
        Integer valueLength = value.length();
        Integer maxLength = constraint.getMaxLength();
        Integer minLength = constraint.getMinLength();
        ValidationUtils.Result lessThanMax = ValidationUtils.isLessThanOrEqual(valueLength, maxLength);
        ValidationUtils.Result greaterThanMin = ValidationUtils.isGreaterThanOrEqual(valueLength, minLength);
        if (lessThanMax != ValidationUtils.Result.INVALID && greaterThanMin != ValidationUtils.Result.INVALID) {
            if (lessThanMax == ValidationUtils.Result.UNDEFINED && greaterThanMin == ValidationUtils.Result.UNDEFINED) {
                return result.addNoConstraint(attributeValueReader, CONSTRAINT_NAME);
            }
            return result.addSuccess(attributeValueReader, CONSTRAINT_NAME);
        }
        String maxErrorParameter = maxLength != null ? maxLength.toString() : null;
        String string = minErrorParameter = minLength != null ? minLength.toString() : null;
        if (lessThanMax != ValidationUtils.Result.UNDEFINED && greaterThanMin != ValidationUtils.Result.UNDEFINED) {
            return result.addError(RANGE_KEY, attributeValueReader, CONSTRAINT_NAME, "error.outOfRange", minErrorParameter, maxErrorParameter);
        }
        if (lessThanMax == ValidationUtils.Result.INVALID) {
            return result.addError(MAX_LENGTH_KEY, attributeValueReader, CONSTRAINT_NAME, "error.inclusiveMax", maxErrorParameter);
        }
        return result.addError(MIN_LENGTH_KEY, attributeValueReader, CONSTRAINT_NAME, "error.exclusiveMin", minErrorParameter);
    }
}

