/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.processor;

import java.util.List;
import org.kuali.rice.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.ValidationUtils;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.MustOccurConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.PrerequisiteConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.BasePrerequisiteConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.ProcessorResult;

public class MustOccurConstraintProcessor
extends BasePrerequisiteConstraintProcessor<MustOccurConstraint> {
    private static final String CONSTRAINT_NAME = "must occur constraint";

    @Override
    public ProcessorResult process(DictionaryValidationResult result, Object value, MustOccurConstraint constraint, AttributeValueReader attributeValueReader) throws AttributeValidationException {
        if (ValidationUtils.isNullOrEmpty(value)) {
            return new ProcessorResult(result.addSkipped(attributeValueReader, CONSTRAINT_NAME));
        }
        ConstraintValidationResult constraintValidationResult = new ConstraintValidationResult(CONSTRAINT_NAME);
        constraintValidationResult.setConstraintLabelKey(constraint.getLabelKey());
        constraintValidationResult.setErrorParameters(constraint.getValidationMessageParamsArray());
        if (!this.processMustOccurConstraint(constraintValidationResult, constraint, attributeValueReader)) {
            if (attributeValueReader.getAttributeName() == null) {
                constraintValidationResult.setAttributeName(attributeValueReader.getEntryName());
            } else {
                constraintValidationResult.setAttributeName(attributeValueReader.getAttributeName());
                constraintValidationResult.setAttributePath(attributeValueReader.getPath());
            }
            constraintValidationResult.setError("error.occurs", new String[0]);
        }
        result.addConstraintValidationResult(attributeValueReader, constraintValidationResult);
        return new ProcessorResult(constraintValidationResult);
    }

    @Override
    public String getName() {
        return CONSTRAINT_NAME;
    }

    @Override
    public Class<? extends Constraint> getConstraintType() {
        return MustOccurConstraint.class;
    }

    protected boolean processMustOccurConstraint(ConstraintValidationResult topLevelResult, MustOccurConstraint constraint, AttributeValueReader attributeValueReader) throws AttributeValidationException {
        List<MustOccurConstraint> mustOccurConstraints;
        boolean isSuccessful = false;
        int trueCount = 0;
        List<PrerequisiteConstraint> prerequisiteConstraints = constraint.getPrerequisiteConstraints();
        if (prerequisiteConstraints != null) {
            for (PrerequisiteConstraint prerequisiteConstraint : prerequisiteConstraints) {
                ConstraintValidationResult constraintValidationResult = this.processPrerequisiteConstraint(prerequisiteConstraint, attributeValueReader);
                constraintValidationResult.setConstraintLabelKey(prerequisiteConstraint.getLabelKey());
                constraintValidationResult.setErrorParameters(prerequisiteConstraint.getValidationMessageParamsArray());
                topLevelResult.addChild(constraintValidationResult);
                trueCount += constraintValidationResult.getStatus().getLevel() <= ErrorLevel.WARN.getLevel() ? 1 : 0;
            }
        }
        if ((mustOccurConstraints = constraint.getMustOccurConstraints()) != null) {
            for (MustOccurConstraint mustOccurConstraint : mustOccurConstraints) {
                ConstraintValidationResult constraintValidationResult = new ConstraintValidationResult(CONSTRAINT_NAME);
                constraintValidationResult.setConstraintLabelKey(mustOccurConstraint.getLabelKey());
                constraintValidationResult.setErrorParameters(mustOccurConstraint.getValidationMessageParamsArray());
                topLevelResult.addChild(constraintValidationResult);
                trueCount += this.processMustOccurConstraint(constraintValidationResult, mustOccurConstraint, attributeValueReader) ? 1 : 0;
            }
        }
        int minimum = constraint.getMin() != null ? constraint.getMin() : 0;
        int maximum = constraint.getMax() != null ? constraint.getMax() : 0;
        isSuccessful = trueCount >= minimum && trueCount <= maximum;
        return isSuccessful;
    }
}

