/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.document;

import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentAuthorizer;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewAuthorizerBase;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.web.form.DocumentFormBase;

public class DocumentViewAuthorizerBase
extends ViewAuthorizerBase
implements DocumentAuthorizer {
    private static final long serialVersionUID = 3800780934223224565L;
    protected static Log LOG = LogFactory.getLog(DocumentViewAuthorizerBase.class);
    public static final String PRE_ROUTING_ROUTE_NAME = "PreRoute";
    private DocumentAuthorizer documentAuthorizer;

    @Override
    public Set<String> getActionFlags(View view, ViewModel model, Person user, Set<String> actions) {
        Document document = ((DocumentFormBase)model).getDocument();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("calling DocumentAuthorizerBase.getDocumentActionFlags for document '" + document.getDocumentNumber() + "'. user '" + user.getPrincipalName() + "'"));
        }
        if (actions.contains("canEdit") && !this.canEdit(document, user)) {
            actions.remove("canEdit");
        }
        if (actions.contains("canCopy") && !this.canCopy(document, user)) {
            actions.remove("canCopy");
        }
        if (actions.contains("canClose") && !this.canClose(document, user)) {
            actions.remove("canClose");
        }
        if (actions.contains("canReload") && !this.canReload(document, user)) {
            actions.remove("canReload");
        }
        if (actions.contains("canBlanketApprove") && !this.canBlanketApprove(document, user)) {
            actions.remove("canBlanketApprove");
        }
        if (actions.contains("canCancel") && !this.canCancel(document, user)) {
            actions.remove("canCancel");
        }
        if (actions.contains("canRecall") && !this.canRecall(document, user)) {
            actions.remove("canRecall");
        }
        if (actions.contains("canSave") && !this.canSave(document, user)) {
            actions.remove("canSave");
        }
        if (actions.contains("canRoute") && !this.canRoute(document, user)) {
            actions.remove("canRoute");
        }
        if (actions.contains("canAcknowledge") && !this.canAcknowledge(document, user)) {
            actions.remove("canAcknowledge");
        }
        if (actions.contains("canFYI") && !this.canFyi(document, user)) {
            actions.remove("canFYI");
        }
        if (actions.contains("canApprove") && !this.canApprove(document, user)) {
            actions.remove("canApprove");
        }
        if (actions.contains("canDisapprove") && !this.canDisapprove(document, user)) {
            actions.remove("canDisapprove");
        }
        if (!this.canSendAnyTypeAdHocRequests(document, user)) {
            actions.remove("canAddAdHocRequests");
            actions.remove("canSendAdHocRequests");
            actions.remove("canSendNoteFyi");
        }
        if (actions.contains("canSendNoteFyi") && !this.canSendNoteFyi(document, user)) {
            actions.remove("canSendNoteFyi");
        }
        if (actions.contains("canAnnotate") && !this.canAnnotate(document, user)) {
            actions.remove("canAnnotate");
        }
        if (actions.contains("canEditDocumentOverview") && !this.canEditDocumentOverview(document, user)) {
            actions.remove("canEditDocumentOverview");
        }
        if (actions.contains("canPerformRouteReport") && !this.canPerformRouteReport(document, user)) {
            actions.remove("canPerformRouteReport");
        }
        return actions;
    }

    @Override
    public final boolean canInitiate(String documentTypeName, Person user) {
        return this.getDocumentAuthorizer().canInitiate(documentTypeName, user);
    }

    @Override
    public final boolean canOpen(Document document, Person user) {
        return this.getDocumentAuthorizer().canOpen(document, user);
    }

    @Override
    public boolean canOpenView(View view, ViewModel model, Person user) {
        DocumentFormBase documentForm = (DocumentFormBase)model;
        return super.canOpenView(view, model, user) && this.canOpen(documentForm.getDocument(), user);
    }

    @Override
    public boolean canEdit(Document document, Person user) {
        return this.getDocumentAuthorizer().canEdit(document, user);
    }

    @Override
    public boolean canEditView(View view, ViewModel model, Person user) {
        DocumentFormBase documentForm = (DocumentFormBase)model;
        return super.canEditView(view, model, user) && this.canEdit(documentForm.getDocument(), user);
    }

    @Override
    public boolean canAnnotate(Document document, Person user) {
        return this.getDocumentAuthorizer().canAnnotate(document, user);
    }

    @Override
    public boolean canReload(Document document, Person user) {
        return this.getDocumentAuthorizer().canReload(document, user);
    }

    @Override
    public boolean canClose(Document document, Person user) {
        return this.getDocumentAuthorizer().canClose(document, user);
    }

    @Override
    public boolean canSave(Document document, Person user) {
        return this.getDocumentAuthorizer().canSave(document, user);
    }

    @Override
    public boolean canRoute(Document document, Person user) {
        return this.getDocumentAuthorizer().canRoute(document, user);
    }

    @Override
    public boolean canCancel(Document document, Person user) {
        return this.getDocumentAuthorizer().canCancel(document, user);
    }

    @Override
    public boolean canRecall(Document document, Person user) {
        return this.getDocumentAuthorizer().canRecall(document, user);
    }

    @Override
    public boolean canCopy(Document document, Person user) {
        return this.getDocumentAuthorizer().canCopy(document, user);
    }

    @Override
    public boolean canPerformRouteReport(Document document, Person user) {
        return this.getDocumentAuthorizer().canPerformRouteReport(document, user);
    }

    @Override
    public boolean canBlanketApprove(Document document, Person user) {
        return this.getDocumentAuthorizer().canBlanketApprove(document, user);
    }

    @Override
    public boolean canApprove(Document document, Person user) {
        return this.getDocumentAuthorizer().canApprove(document, user);
    }

    @Override
    public boolean canDisapprove(Document document, Person user) {
        return this.getDocumentAuthorizer().canDisapprove(document, user);
    }

    @Override
    public boolean canSendNoteFyi(Document document, Person user) {
        return this.getDocumentAuthorizer().canSendNoteFyi(document, user);
    }

    @Override
    public boolean canFyi(Document document, Person user) {
        return this.getDocumentAuthorizer().canFyi(document, user);
    }

    @Override
    public boolean canAcknowledge(Document document, Person user) {
        return this.getDocumentAuthorizer().canAcknowledge(document, user);
    }

    @Override
    public final boolean canReceiveAdHoc(Document document, Person user, String actionRequestCode) {
        return this.getDocumentAuthorizer().canReceiveAdHoc(document, user, actionRequestCode);
    }

    @Override
    public final boolean canAddNoteAttachment(Document document, String attachmentTypeCode, Person user) {
        return this.getDocumentAuthorizer().canAddNoteAttachment(document, attachmentTypeCode, user);
    }

    @Override
    public final boolean canDeleteNoteAttachment(Document document, String attachmentTypeCode, String authorUniversalIdentifier, Person user) {
        return this.getDocumentAuthorizer().canDeleteNoteAttachment(document, attachmentTypeCode, authorUniversalIdentifier, user);
    }

    @Override
    public final boolean canViewNoteAttachment(Document document, String attachmentTypeCode, String authorUniversalIdentifier, Person user) {
        return this.getDocumentAuthorizer().canViewNoteAttachment(document, attachmentTypeCode, authorUniversalIdentifier, user);
    }

    @Override
    public final boolean canSendAdHocRequests(Document document, String actionRequestCd, Person user) {
        return this.getDocumentAuthorizer().canSendAdHocRequests(document, actionRequestCd, user);
    }

    @Override
    public boolean canEditDocumentOverview(Document document, Person user) {
        return this.getDocumentAuthorizer().canEditDocumentOverview(document, user);
    }

    @Override
    public boolean canSendAnyTypeAdHocRequests(Document document, Person user) {
        return this.getDocumentAuthorizer().canSendAnyTypeAdHocRequests(document, user);
    }

    @Override
    public boolean canTakeRequestedAction(Document document, String actionRequestCode, Person user) {
        return this.getDocumentAuthorizer().canTakeRequestedAction(document, actionRequestCode, user);
    }

    @Override
    protected void addPermissionDetails(Object dataObject, Map<String, String> attributes) {
        super.addPermissionDetails(dataObject, attributes);
        if (dataObject instanceof Document) {
            this.addStandardAttributes((Document)dataObject, attributes);
        }
    }

    @Override
    protected void addRoleQualification(Object dataObject, Map<String, String> attributes) {
        super.addRoleQualification(dataObject, attributes);
        if (dataObject instanceof Document) {
            this.addStandardAttributes((Document)dataObject, attributes);
        }
    }

    protected void addStandardAttributes(Document document, Map<String, String> attributes) {
        WorkflowDocument wd = document.getDocumentHeader().getWorkflowDocument();
        attributes.put("documentNumber", document.getDocumentNumber());
        attributes.put("documentTypeName", wd.getDocumentTypeName());
        if (wd.isInitiated() || wd.isSaved()) {
            attributes.put("routeNodeName", PRE_ROUTING_ROUTE_NAME);
        } else {
            attributes.put("routeNodeName", KRADServiceLocatorWeb.getWorkflowDocumentService().getCurrentRouteNodeNames(wd));
        }
        attributes.put("routeStatusCode", wd.getStatus().getCode());
    }

    protected boolean isDocumentInitiator(Document document, Person user) {
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        return workflowDocument.getInitiatorPrincipalId().equalsIgnoreCase(user.getPrincipalId());
    }

    public DocumentAuthorizer getDocumentAuthorizer() {
        return this.documentAuthorizer;
    }

    public void setDocumentAuthorizer(DocumentAuthorizer documentAuthorizer) {
        this.documentAuthorizer = documentAuthorizer;
    }

    public void setDocumentAuthorizerClass(Class<? extends DocumentAuthorizer> documentAuthorizerClass) {
        this.documentAuthorizer = ObjectUtils.newInstance(documentAuthorizerClass);
    }
}

