/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.lookup;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.ojb.broker.query.Criteria;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.datadictionary.exception.UnknownBusinessClassAttributeException;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.util.ExternalizableBusinessObjectUtils;
import org.kuali.rice.krad.util.ObjectUtils;

public class LookupUtils {
    public static String forceUppercase(Class<?> dataObjectClass, String fieldName, String fieldValue) {
        if (StringUtils.isBlank((String)fieldValue)) {
            return fieldValue;
        }
        if (dataObjectClass == null) {
            throw new IllegalArgumentException("Parameter dataObjectClass passed in with null value.");
        }
        if (StringUtils.isBlank((String)fieldName)) {
            throw new IllegalArgumentException("Parameter fieldName passed in with empty value.");
        }
        if (!KRADServiceLocatorWeb.getDataDictionaryService().isAttributeDefined(dataObjectClass, fieldName).booleanValue()) {
            return fieldValue;
        }
        boolean forceUpperCase = false;
        try {
            forceUpperCase = KRADServiceLocatorWeb.getDataDictionaryService().getAttributeForceUppercase(dataObjectClass, fieldName);
        }
        catch (UnknownBusinessClassAttributeException ubae) {
            // empty catch block
        }
        if (forceUpperCase && !fieldValue.endsWith("(&^#&)")) {
            return fieldValue.toUpperCase();
        }
        return fieldValue;
    }

    public static Map<String, String> forceUppercase(Class<?> dataObjectClass, Map<String, String> fieldValues) {
        if (dataObjectClass == null) {
            throw new IllegalArgumentException("Parameter boClass passed in with null value.");
        }
        if (fieldValues == null) {
            throw new IllegalArgumentException("Parameter fieldValues passed in with null value.");
        }
        for (String fieldName : fieldValues.keySet()) {
            fieldValues.put(fieldName, LookupUtils.forceUppercase(dataObjectClass, fieldName, fieldValues.get(fieldName)));
        }
        return fieldValues;
    }

    public static Integer getSearchResultsLimit(Class dataObjectClass) {
        Integer limit = KRADServiceLocatorWeb.getViewDictionaryService().getResultSetLimitForLookup(dataObjectClass);
        if (limit == null) {
            limit = LookupUtils.getApplicationSearchResultsLimit();
        }
        return limit;
    }

    public static Integer getApplicationSearchResultsLimit() {
        String limitString = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-NS", "Lookup", "RESULTS_LIMIT");
        if (limitString != null) {
            return Integer.valueOf(limitString);
        }
        return null;
    }

    public static void applySearchResultsLimit(Class businessObjectClass, Criteria criteria, DatabasePlatform platform) {
        Integer limit = LookupUtils.getSearchResultsLimit(businessObjectClass);
        if (limit != null) {
            platform.applyLimit(limit, criteria);
        }
    }

    public static void applySearchResultsLimit(Class businessObjectClass, org.kuali.rice.core.framework.persistence.jpa.criteria.Criteria criteria) {
        Integer limit = LookupUtils.getSearchResultsLimit(businessObjectClass);
        if (limit != null) {
            criteria.setSearchLimit(limit);
        }
    }

    public static Timestamp getActiveDateTimestampForCriteria(Map searchValues) {
        String activeAsOfDate;
        Date activeDate = CoreApiServiceLocator.getDateTimeService().getCurrentSqlDate();
        Timestamp activeTimestamp = null;
        if (searchValues.containsKey("activeAsOfDate") && StringUtils.isNotBlank((String)(activeAsOfDate = (String)searchValues.get("activeAsOfDate")))) {
            try {
                activeDate = CoreApiServiceLocator.getDateTimeService().convertToSqlDate(ObjectUtils.clean(activeAsOfDate));
            }
            catch (ParseException e) {
                try {
                    activeTimestamp = CoreApiServiceLocator.getDateTimeService().convertToSqlTimestamp(ObjectUtils.clean(activeAsOfDate));
                }
                catch (ParseException e1) {
                    throw new RuntimeException("Unable to convert date: " + ObjectUtils.clean(activeAsOfDate));
                }
            }
        }
        if (activeTimestamp == null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(activeDate);
            cal.set(10, cal.getMaximum(10));
            cal.set(12, cal.getMaximum(12));
            cal.set(13, cal.getMaximum(13));
            activeTimestamp = new Timestamp(cal.getTime().getTime());
        }
        return activeTimestamp;
    }

    public static Map<String, String> preprocessDateFields(Map<String, String> searchCriteria) {
        HashMap<String, String> fieldsToUpdate = new HashMap<String, String>();
        Set<String> fieldsForLookup = searchCriteria.keySet();
        for (String propName : fieldsForLookup) {
            String to_DateValue;
            if (!propName.startsWith("rangeLowerBoundKeyPrefix_")) continue;
            String from_DateValue = searchCriteria.get(propName);
            String dateFieldName = StringUtils.remove((String)propName, (String)"rangeLowerBoundKeyPrefix_");
            String newPropValue = to_DateValue = searchCriteria.get(dateFieldName);
            if (StringUtils.isNotEmpty((String)from_DateValue) && StringUtils.isNotEmpty((String)to_DateValue)) {
                newPropValue = from_DateValue + SearchOperator.BETWEEN + to_DateValue;
            } else if (StringUtils.isNotEmpty((String)from_DateValue) && StringUtils.isEmpty((String)to_DateValue)) {
                newPropValue = SearchOperator.GREATER_THAN_EQUAL.op() + from_DateValue;
            } else if (StringUtils.isNotEmpty((String)to_DateValue) && StringUtils.isEmpty((String)from_DateValue)) {
                newPropValue = SearchOperator.LESS_THAN_EQUAL.op() + to_DateValue;
            }
            fieldsToUpdate.put(dateFieldName, newPropValue);
        }
        Set keysToUpdate = fieldsToUpdate.keySet();
        for (String updateKey : keysToUpdate) {
            searchCriteria.put(updateKey, (String)fieldsToUpdate.get(updateKey));
        }
        return fieldsToUpdate;
    }

    public static boolean hasExternalBusinessObjectProperty(Class<?> boClass, Map<String, String> fieldValues) throws IllegalAccessException, InstantiationException {
        Object sampleBo = boClass.newInstance();
        for (String key : fieldValues.keySet()) {
            if (!LookupUtils.isExternalBusinessObjectProperty(sampleBo, key)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExternalBusinessObjectProperty(Object sampleBo, String propertyName) {
        Class<?> propertyClass;
        if (propertyName.indexOf(".") > 0 && !StringUtils.contains((String)propertyName, (String)"add.") && (propertyClass = ObjectPropertyUtils.getPropertyType(sampleBo, StringUtils.substringBeforeLast((String)propertyName, (String)"."))) != null) {
            return ExternalizableBusinessObjectUtils.isExternalizableBusinessObjectInterface(propertyClass);
        }
        return false;
    }

    public static Map<String, String> removeExternalizableBusinessObjectFieldValues(Class<?> boClass, Map<String, String> fieldValues) throws IllegalAccessException, InstantiationException {
        HashMap<String, String> eboFieldValues = new HashMap<String, String>();
        Object sampleBo = boClass.newInstance();
        for (String key : fieldValues.keySet()) {
            if (LookupUtils.isExternalBusinessObjectProperty(sampleBo, key)) continue;
            eboFieldValues.put(key, fieldValues.get(key));
        }
        return eboFieldValues;
    }

    public static Map<String, String> getExternalizableBusinessObjectFieldValues(String eboPropertyName, Map<String, String> fieldValues) {
        HashMap<String, String> eboFieldValues = new HashMap<String, String>();
        for (String key : fieldValues.keySet()) {
            if (!key.startsWith(eboPropertyName + ".")) continue;
            eboFieldValues.put(StringUtils.substringAfterLast((String)key, (String)"."), fieldValues.get(key));
        }
        return eboFieldValues;
    }

    public static List<String> getExternalizableBusinessObjectProperties(Class<?> boClass, Map<String, String> fieldValues) throws IllegalAccessException, InstantiationException {
        HashSet<String> eboPropertyNames = new HashSet<String>();
        Object sampleBo = boClass.newInstance();
        for (String key : fieldValues.keySet()) {
            if (!LookupUtils.isExternalBusinessObjectProperty(sampleBo, key)) continue;
            eboPropertyNames.add(StringUtils.substringBeforeLast((String)key, (String)"."));
        }
        return new ArrayList<String>(eboPropertyNames);
    }

    public static Class<? extends ExternalizableBusinessObject> getExternalizableBusinessObjectClass(Class<?> boClass, String propertyName) throws IllegalAccessException, InstantiationException {
        return ObjectPropertyUtils.getPropertyType(boClass.newInstance(), StringUtils.substringBeforeLast((String)propertyName, (String)"."));
    }
}

