/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.component;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.uif.component.ConfigurableBase;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.ObjectUtils;

public class BindingInfo
extends ConfigurableBase
implements Serializable {
    private static final long serialVersionUID = -7389398061672136091L;
    private boolean bindToForm = false;
    private boolean bindToMap = false;
    private String bindingName;
    private String bindByNamePrefix;
    private String bindingObjectPath;
    private String collectionPath;
    private String bindingPath;

    public void setDefaults(View view, String propertyName) {
        if (StringUtils.isBlank((String)this.bindingName)) {
            this.bindingName = propertyName;
        }
        if (StringUtils.isBlank((String)this.bindingObjectPath)) {
            this.bindingObjectPath = view.getDefaultBindingObjectPath();
        }
    }

    public String getBindingPath() {
        if (StringUtils.isNotBlank((String)this.bindingPath)) {
            return this.bindingPath;
        }
        String formedBindingPath = "";
        if (!this.bindToForm && StringUtils.isNotBlank((String)this.bindingObjectPath)) {
            formedBindingPath = this.bindingObjectPath;
        }
        if (StringUtils.isNotBlank((String)this.bindByNamePrefix)) {
            if (!this.bindByNamePrefix.startsWith("[") && StringUtils.isNotBlank((String)formedBindingPath)) {
                formedBindingPath = formedBindingPath + ".";
            }
            formedBindingPath = formedBindingPath + this.bindByNamePrefix;
        }
        if (this.bindToMap) {
            formedBindingPath = formedBindingPath + "[" + this.bindingName + "]";
        } else {
            if (StringUtils.isNotBlank((String)formedBindingPath)) {
                formedBindingPath = formedBindingPath + ".";
            }
            formedBindingPath = formedBindingPath + this.bindingName;
        }
        return formedBindingPath;
    }

    public String getBindingPrefixForNested() {
        String bindingPrefix = "";
        if (StringUtils.isNotBlank((String)this.bindByNamePrefix)) {
            bindingPrefix = this.bindByNamePrefix;
        }
        if (this.bindToMap) {
            bindingPrefix = bindingPrefix + "['" + this.bindingName + "']";
        } else {
            if (StringUtils.isNotBlank((String)bindingPrefix)) {
                bindingPrefix = bindingPrefix + ".";
            }
            bindingPrefix = bindingPrefix + this.bindingName;
        }
        return bindingPrefix;
    }

    public String getPropertyAdjustedBindingPath(String propertyPath) {
        if (propertyPath.startsWith("#form.")) {
            propertyPath = StringUtils.removeStart((String)propertyPath, (String)"#form.");
            return propertyPath;
        }
        BindingInfo bindingInfoCopy = (BindingInfo)ObjectUtils.deepCopy(this);
        bindingInfoCopy.setBindingPath("");
        if (propertyPath.startsWith("#fp.")) {
            bindingInfoCopy.setBindByNamePrefix("");
            propertyPath = StringUtils.removeStart((String)propertyPath, (String)"#fp.");
        }
        bindingInfoCopy.setBindingName(propertyPath);
        return bindingInfoCopy.getBindingPath();
    }

    public void addToBindByNamePrefix(String bindPrefix) {
        this.bindByNamePrefix = StringUtils.isNotBlank((String)this.bindByNamePrefix) && StringUtils.isNotBlank((String)bindPrefix) ? this.bindByNamePrefix + "." + bindPrefix : bindPrefix;
    }

    public void setBindingPath(String bindingPath) {
        this.bindingPath = bindingPath;
    }

    public boolean isBindToForm() {
        return this.bindToForm;
    }

    public void setBindToForm(boolean bindToForm) {
        this.bindToForm = bindToForm;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public String getBindByNamePrefix() {
        return this.bindByNamePrefix;
    }

    public void setBindByNamePrefix(String bindByNamePrefix) {
        this.bindByNamePrefix = bindByNamePrefix;
    }

    public String getCollectionPath() {
        return this.collectionPath;
    }

    public void setCollectionPath(String collectionPath) {
        this.collectionPath = collectionPath;
    }

    public String getBindingObjectPath() {
        return this.bindingObjectPath;
    }

    public void setBindingObjectPath(String bindingObjectPath) {
        this.bindingObjectPath = bindingObjectPath;
    }

    public boolean isBindToMap() {
        return this.bindToMap;
    }

    public void setBindToMap(boolean bindToMap) {
        this.bindToMap = bindToMap;
    }
}

