/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.component;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.MethodInvoker;
import org.springframework.util.ReflectionUtils;

public class MethodInvokerConfig
extends MethodInvoker
implements Serializable {
    private String staticMethod;
    private Class[] argumentTypes;

    public void setStaticMethod(String staticMethod) {
        super.setStaticMethod(staticMethod);
    }

    public Class[] getArgumentTypes() {
        if (this.argumentTypes == null) {
            return this.getMethodArgumentTypes();
        }
        return this.argumentTypes;
    }

    public void setArgumentTypes(Class[] argumentTypes) {
        this.argumentTypes = argumentTypes;
    }

    protected Class[] getMethodArgumentTypes() {
        Method[] candidates;
        if (StringUtils.isNotBlank((String)this.staticMethod)) {
            int lastDotIndex = this.staticMethod.lastIndexOf(46);
            if (lastDotIndex == -1 || lastDotIndex == this.staticMethod.length()) {
                throw new IllegalArgumentException("staticMethod must be a fully qualified class plus method name: e.g. 'example.MyExampleClass.myExampleMethod'");
            }
            String className = this.staticMethod.substring(0, lastDotIndex);
            String methodName = this.staticMethod.substring(lastDotIndex + 1);
            try {
                this.setTargetClass(this.resolveClassName(className));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to get class for name: " + className);
            }
            this.setTargetMethod(methodName);
        }
        for (Method candidate : candidates = ReflectionUtils.getAllDeclaredMethods((Class)this.getTargetClass())) {
            if (!candidate.getName().equals(this.getTargetMethod())) continue;
            return candidate.getParameterTypes();
        }
        return null;
    }
}

