/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentSecurity;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.container.ActiveCollectionFilter;
import org.kuali.rice.krad.uif.container.CollectionFilter;
import org.kuali.rice.krad.uif.container.CollectionGroupBuilder;
import org.kuali.rice.krad.uif.container.CollectionGroupSecurity;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.field.ActionField;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.LabelField;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.QuickFinder;

public class CollectionGroup
extends Group
implements DataBinding {
    private static final long serialVersionUID = -6496712566071542452L;
    private Class<?> collectionObjectClass;
    private String propertyName;
    private BindingInfo bindingInfo;
    private boolean renderAddLine = true;
    private String addLinePropertyName;
    private BindingInfo addLineBindingInfo;
    private LabelField addLineLabelField;
    private List<? extends Component> addLineFields;
    private List<ActionField> addLineActionFields;
    private boolean renderLineActions = true;
    private List<ActionField> actionFields;
    private boolean renderSelectField = false;
    private String selectPropertyName;
    private QuickFinder collectionLookup;
    private boolean showHideInactiveButton = true;
    private boolean showInactive = false;
    private CollectionFilter activeCollectionFilter;
    private List<CollectionFilter> filters = new ArrayList<CollectionFilter>();
    private List<CollectionGroup> subCollections;
    private String subCollectionSuffix;
    private CollectionGroupBuilder collectionGroupBuilder;

    public CollectionGroup() {
        this.actionFields = new ArrayList<ActionField>();
        this.addLineFields = new ArrayList<Component>();
        this.addLineActionFields = new ArrayList<ActionField>();
        this.subCollections = new ArrayList<CollectionGroup>();
    }

    @Override
    public void performInitialization(View view, Object model) {
        DataField field;
        this.setFieldBindingObjectPath(this.getBindingInfo().getBindingObjectPath());
        super.performInitialization(view, model);
        if (this.bindingInfo != null) {
            this.bindingInfo.setDefaults(view, this.getPropertyName());
        }
        if (this.addLineBindingInfo != null && StringUtils.isNotBlank((String)this.addLinePropertyName)) {
            this.addLineBindingInfo.setDefaults(view, this.getPropertyName());
            this.addLineBindingInfo.setBindingName(this.addLinePropertyName);
            if (StringUtils.isNotBlank((String)this.getFieldBindByNamePrefix())) {
                this.addLineBindingInfo.setBindByNamePrefix(this.getFieldBindByNamePrefix());
            }
        }
        for (Component component : this.getItems()) {
            if (!(component instanceof DataField) || !StringUtils.isBlank((String)(field = (DataField)component).getDictionaryObjectEntry())) continue;
            field.setDictionaryObjectEntry(this.collectionObjectClass.getName());
        }
        for (Component component : this.addLineFields) {
            if (!(component instanceof DataField) || !StringUtils.isBlank((String)(field = (DataField)component).getDictionaryObjectEntry())) continue;
            field.setDictionaryObjectEntry(this.collectionObjectClass.getName());
        }
        if (this.addLineFields == null || this.addLineFields.isEmpty()) {
            this.addLineFields = this.getItems();
        }
        if (this.activeCollectionFilter == null) {
            this.activeCollectionFilter = new ActiveCollectionFilter();
        }
        String collectionPath = "";
        if (StringUtils.isNotBlank((String)this.getBindingInfo().getCollectionPath())) {
            collectionPath = collectionPath + this.getBindingInfo().getCollectionPath() + ".";
        }
        if (StringUtils.isNotBlank((String)this.getBindingInfo().getBindByNamePrefix())) {
            collectionPath = collectionPath + this.getBindingInfo().getBindByNamePrefix() + ".";
        }
        collectionPath = collectionPath + this.getBindingInfo().getBindingName();
        List<DataField> list = ComponentUtils.getComponentsOfTypeDeep(this.getItems(), DataField.class);
        for (DataField collectionField : list) {
            collectionField.getBindingInfo().setCollectionPath(collectionPath);
        }
        List<DataField> addLineCollectionFields = ComponentUtils.getComponentsOfTypeDeep(this.addLineFields, DataField.class);
        for (DataField dataField : addLineCollectionFields) {
            dataField.getBindingInfo().setCollectionPath(collectionPath);
        }
        if (!view.getAbstractTypeClasses().containsKey(collectionPath)) {
            view.getAbstractTypeClasses().put(collectionPath, this.getCollectionObjectClass());
        }
        for (Component component : this.getItems()) {
            view.getViewHelperService().performComponentInitialization(view, model, component);
        }
        for (Component component : this.addLineFields) {
            view.getViewHelperService().performComponentInitialization(view, model, component);
        }
        for (CollectionGroup collectionGroup : this.getSubCollections()) {
            collectionGroup.getBindingInfo().setCollectionPath(collectionPath);
            view.getViewHelperService().performComponentInitialization(view, model, collectionGroup);
        }
    }

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        this.pushCollectionGroupToReference();
        if (this.isRender()) {
            this.getCollectionGroupBuilder().build(view, model, this);
        }
        this.pushCollectionGroupToReference();
    }

    protected void pushCollectionGroupToReference() {
        List<Component> components = this.getComponentsForLifecycle();
        ComponentUtils.pushObjectToContext(components, "collectionGroup", (Object)this);
        List<ActionField> actionFields = ComponentUtils.getComponentsOfTypeDeep(components, ActionField.class);
        for (ActionField actionField : actionFields) {
            actionField.addActionParameter("selectedCollectionPath", this.getBindingInfo().getBindingPath());
        }
    }

    public void initializeNewCollectionLine(View view, Object model, CollectionGroup collectionGroup, boolean clearExistingLine) {
        this.getCollectionGroupBuilder().initializeNewCollectionLine(view, model, collectionGroup, clearExistingLine);
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.addLineLabelField);
        components.add(this.collectionLookup);
        for (Component component : this.getItems()) {
            if (!components.contains(component)) continue;
            components.remove(component);
        }
        return components;
    }

    @Override
    public List<Component> getComponentPrototypes() {
        List<Component> components = super.getComponentPrototypes();
        components.addAll(this.actionFields);
        components.addAll(this.addLineActionFields);
        components.addAll(this.getItems());
        components.addAll(this.getSubCollections());
        components.addAll(this.addLineFields);
        return components;
    }

    public Class<?> getCollectionObjectClass() {
        return this.collectionObjectClass;
    }

    public void setCollectionObjectClass(Class<?> collectionObjectClass) {
        this.collectionObjectClass = collectionObjectClass;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public BindingInfo getBindingInfo() {
        return this.bindingInfo;
    }

    @Override
    public void setBindingInfo(BindingInfo bindingInfo) {
        this.bindingInfo = bindingInfo;
    }

    public List<ActionField> getActionFields() {
        return this.actionFields;
    }

    public void setActionFields(List<ActionField> actionFields) {
        this.actionFields = actionFields;
    }

    public boolean isRenderLineActions() {
        return this.renderLineActions;
    }

    public void setRenderLineActions(boolean renderLineActions) {
        this.renderLineActions = renderLineActions;
    }

    public boolean isRenderAddLine() {
        return this.renderAddLine;
    }

    public void setRenderAddLine(boolean renderAddLine) {
        this.renderAddLine = renderAddLine;
    }

    public String getAddLineLabel() {
        if (this.getAddLineLabelField() != null) {
            return this.getAddLineLabelField().getLabelText();
        }
        return null;
    }

    public void setAddLineLabel(String addLineLabel) {
        if (this.getAddLineLabelField() != null) {
            this.getAddLineLabelField().setLabelText(addLineLabel);
        }
    }

    public LabelField getAddLineLabelField() {
        return this.addLineLabelField;
    }

    public void setAddLineLabelField(LabelField addLineLabelField) {
        this.addLineLabelField = addLineLabelField;
    }

    public String getAddLinePropertyName() {
        return this.addLinePropertyName;
    }

    public void setAddLinePropertyName(String addLinePropertyName) {
        this.addLinePropertyName = addLinePropertyName;
    }

    public BindingInfo getAddLineBindingInfo() {
        return this.addLineBindingInfo;
    }

    public void setAddLineBindingInfo(BindingInfo addLineBindingInfo) {
        this.addLineBindingInfo = addLineBindingInfo;
    }

    public List<? extends Component> getAddLineFields() {
        return this.addLineFields;
    }

    public void setAddLineFields(List<? extends Component> addLineFields) {
        this.addLineFields = addLineFields;
    }

    public List<ActionField> getAddLineActionFields() {
        return this.addLineActionFields;
    }

    public void setAddLineActionFields(List<ActionField> addLineActionFields) {
        this.addLineActionFields = addLineActionFields;
    }

    public boolean isRenderSelectField() {
        return this.renderSelectField;
    }

    public void setRenderSelectField(boolean renderSelectField) {
        this.renderSelectField = renderSelectField;
    }

    public String getSelectPropertyName() {
        return this.selectPropertyName;
    }

    public void setSelectPropertyName(String selectPropertyName) {
        this.selectPropertyName = selectPropertyName;
    }

    public QuickFinder getCollectionLookup() {
        return this.collectionLookup;
    }

    public void setCollectionLookup(QuickFinder collectionLookup) {
        this.collectionLookup = collectionLookup;
    }

    public boolean isShowInactive() {
        return this.showInactive;
    }

    public void setShowInactive(boolean showInactive) {
        this.showInactive = showInactive;
    }

    public CollectionFilter getActiveCollectionFilter() {
        return this.activeCollectionFilter;
    }

    public void setActiveCollectionFilter(CollectionFilter activeCollectionFilter) {
        this.activeCollectionFilter = activeCollectionFilter;
    }

    public List<CollectionFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<CollectionFilter> filters) {
        this.filters = filters;
    }

    public List<CollectionGroup> getSubCollections() {
        return this.subCollections;
    }

    public void setSubCollections(List<CollectionGroup> subCollections) {
        this.subCollections = subCollections;
    }

    public String getSubCollectionSuffix() {
        return this.subCollectionSuffix;
    }

    public void setSubCollectionSuffix(String subCollectionSuffix) {
        this.subCollectionSuffix = subCollectionSuffix;
    }

    public CollectionGroupSecurity getCollectionGroupSecurity() {
        return (CollectionGroupSecurity)super.getComponentSecurity();
    }

    @Override
    public void setComponentSecurity(ComponentSecurity componentSecurity) {
        if (!(componentSecurity instanceof CollectionGroupSecurity)) {
            throw new RiceRuntimeException("Component security for CollectionGroup should be instance of CollectionGroupSecurity");
        }
        super.setComponentSecurity(componentSecurity);
    }

    @Override
    protected Class<? extends ComponentSecurity> getComponentSecurityClass() {
        return CollectionGroupSecurity.class;
    }

    public CollectionGroupBuilder getCollectionGroupBuilder() {
        if (this.collectionGroupBuilder == null) {
            this.collectionGroupBuilder = new CollectionGroupBuilder();
        }
        return this.collectionGroupBuilder;
    }

    public void setCollectionGroupBuilder(CollectionGroupBuilder collectionGroupBuilder) {
        this.collectionGroupBuilder = collectionGroupBuilder;
    }

    public void setShowHideInactiveButton(boolean showHideInactiveButton) {
        this.showHideInactiveButton = showHideInactiveButton;
    }

    public boolean isShowHideInactiveButton() {
        return this.showHideInactiveButton;
    }
}

