/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentBase;
import org.kuali.rice.krad.uif.component.Ordered;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.field.ErrorsField;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.HeaderField;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.field.MessageField;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.Help;

public abstract class ContainerBase
extends ComponentBase
implements Container {
    private static final long serialVersionUID = -4182226230601746657L;
    private int itemOrderingSequence = 1;
    private String additionalMessageKeys;
    private ErrorsField errorsField;
    private Help help;
    private LayoutManager layoutManager;
    private HeaderField header;
    private Group footer;
    private String instructionalText;
    private MessageField instructionalMessageField;
    private boolean fieldContainer;

    @Override
    public void performInitialization(View view, Object model) {
        super.performInitialization(view, model);
        List<? extends Ordered> sortedItems = ComponentUtils.sort(this.getItems(), this.itemOrderingSequence);
        this.setItems(sortedItems);
        if (this.layoutManager != null) {
            this.layoutManager.performInitialization(view, model, this);
        }
    }

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        if (this.layoutManager != null) {
            this.layoutManager.performApplyModel(view, model, this);
        }
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (this.header != null && StringUtils.isBlank((String)this.header.getHeaderText())) {
            this.header.setHeaderText(this.getTitle());
        }
        if (this.instructionalMessageField != null && StringUtils.isBlank((String)this.instructionalMessageField.getMessageText())) {
            this.instructionalMessageField.setMessageText(this.instructionalText);
        }
        if (this.layoutManager != null) {
            this.layoutManager.performFinalize(view, model, this);
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.header);
        components.add(this.footer);
        components.add(this.errorsField);
        components.add(this.help);
        components.add(this.instructionalMessageField);
        for (Component component : this.getItems()) {
            components.add(component);
        }
        if (this.layoutManager != null) {
            components.addAll(this.layoutManager.getComponentsForLifecycle());
        }
        return components;
    }

    @Override
    public List<Component> getComponentPrototypes() {
        List<Component> components = super.getComponentPrototypes();
        if (this.layoutManager != null) {
            components.addAll(this.layoutManager.getComponentPrototypes());
        }
        return components;
    }

    public String getAdditionalMessageKeys() {
        return this.additionalMessageKeys;
    }

    public void setAdditionalMessageKeys(String additionalMessageKeys) {
        this.additionalMessageKeys = additionalMessageKeys;
    }

    @Override
    public ErrorsField getErrorsField() {
        return this.errorsField;
    }

    @Override
    public void setErrorsField(ErrorsField errorsField) {
        this.errorsField = errorsField;
    }

    @Override
    public Help getHelp() {
        return this.help;
    }

    @Override
    public void setHelp(Help help) {
        this.help = help;
    }

    @Override
    public abstract List<? extends Component> getItems();

    @Override
    public abstract void setItems(List<? extends Component> var1);

    public int getItemOrderingSequence() {
        return this.itemOrderingSequence;
    }

    public void setItemOrderingSequence(int itemOrderingSequence) {
        this.itemOrderingSequence = itemOrderingSequence;
    }

    @Override
    public LayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    @Override
    public void setLayoutManager(LayoutManager layoutManager) {
        this.layoutManager = layoutManager;
    }

    @Override
    public HeaderField getHeader() {
        return this.header;
    }

    @Override
    public void setHeader(HeaderField header) {
        this.header = header;
    }

    @Override
    public Group getFooter() {
        return this.footer;
    }

    @Override
    public void setFooter(Group footer) {
        this.footer = footer;
    }

    public void setRenderHeader(boolean renderHeader) {
        if (this.header != null) {
            this.header.setRender(renderHeader);
        }
    }

    public void setRenderFooter(boolean renderFooter) {
        if (this.footer != null) {
            this.footer.setRender(renderFooter);
        }
    }

    public String getInstructionalText() {
        return this.instructionalText;
    }

    public void setInstructionalText(String instructionalText) {
        this.instructionalText = instructionalText;
    }

    @Override
    public MessageField getInstructionalMessageField() {
        return this.instructionalMessageField;
    }

    @Override
    public void setInstructionalMessageField(MessageField instructionalMessageField) {
        this.instructionalMessageField = instructionalMessageField;
    }

    public List<InputField> getInputFields() {
        ArrayList<InputField> inputFields = new ArrayList<InputField>();
        for (Component c : this.getComponentsForLifecycle()) {
            if (!(c instanceof InputField)) continue;
            inputFields.add((InputField)c);
        }
        return inputFields;
    }

    public List<InputField> getAllInputFields() {
        ArrayList<InputField> inputFields = new ArrayList<InputField>();
        for (Component c : this.getComponentsForLifecycle()) {
            if (c instanceof InputField) {
                inputFields.add((InputField)c);
                continue;
            }
            if (c instanceof ContainerBase) {
                inputFields.addAll(((ContainerBase)c).getAllInputFields());
                continue;
            }
            if (!(c instanceof FieldGroup)) continue;
            Group cb = ((FieldGroup)c).getGroup();
            inputFields.addAll(cb.getAllInputFields());
        }
        return inputFields;
    }

    @Override
    public boolean isFieldContainer() {
        return this.fieldContainer;
    }

    @Override
    public void setFieldContainer(boolean fieldContainer) {
        this.fieldContainer = fieldContainer;
    }
}

