/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.tree.Node;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.NodePrototype;
import org.kuali.rice.krad.uif.field.MessageField;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.Tree;

public class TreeGroup
extends Group
implements DataBinding {
    private static final long serialVersionUID = 5841343037089286740L;
    private String propertyName;
    private BindingInfo bindingInfo;
    private Map<Class<?>, NodePrototype> nodePrototypeMap;
    private NodePrototype defaultNodePrototype;
    private org.kuali.rice.core.api.util.tree.Tree<Group, MessageField> treeGroups = new org.kuali.rice.core.api.util.tree.Tree();
    private Tree tree;

    @Override
    public void performInitialization(View view, Object model) {
        this.setFieldBindingObjectPath(this.getBindingInfo().getBindingObjectPath());
        super.performInitialization(view, model);
        if (this.bindingInfo != null) {
            this.bindingInfo.setDefaults(view, this.getPropertyName());
        }
        this.initializeNodePrototypeComponents(view, model);
    }

    protected void initializeNodePrototypeComponents(View view, Object model) {
        view.getViewHelperService().performComponentInitialization(view, model, this.defaultNodePrototype.getLabelPrototype());
        view.getViewHelperService().performComponentInitialization(view, model, this.defaultNodePrototype.getDataGroupPrototype());
        if (this.nodePrototypeMap != null) {
            for (Map.Entry<Class<?>, NodePrototype> prototypeEntry : this.nodePrototypeMap.entrySet()) {
                NodePrototype prototype = prototypeEntry.getValue();
                if (prototype != null) {
                    if (prototype.getLabelPrototype() == null) {
                        throw new IllegalStateException("encountered null NodePrototype.labelPrototype");
                    }
                    view.getViewHelperService().performComponentInitialization(view, model, prototype.getLabelPrototype());
                    if (prototype.getDataGroupPrototype() != null) {
                        view.getViewHelperService().performComponentInitialization(view, model, prototype.getDataGroupPrototype());
                        continue;
                    }
                    throw new IllegalStateException("encountered null NodePrototype.dataGroupPrototype");
                }
                throw new IllegalStateException("encountered null NodePrototype");
            }
        }
    }

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        this.buildTreeGroups(view, model);
    }

    protected void buildTreeGroups(View view, Object model) {
        org.kuali.rice.core.api.util.tree.Tree treeData = (org.kuali.rice.core.api.util.tree.Tree)ObjectPropertyUtils.getPropertyValue(model, this.getBindingInfo().getBindingPath());
        org.kuali.rice.core.api.util.tree.Tree treeGroups = new org.kuali.rice.core.api.util.tree.Tree();
        String bindingPrefix = this.getBindingInfo().getBindingPrefixForNested();
        Node<Group, MessageField> rootNode = this.buildTreeNode((Node<Object, String>)treeData.getRootElement(), bindingPrefix + ".rootElement", "root");
        treeGroups.setRootElement(rootNode);
        this.setTreeGroups((org.kuali.rice.core.api.util.tree.Tree<Group, MessageField>)treeGroups);
    }

    protected Node<Group, MessageField> buildTreeNode(Node<Object, String> nodeData, String bindingPrefix, String parentNode) {
        if (nodeData == null) {
            return null;
        }
        Node node = new Node();
        node.setNodeType(nodeData.getNodeType());
        NodePrototype prototype = this.getNodePrototype(nodeData);
        MessageField messageField = ComponentUtils.copy(prototype.getLabelPrototype(), parentNode);
        ComponentUtils.pushObjectToContext(messageField, "node", nodeData);
        messageField.setMessageText((String)nodeData.getNodeLabel());
        node.setNodeLabel((Object)messageField);
        Group nodeGroup = ComponentUtils.copyComponent(prototype.getDataGroupPrototype(), bindingPrefix + ".data", parentNode);
        ComponentUtils.pushObjectToContext(nodeGroup, "node", nodeData);
        String nodePath = bindingPrefix + ".data";
        if (StringUtils.isNotBlank((String)this.getBindingInfo().getBindingObjectPath())) {
            nodePath = this.getBindingInfo().getBindingObjectPath() + "." + nodePath;
        }
        ComponentUtils.pushObjectToContext(nodeGroup, "nodePath", (Object)nodePath);
        node.setData((Object)nodeGroup);
        ArrayList<Node<Group, MessageField>> nodeChildren = new ArrayList<Node<Group, MessageField>>();
        int childIndex = 0;
        for (Node childDataNode : nodeData.getChildren()) {
            String nextBindingPrefix = bindingPrefix + ".children[" + childIndex + "]";
            Node<Group, MessageField> childNode = this.buildTreeNode((Node<Object, String>)childDataNode, nextBindingPrefix, "_node_" + childIndex + ("root".equals(parentNode) ? "_parent_" : "_parent") + parentNode);
            nodeChildren.add(childNode);
            ++childIndex;
        }
        node.setChildren(nodeChildren);
        return node;
    }

    private NodePrototype getNodePrototype(Node<Object, String> nodeData) {
        Class<?> dataClass;
        NodePrototype result = null;
        if (nodeData != null && nodeData.getData() != null && (result = this.nodePrototypeMap.get(dataClass = nodeData.getData().getClass())) == null) {
            for (Map.Entry<Class<?>, NodePrototype> prototypeEntry : this.nodePrototypeMap.entrySet()) {
                if (!prototypeEntry.getKey().isAssignableFrom(dataClass)) continue;
                result = prototypeEntry.getValue();
                break;
            }
        }
        if (result == null) {
            result = this.defaultNodePrototype;
        }
        return result;
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.tree);
        this.addNodeComponents((Node<Group, MessageField>)this.treeGroups.getRootElement(), components);
        return components;
    }

    @Override
    public List<Component> getComponentPrototypes() {
        List<Component> components = super.getComponentPrototypes();
        if (this.defaultNodePrototype != null) {
            components.add(this.defaultNodePrototype.getLabelPrototype());
            components.add(this.defaultNodePrototype.getDataGroupPrototype());
        }
        if (this.nodePrototypeMap != null) {
            for (Map.Entry<Class<?>, NodePrototype> prototypeEntry : this.nodePrototypeMap.entrySet()) {
                NodePrototype prototype = prototypeEntry.getValue();
                if (prototype == null) continue;
                components.add(prototype.getLabelPrototype());
                components.add(prototype.getDataGroupPrototype());
            }
        }
        return components;
    }

    protected void addNodeComponents(Node<Group, MessageField> node, List<Component> components) {
        if (node != null) {
            components.add((Component)node.getNodeLabel());
            components.add((Component)node.getData());
            for (Node nodeChild : node.getChildren()) {
                this.addNodeComponents((Node<Group, MessageField>)nodeChild, components);
            }
        }
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public BindingInfo getBindingInfo() {
        return this.bindingInfo;
    }

    @Override
    public void setBindingInfo(BindingInfo bindingInfo) {
        this.bindingInfo = bindingInfo;
    }

    public NodePrototype getDefaultNodePrototype() {
        return this.defaultNodePrototype;
    }

    public void setDefaultNodePrototype(NodePrototype defaultNodePrototype) {
        this.defaultNodePrototype = defaultNodePrototype;
    }

    public Map<Class<?>, NodePrototype> getNodePrototypeMap() {
        return this.nodePrototypeMap;
    }

    public void setNodePrototypeMap(Map<Class<?>, NodePrototype> nodePrototypeMap) {
        this.nodePrototypeMap = nodePrototypeMap;
    }

    public org.kuali.rice.core.api.util.tree.Tree<Group, MessageField> getTreeGroups() {
        return this.treeGroups;
    }

    public void setTreeGroups(org.kuali.rice.core.api.util.tree.Tree<Group, MessageField> treeGroups) {
        this.treeGroups = treeGroups;
    }

    public Tree getTree() {
        return this.tree;
    }

    public void setTree(Tree tree) {
        this.tree = tree;
    }
}

