/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.field;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.field.ActionField;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.view.View;

public class AjaxActionField
extends ActionField {
    private static final long serialVersionUID = -2831173647391138870L;
    private String refreshId;
    private String refreshPropertyName;

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        Component component;
        Component refreshComponent = null;
        if (StringUtils.isNotBlank((String)this.refreshPropertyName)) {
            if (this.refreshPropertyName.startsWith("#form.")) {
                this.refreshPropertyName = StringUtils.removeStart((String)this.refreshPropertyName, (String)"#form.");
            } else if (StringUtils.isNotBlank((String)view.getDefaultBindingObjectPath())) {
                this.refreshPropertyName = view.getDefaultBindingObjectPath() + "." + this.refreshPropertyName;
            }
            DataField dataField = view.getViewIndex().getDataFieldByPath(this.refreshPropertyName);
            if (dataField != null) {
                refreshComponent = dataField;
            }
        } else if (StringUtils.isNotBlank((String)this.refreshId) && (component = view.getViewIndex().getComponentById(this.refreshId)) != null) {
            refreshComponent = component;
        }
        String actionScript = "";
        if (refreshComponent != null) {
            refreshComponent.setRefreshedByAction(true);
            Component initialComponent = view.getViewIndex().getInitialComponentStates().get(refreshComponent.getFactoryId());
            if (initialComponent != null) {
                initialComponent.setRefreshedByAction(true);
                view.getViewIndex().getInitialComponentStates().put(refreshComponent.getFactoryId(), initialComponent);
            }
            actionScript = "retrieveComponent('" + refreshComponent.getId() + "','" + refreshComponent.getFactoryId() + "','" + this.getMethodToCall() + "');";
        } else {
            actionScript = "submitForm();";
        }
        if (StringUtils.isNotBlank((String)this.getClientSideJs())) {
            actionScript = this.getClientSideJs() + actionScript;
        }
        this.setClientSideJs(actionScript);
        super.performFinalize(view, model, parent);
    }

    public String getRefreshId() {
        return this.refreshId;
    }

    public void setRefreshId(String refreshId) {
        this.refreshId = refreshId;
    }

    public String getRefreshPropertyName() {
        return this.refreshPropertyName;
    }

    public void setRefreshPropertyName(String refreshPropertyName) {
        this.refreshPropertyName = refreshPropertyName;
    }
}

