/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.field;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.ContainerBase;
import org.kuali.rice.krad.uif.container.PageGroup;
import org.kuali.rice.krad.uif.field.FieldBase;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.util.AutoPopulatingList;

public class ErrorsField
extends FieldBase {
    private static final long serialVersionUID = 780940788435330077L;
    private List<String> additionalKeysToMatch;
    private boolean fireGrowlsForMessages;
    private String growlScript = "";
    private String errorTitle;
    private String warningTitle;
    private String infoTitle;
    private boolean displayErrorTitle;
    private boolean displayWarningTitle;
    private boolean displayInfoTitle;
    private boolean highlightOnError;
    private boolean displayFieldErrorIcon;
    private boolean displayFieldLabelWithMessages;
    private boolean combineMessages;
    private boolean displayNestedMessages;
    private boolean allowMessageRepeat;
    private boolean displayMessages;
    private boolean displayErrorMessages;
    private boolean displayInfoMessages;
    private boolean displayWarningMessages;
    private boolean displayCounts;
    private boolean alternateContainer = false;
    private List<String> errors;
    private List<String> warnings;
    private List<String> infos;
    private int errorCount;
    private int warningCount;
    private int infoCount;
    private boolean displayLockMessages;

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        this.generateMessages(true, view, model, parent);
    }

    public void generateMessages(boolean reset, View view, Object model, Component parent) {
        if (reset) {
            this.errors = new ArrayList<String>();
            this.warnings = new ArrayList<String>();
            this.infos = new ArrayList<String>();
            this.errorCount = 0;
            this.warningCount = 0;
            this.infoCount = 0;
        }
        List<String> masterKeyList = this.getKeys(parent);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        if (!this.displayFieldLabelWithMessages) {
            this.addStyleClass("noLabels");
        }
        if (!this.highlightOnError) {
            this.addStyleClass("noHighlight");
        }
        if (this.displayFieldErrorIcon) {
            this.addStyleClass("addFieldIcon");
        }
        if (this.displayMessages) {
            if (this.displayNestedMessages) {
                this.addNestedKeys(masterKeyList, parent);
            }
            for (String key : masterKeyList) {
                if (this.displayErrorMessages) {
                    this.errors.addAll(this.getMessages(view, key, messageMap.getErrorMessagesForProperty(key, true)));
                }
                if (this.displayWarningMessages) {
                    this.warnings.addAll(this.getMessages(view, key, messageMap.getWarningMessagesForProperty(key, true)));
                }
                if (!this.displayInfoMessages) continue;
                this.infos.addAll(this.getMessages(view, key, messageMap.getInfoMessagesForProperty(key, true)));
            }
        } else if (this.displayFieldErrorIcon) {
            for (String key : masterKeyList) {
                if (messageMap.getErrorMessagesForProperty(key, true).isEmpty()) continue;
                this.errorCount = 1;
                break;
            }
        }
        if (parent instanceof PageGroup) {
            List diff;
            if (this.errorCount < messageMap.getErrorCount()) {
                diff = messageMap.getPropertiesWithErrors();
                diff.removeAll(masterKeyList);
                for (String key : diff) {
                    this.errors.addAll(this.getMessages(view, key, messageMap.getErrorMessagesForProperty(key, true)));
                }
            }
            if (this.warningCount < messageMap.getWarningCount()) {
                diff = messageMap.getPropertiesWithWarnings();
                diff.removeAll(masterKeyList);
                for (String key : diff) {
                    this.warnings.addAll(this.getMessages(view, key, messageMap.getWarningMessagesForProperty(key, true)));
                }
            }
            if (this.infoCount < messageMap.getInfoCount()) {
                diff = messageMap.getPropertiesWithInfo();
                diff.removeAll(masterKeyList);
                for (String key : diff) {
                    this.infos.addAll(this.getMessages(view, key, messageMap.getInfoMessagesForProperty(key, true)));
                }
            }
            this.setId("errorsFieldForPage");
        }
        if (this.fireGrowlsForMessages) {
            this.growlScript = this.getGrowlScript(view);
        }
        this.errors = new ArrayList<String>(new LinkedHashSet<String>(this.errors));
        this.warnings = new ArrayList<String>(new LinkedHashSet<String>(this.warnings));
        this.infos = new ArrayList<String>(new LinkedHashSet<String>(this.infos));
        this.errorCount = this.errors.size();
        this.warningCount = this.warnings.size();
        this.infoCount = this.infos.size();
        if (this.errorCount + this.warningCount + this.infoCount == 0 || !this.displayMessages) {
            this.setStyle("display: none;");
        } else {
            this.setStyle("display: visible");
        }
    }

    private List<String> getMessages(View view, String key, List<AutoPopulatingList<ErrorMessage>> lists) {
        ArrayList<String> result = new ArrayList<String>();
        for (List list : lists) {
            if (list == null || !StringUtils.isNotBlank((String)key)) continue;
            ConfigurationService configService = KRADServiceLocator.getKualiConfigurationService();
            String comboMessage = "";
            String label = "";
            for (ErrorMessage e : list) {
                InputField field;
                String message = configService.getPropertyValueAsString(e.getErrorKey());
                if (message == null) {
                    message = "Intended message with key: " + e.getErrorKey() + " not found.";
                }
                if (e.getMessageParameters() != null) {
                    message = message.replace("'", "''");
                    message = MessageFormat.format(message, e.getMessageParameters());
                }
                if (this.displayFieldLabelWithMessages && (field = (InputField)view.getViewIndex().getDataFieldByPath(key)) != null && field.getLabel() != null) {
                    label = field.getLabel();
                }
                if (this.combineMessages) {
                    if (comboMessage.isEmpty()) {
                        comboMessage = message;
                        continue;
                    }
                    comboMessage = comboMessage + ",  " + message;
                    continue;
                }
                if (StringUtils.isNotEmpty((String)label)) {
                    result.add(label + " - " + message);
                    continue;
                }
                result.add(message);
            }
            if (!StringUtils.isNotEmpty((String)comboMessage)) continue;
            if (StringUtils.isNotEmpty((String)label)) {
                result.add(label + " - " + comboMessage);
                continue;
            }
            result.add(comboMessage);
        }
        return result;
    }

    protected List<String> getKeys(Component parent) {
        ArrayList<String> keyList = new ArrayList<String>();
        if (this.additionalKeysToMatch != null) {
            keyList.addAll(this.additionalKeysToMatch);
        }
        if (StringUtils.isNotBlank((String)parent.getId())) {
            keyList.add(parent.getId());
        }
        if (parent instanceof InputField && ((InputField)parent).getBindingInfo() != null && StringUtils.isNotEmpty((String)((InputField)parent).getBindingInfo().getBindingPath())) {
            keyList.add(((InputField)parent).getBindingInfo().getBindingPath());
        }
        return keyList;
    }

    private void addNestedKeys(List<String> keyList, Component component) {
        for (Component c : component.getComponentsForLifecycle()) {
            ErrorsField ef = null;
            if (c instanceof InputField) {
                ef = ((InputField)c).getErrorsField();
            } else if (c instanceof ContainerBase) {
                ef = ((ContainerBase)c).getErrorsField();
            }
            if (ef == null) continue;
            if (!this.allowMessageRepeat) {
                ef.setDisplayMessages(false);
            }
            keyList.addAll(ef.getKeys(c));
            this.addNestedKeys(keyList, c);
        }
    }

    public String getErrorTitle() {
        return this.errorTitle;
    }

    public void setErrorTitle(String errorTitle) {
        this.errorTitle = errorTitle;
    }

    public String getWarningTitle() {
        return this.warningTitle;
    }

    public void setWarningTitle(String warningTitle) {
        this.warningTitle = warningTitle;
    }

    public String getInfoTitle() {
        return this.infoTitle;
    }

    public void setInfoTitle(String infoTitle) {
        this.infoTitle = infoTitle;
    }

    public boolean isDisplayErrorMessages() {
        return this.displayErrorMessages;
    }

    public void setDisplayErrorMessages(boolean displayErrorMessages) {
        this.displayErrorMessages = displayErrorMessages;
    }

    public boolean isDisplayInfoMessages() {
        return this.displayInfoMessages;
    }

    public void setDisplayInfoMessages(boolean displayInfoMessages) {
        this.displayInfoMessages = displayInfoMessages;
    }

    public boolean isDisplayLockMessages() {
        return this.displayLockMessages;
    }

    public void setDisplayLockMessages(boolean displayLockMessages) {
        this.displayLockMessages = displayLockMessages;
    }

    public boolean isDisplayWarningMessages() {
        return this.displayWarningMessages;
    }

    public void setDisplayWarningMessages(boolean displayWarningMessages) {
        this.displayWarningMessages = displayWarningMessages;
    }

    public List<String> getAdditionalKeysToMatch() {
        return this.additionalKeysToMatch;
    }

    public void setAdditionalKeysToMatch(String additionalKeysToMatch) {
        if (StringUtils.isNotBlank((String)additionalKeysToMatch)) {
            this.additionalKeysToMatch = Arrays.asList(StringUtils.split((String)additionalKeysToMatch, (String)","));
        }
    }

    public void setAdditionalKeysToMatch(List<String> additionalKeysToMatch) {
        this.additionalKeysToMatch = additionalKeysToMatch;
    }

    public boolean isDisplayErrorTitle() {
        return this.displayErrorTitle;
    }

    public void setDisplayErrorTitle(boolean displayErrorTitle) {
        this.displayErrorTitle = displayErrorTitle;
    }

    public boolean isDisplayWarningTitle() {
        return this.displayWarningTitle;
    }

    public void setDisplayWarningTitle(boolean displayWarningTitle) {
        this.displayWarningTitle = displayWarningTitle;
    }

    public boolean isDisplayInfoTitle() {
        return this.displayInfoTitle;
    }

    public void setDisplayInfoTitle(boolean displayInfoTitle) {
        this.displayInfoTitle = displayInfoTitle;
    }

    public boolean isDisplayFieldLabelWithMessages() {
        return this.displayFieldLabelWithMessages;
    }

    public void setDisplayFieldLabelWithMessages(boolean displayFieldLabelWithMessages) {
        this.displayFieldLabelWithMessages = displayFieldLabelWithMessages;
    }

    public boolean isDisplayMessages() {
        return this.displayMessages;
    }

    public void setDisplayMessages(boolean displayMessages) {
        this.displayMessages = displayMessages;
    }

    public boolean isDisplayNestedMessages() {
        return this.displayNestedMessages;
    }

    public void setDisplayNestedMessages(boolean displayNestedMessages) {
        this.displayNestedMessages = displayNestedMessages;
    }

    public boolean isCombineMessages() {
        return this.combineMessages;
    }

    public void setCombineMessages(boolean combineMessages) {
        this.combineMessages = combineMessages;
    }

    public boolean isAllowMessageRepeat() {
        return this.allowMessageRepeat;
    }

    public void setAllowMessageRepeat(boolean allowMessageRepeat) {
        this.allowMessageRepeat = allowMessageRepeat;
    }

    public boolean isDisplayCounts() {
        return this.displayCounts;
    }

    public void setDisplayCounts(boolean displayCounts) {
        this.displayCounts = displayCounts;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public List<String> getInfos() {
        return this.infos;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getInfoCount() {
        return this.infoCount;
    }

    public boolean isAlternateContainer() {
        return this.alternateContainer;
    }

    public void setAlternateContainer(boolean alternateContainer) {
        this.alternateContainer = alternateContainer;
    }

    public boolean isDisplayFieldErrorIcon() {
        return this.displayFieldErrorIcon;
    }

    public void setDisplayFieldErrorIcon(boolean displayFieldErrorIcon) {
        this.displayFieldErrorIcon = displayFieldErrorIcon;
    }

    public void setHighlightOnError(boolean highlightOnError) {
        this.highlightOnError = highlightOnError;
    }

    public boolean isHighlightOnError() {
        return this.highlightOnError;
    }

    private String getGrowlScript(View view) {
        String growlScript = "";
        if (view.isGrowlMessagingEnabled()) {
            String message;
            ConfigurationService configService = KRADServiceLocator.getKualiConfigurationService();
            MessageMap messageMap = GlobalVariables.getMessageMap();
            if (messageMap.hasErrors() && StringUtils.isNotBlank((String)(message = configService.getPropertyValueAsString("growl.hasErrors")))) {
                growlScript = growlScript + "showGrowl('" + message + "', '" + configService.getPropertyValueAsString("general.error") + "', 'errorGrowl');";
            }
            if (messageMap.hasWarnings() && StringUtils.isNotBlank((String)(message = configService.getPropertyValueAsString("growl.hasWarnings")))) {
                growlScript = growlScript + "showGrowl('" + message + "', '" + configService.getPropertyValueAsString("general.warning") + "', 'warningGrowl');";
            }
            if (messageMap.hasInfo()) {
                List properties = messageMap.getPropertiesWithInfo();
                String message2 = "";
                for (String property : properties) {
                    List lists = messageMap.getInfoMessagesForProperty(property, true);
                    for (List errorList : lists) {
                        if (errorList == null) continue;
                        for (ErrorMessage e : errorList) {
                            message2 = StringUtils.isBlank((String)message2) ? configService.getPropertyValueAsString(e.getErrorKey()) : message2 + "<br/>" + configService.getPropertyValueAsString(e.getErrorKey());
                            if (e.getMessageParameters() == null) continue;
                            message2 = message2.replace("'", "''");
                            message2 = MessageFormat.format(message2, e.getMessageParameters());
                        }
                    }
                }
                if (StringUtils.isNotBlank((String)message2)) {
                    growlScript = growlScript + "showGrowl('" + message2 + "', '" + configService.getPropertyValueAsString("general.info") + "', 'infoGrowl');";
                }
            }
        }
        return growlScript;
    }

    public boolean isFireGrowlsForMessages() {
        return this.fireGrowlsForMessages;
    }

    public void setFireGrowlsForMessages(boolean fireGrowlsForMessages) {
        this.fireGrowlsForMessages = fireGrowlsForMessages;
    }

    public String getGrowlScript() {
        return this.growlScript;
    }
}

