/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.layout;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.KeepExpression;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.field.ActionField;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.layout.CollectionLayoutManager;
import org.kuali.rice.krad.uif.layout.LayoutManagerBase;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;

public class StackedLayoutManager
extends LayoutManagerBase
implements CollectionLayoutManager {
    private static final long serialVersionUID = 4602368505430238846L;
    @KeepExpression
    private String summaryTitle;
    private List<String> summaryFields = new ArrayList<String>();
    private Group addLineGroup;
    private Group lineGroupPrototype;
    private FieldGroup subCollectionFieldGroupPrototype;
    private Field selectFieldPrototype;
    private Group wrapperGroup;
    private List<Group> stackedGroups = new ArrayList<Group>();

    @Override
    public void performInitialization(View view, Object model, Container container) {
        super.performInitialization(view, model, container);
        this.stackedGroups = new ArrayList<Group>();
        if (this.addLineGroup != null) {
            view.getViewHelperService().performComponentInitialization(view, model, this.addLineGroup);
        }
        view.getViewHelperService().performComponentInitialization(view, model, this.lineGroupPrototype);
        view.getViewHelperService().performComponentInitialization(view, model, this.subCollectionFieldGroupPrototype);
        view.getViewHelperService().performComponentInitialization(view, model, this.selectFieldPrototype);
    }

    @Override
    public void performApplyModel(View view, Object model, Container container) {
        super.performApplyModel(view, model, container);
        if (this.wrapperGroup != null) {
            this.wrapperGroup.setItems(this.stackedGroups);
        }
    }

    @Override
    public void buildLine(View view, Object model, CollectionGroup collectionGroup, List<Field> lineFields, List<FieldGroup> subCollectionFields, String bindingPath, List<ActionField> actions, String idSuffix, Object currentLine, int lineIndex) {
        boolean isAddLine = lineIndex == -1;
        Group lineGroup = null;
        if (isAddLine) {
            this.stackedGroups = new ArrayList<Group>();
            lineGroup = this.addLineGroup == null ? ComponentUtils.copy(this.lineGroupPrototype, idSuffix) : ComponentUtils.copy(this.getAddLineGroup(), idSuffix);
        } else {
            lineGroup = ComponentUtils.copy(this.lineGroupPrototype, idSuffix);
        }
        ComponentUtils.updateContextForLine(lineGroup, currentLine, lineIndex);
        String headerText = "";
        if (isAddLine) {
            headerText = collectionGroup.getAddLineLabel();
        } else {
            List modelCollection = (List)ObjectPropertyUtils.getPropertyValue(model, collectionGroup.getBindingInfo().getBindingPath());
            headerText = this.buildLineHeaderText(modelCollection.get(lineIndex), lineGroup);
        }
        if (StringUtils.isNotBlank((String)headerText) && lineGroup.getHeader() != null) {
            lineGroup.getHeader().setHeaderText(headerText);
        }
        ArrayList<Field> groupFields = new ArrayList<Field>();
        groupFields.addAll(lineFields);
        groupFields.addAll(subCollectionFields);
        lineGroup.setItems(groupFields);
        if (collectionGroup.isRenderLineActions() && !collectionGroup.isReadOnly() && lineGroup.getFooter() != null) {
            lineGroup.getFooter().setItems(actions);
        }
        this.stackedGroups.add(lineGroup);
    }

    protected String buildLineHeaderText(Object line, Group lineGroup) {
        if (KRADServiceLocatorWeb.getExpressionEvaluatorService().containsElPlaceholder(this.summaryTitle)) {
            lineGroup.getPropertyExpressions().put("title", this.summaryTitle);
            return null;
        }
        String summaryFieldString = "";
        for (String summaryField : this.summaryFields) {
            Object summaryFieldValue = ObjectPropertyUtils.getPropertyValue(line, summaryField);
            if (StringUtils.isNotBlank((String)summaryFieldString)) {
                summaryFieldString = summaryFieldString + " - ";
            }
            if (summaryFieldValue != null) {
                summaryFieldString = summaryFieldString + summaryFieldValue;
                continue;
            }
            summaryFieldString = summaryFieldString + "Null";
        }
        String headerText = this.summaryTitle;
        if (StringUtils.isNotBlank((String)summaryFieldString)) {
            headerText = headerText + " ( " + summaryFieldString + " )";
        }
        return headerText;
    }

    @Override
    public Class<? extends Container> getSupportedContainer() {
        return CollectionGroup.class;
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        if (this.wrapperGroup != null) {
            components.add(this.wrapperGroup);
        } else {
            components.addAll(this.stackedGroups);
        }
        return components;
    }

    @Override
    public List<Component> getComponentPrototypes() {
        List<Component> components = super.getComponentPrototypes();
        components.add(this.addLineGroup);
        components.add(this.lineGroupPrototype);
        components.add(this.subCollectionFieldGroupPrototype);
        components.add(this.selectFieldPrototype);
        return components;
    }

    public String getSummaryTitle() {
        return this.summaryTitle;
    }

    public void setSummaryTitle(String summaryTitle) {
        this.summaryTitle = summaryTitle;
    }

    public List<String> getSummaryFields() {
        return this.summaryFields;
    }

    public void setSummaryFields(List<String> summaryFields) {
        this.summaryFields = summaryFields;
    }

    public Group getAddLineGroup() {
        return this.addLineGroup;
    }

    public void setAddLineGroup(Group addLineGroup) {
        this.addLineGroup = addLineGroup;
    }

    public Group getLineGroupPrototype() {
        return this.lineGroupPrototype;
    }

    public void setLineGroupPrototype(Group lineGroupPrototype) {
        this.lineGroupPrototype = lineGroupPrototype;
    }

    @Override
    public FieldGroup getSubCollectionFieldGroupPrototype() {
        return this.subCollectionFieldGroupPrototype;
    }

    public void setSubCollectionFieldGroupPrototype(FieldGroup subCollectionFieldGroupPrototype) {
        this.subCollectionFieldGroupPrototype = subCollectionFieldGroupPrototype;
    }

    public Field getSelectFieldPrototype() {
        return this.selectFieldPrototype;
    }

    public void setSelectFieldPrototype(Field selectFieldPrototype) {
        this.selectFieldPrototype = selectFieldPrototype;
    }

    public Group getWrapperGroup() {
        return this.wrapperGroup;
    }

    public void setWrapperGroup(Group wrapperGroup) {
        this.wrapperGroup = wrapperGroup;
    }

    public List<Group> getStackedGroups() {
        return this.stackedGroups;
    }

    public void setStackedGroups(List<Group> stackedGroups) {
        this.stackedGroups = stackedGroups;
    }
}

