/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.service.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.LookupService;
import org.kuali.rice.krad.uif.component.MethodInvokerConfig;
import org.kuali.rice.krad.uif.field.AttributeQuery;
import org.kuali.rice.krad.uif.field.AttributeQueryResult;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.service.AttributeQueryService;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.Suggest;
import org.kuali.rice.krad.util.BeanPropertyComparator;

public class AttributeQueryServiceImpl
implements AttributeQueryService {
    private LookupService lookupService;
    private ConfigurationService configurationService;

    @Override
    public AttributeQueryResult performFieldSuggestQuery(View view, String fieldId, String fieldTerm, Map<String, String> queryParameters) {
        AttributeQueryResult queryResult = new AttributeQueryResult();
        InputField inputField = (InputField)view.getViewIndex().getComponentById(fieldId);
        if (inputField == null) {
            throw new RuntimeException("Unable to find attribute field instance for id: " + fieldId);
        }
        Suggest fieldSuggest = inputField.getFieldSuggest();
        AttributeQuery suggestQuery = fieldSuggest.getSuggestQuery();
        HashMap<String, String> additionalCriteria = new HashMap<String, String>();
        additionalCriteria.put(fieldSuggest.getSourcePropertyName(), fieldTerm + "*");
        Collection results = null;
        if (suggestQuery.hasConfiguredMethod()) {
            Object queryMethodResult = this.executeAttributeQueryMethod(view, suggestQuery, queryParameters);
            if (queryMethodResult != null && queryMethodResult instanceof Collection) {
                results = (Collection)queryMethodResult;
            }
        } else {
            results = this.executeAttributeQueryCriteria(suggestQuery, queryParameters, additionalCriteria);
        }
        if (results != null) {
            ArrayList<String> suggestData = new ArrayList<String>();
            for (Object result : results) {
                Object suggestFieldValue = ObjectPropertyUtils.getPropertyValue(result, fieldSuggest.getSourcePropertyName());
                if (suggestFieldValue == null) continue;
                suggestData.add(suggestFieldValue.toString());
            }
            queryResult.setResultData(suggestData);
        }
        return queryResult;
    }

    @Override
    public AttributeQueryResult performFieldQuery(View view, String fieldId, Map<String, String> queryParameters) {
        AttributeQueryResult queryResult = new AttributeQueryResult();
        InputField inputField = (InputField)view.getViewIndex().getComponentById(fieldId);
        if (inputField == null) {
            throw new RuntimeException("Unable to find attribute field instance for id: " + fieldId);
        }
        AttributeQuery fieldQuery = inputField.getFieldAttributeQuery();
        if (fieldQuery == null) {
            throw new RuntimeException("Field query not defined for field instance with id: " + fieldId);
        }
        Object resultObject = null;
        if (fieldQuery.hasConfiguredMethod()) {
            Object queryMethodResult = this.executeAttributeQueryMethod(view, fieldQuery, queryParameters);
            if (queryMethodResult != null) {
                if (queryMethodResult instanceof AttributeQueryResult) {
                    return (AttributeQueryResult)queryMethodResult;
                }
                if (queryMethodResult instanceof Collection) {
                    Collection methodResultCollection = (Collection)queryMethodResult;
                    if (!methodResultCollection.isEmpty()) {
                        resultObject = methodResultCollection.iterator().next();
                    }
                } else {
                    resultObject = queryMethodResult;
                }
            }
        } else {
            Collection<?> results = this.executeAttributeQueryCriteria(fieldQuery, queryParameters, null);
            if (results != null && !results.isEmpty()) {
                resultObject = results.size() > 1 ? null : results.iterator().next();
            }
        }
        if (resultObject != null) {
            HashMap<String, String> resultFieldData = new HashMap<String, String>();
            for (String fromField : fieldQuery.getReturnFieldMapping().keySet()) {
                String returnField = fieldQuery.getReturnFieldMapping().get(fromField);
                String fieldValueStr = "";
                Object fieldValue = ObjectPropertyUtils.getPropertyValue(resultObject, fromField);
                if (fieldValue != null) {
                    fieldValueStr = fieldValue.toString();
                }
                resultFieldData.put(returnField, fieldValueStr);
            }
            queryResult.setResultFieldData(resultFieldData);
            fieldQuery.setReturnMessageText("");
        } else if (fieldQuery.isRenderNotFoundMessage()) {
            String messageTemplate = this.getConfigurationService().getPropertyValueAsString("query.dataNotFound");
            String message = MessageFormat.format(messageTemplate, inputField.getLabel());
            fieldQuery.setReturnMessageText(message.toLowerCase());
        }
        queryResult.setResultMessage(fieldQuery.getReturnMessageText());
        queryResult.setResultMessageStyleClasses(fieldQuery.getReturnMessageStyleClasses());
        return queryResult;
    }

    protected Object executeAttributeQueryMethod(View view, AttributeQuery attributeQuery, Map<String, String> queryParameters) {
        String queryMethodToCall = attributeQuery.getQueryMethodToCall();
        MethodInvokerConfig queryMethodInvoker = attributeQuery.getQueryMethodInvokerConfig();
        if (queryMethodInvoker == null) {
            queryMethodInvoker = new MethodInvokerConfig();
        }
        if (StringUtils.isBlank((String)queryMethodInvoker.getTargetMethod())) {
            queryMethodInvoker.setTargetMethod(queryMethodToCall);
        }
        if (queryMethodInvoker.getTargetClass() == null && queryMethodInvoker.getTargetObject() == null) {
            queryMethodInvoker.setTargetObject(view.getViewHelperService());
        }
        Object[] arguments = null;
        if (attributeQuery.getQueryMethodArgumentFieldList() != null && !attributeQuery.getQueryMethodArgumentFieldList().isEmpty()) {
            Class[] argumentTypes = queryMethodInvoker.getArgumentTypes();
            if (argumentTypes == null || argumentTypes.length != attributeQuery.getQueryMethodArgumentFieldList().size()) {
                throw new RuntimeException("Query method argument field list size does not match found method argument list size");
            }
            arguments = new Object[attributeQuery.getQueryMethodArgumentFieldList().size()];
            for (int i = 0; i < attributeQuery.getQueryMethodArgumentFieldList().size(); ++i) {
                String methodArgumentFromField = attributeQuery.getQueryMethodArgumentFieldList().get(i);
                arguments[i] = queryParameters.containsKey(methodArgumentFromField) ? queryParameters.get(methodArgumentFromField) : null;
            }
        }
        queryMethodInvoker.setArguments(arguments);
        try {
            queryMethodInvoker.prepare();
            return queryMethodInvoker.invoke();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to invoke query method: " + queryMethodInvoker.getTargetMethod(), e);
        }
    }

    protected Collection<?> executeAttributeQueryCriteria(AttributeQuery attributeQuery, Map<String, String> queryParameters, Map<String, String> additionalCriteria) {
        Collection<?> results = null;
        HashMap<String, String> queryCriteria = new HashMap<String, String>();
        for (String fieldName : attributeQuery.getQueryFieldMapping().values()) {
            if (!queryParameters.containsKey(fieldName) || !StringUtils.isNotBlank((String)queryParameters.get(fieldName))) continue;
            queryCriteria.put(fieldName, queryParameters.get(fieldName));
        }
        for (String fieldName : attributeQuery.getAdditionalCriteria().keySet()) {
            queryCriteria.put(fieldName, attributeQuery.getAdditionalCriteria().get(fieldName));
        }
        if (additionalCriteria != null) {
            queryCriteria.putAll(additionalCriteria);
        }
        Class<?> queryClass = null;
        try {
            queryClass = Class.forName(attributeQuery.getDataObjectClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Invalid data object class given for suggest query: " + attributeQuery.getDataObjectClassName(), e);
        }
        results = this.getLookupService().findCollectionBySearchUnbounded(queryClass, queryCriteria);
        if (!attributeQuery.getSortPropertyNames().isEmpty() && results != null && results.size() > 1) {
            Collections.sort((List)results, new BeanPropertyComparator(attributeQuery.getSortPropertyNames()));
        }
        return results;
    }

    protected LookupService getLookupService() {
        if (this.lookupService == null) {
            this.lookupService = KRADServiceLocatorWeb.getLookupService();
        }
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    protected ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = KRADServiceLocator.getKualiConfigurationService();
        }
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

