/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.type.TypeUtils;

public class ScriptUtils {
    public static String translateValue(Object value) {
        String jsValue = "";
        if (value == null) {
            jsValue = "null";
            return jsValue;
        }
        if (value instanceof List) {
            jsValue = "[";
            List list = (List)value;
            for (Object listItem : list) {
                jsValue = jsValue + ScriptUtils.translateValue(listItem);
                jsValue = jsValue + ",";
            }
            jsValue = StringUtils.removeEnd((String)jsValue, (String)",");
            jsValue = jsValue + "]";
        } else if (value instanceof Set) {
            jsValue = "[";
            Set set = (Set)value;
            for (Object setItem : set) {
                jsValue = jsValue + ScriptUtils.translateValue(setItem);
                jsValue = jsValue + ",";
            }
            jsValue = StringUtils.removeEnd((String)jsValue, (String)",");
            jsValue = jsValue + "]";
        } else if (value instanceof Map) {
            jsValue = "{";
            Map map = (Map)value;
            for (Map.Entry mapEntry : map.entrySet()) {
                jsValue = jsValue + mapEntry.getKey().toString() + ":";
                jsValue = jsValue + ScriptUtils.translateValue(mapEntry.getValue());
                jsValue = jsValue + ",";
            }
            jsValue = StringUtils.removeEnd((String)jsValue, (String)",");
            jsValue = jsValue + "}";
        } else {
            boolean quoteValue = true;
            Class<?> valueClass = value.getClass();
            if (TypeUtils.isBooleanClass(valueClass) || TypeUtils.isDecimalClass(valueClass) || TypeUtils.isIntegralClass(valueClass)) {
                quoteValue = false;
            }
            if (quoteValue) {
                jsValue = "\"";
            }
            jsValue = jsValue + value.toString();
            if (quoteValue) {
                jsValue = jsValue + "\"";
            }
        }
        return jsValue;
    }

    public static String escapeName(String name) {
        name = name.replace("'", "\\'");
        return name;
    }
}

