/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.service.ViewService;
import org.kuali.rice.krad.uif.view.History;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.controller.UifControllerBase;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.web.servlet.ModelAndView;

public class UifWebUtils {
    private static final Logger LOG = Logger.getLogger(UifWebUtils.class);

    public static ModelAndView getUIFModelAndView(UifFormBase form, String pageId) {
        if (StringUtils.isNotBlank((String)pageId)) {
            form.setPageId(pageId);
        }
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.addObject("KualiForm", (Object)form);
        modelAndView.setViewName("Application");
        return modelAndView;
    }

    public static ModelAndView getComponentModelAndView(Component component, Object model) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.addObject("KualiForm", model);
        modelAndView.addObject("Component", (Object)component);
        modelAndView.setViewName("ComponentUpdate");
        return modelAndView;
    }

    public static void postControllerHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (handler instanceof UifControllerBase && modelAndView != null) {
            Object model;
            UifControllerBase controller = (UifControllerBase)handler;
            UifFormBase form = null;
            if (modelAndView.getViewName().equals("Application") && (model = modelAndView.getModelMap().get((Object)"KualiForm")) instanceof UifFormBase) {
                form = (UifFormBase)model;
                UifWebUtils.prepareViewForRendering(request, form);
                UifWebUtils.prepareHistory(request, form);
            }
        }
    }

    public static void prepareHistory(HttpServletRequest request, UifFormBase form) {
        View view = form.getView();
        History history = form.getFormHistory();
        if (history == null || request.getMethod().equals("GET")) {
            history = new History();
            history.setHomewardPath(view.getBreadcrumbs().getHomewardPathList());
            history.setAppendHomewardPath(view.getBreadcrumbs().isDisplayHomewardPath());
            history.setAppendPassedHistory(view.getBreadcrumbs().isDisplayPassedHistory());
            if (StringUtils.isNotBlank((String)request.getParameter("showHome"))) {
                history.setAppendHomewardPath(Boolean.parseBoolean(request.getParameter("showHome")));
            }
            if (StringUtils.isNotBlank((String)request.getParameter("showHistory"))) {
                history.setAppendPassedHistory(Boolean.parseBoolean(request.getParameter("showHistory")));
            }
            history.setCurrent(form, request);
            history.buildHistoryFromParameterString(request.getParameter("history"));
            form.setFormHistory(history);
        }
    }

    public static void prepareViewForRendering(HttpServletRequest request, UifFormBase form) {
        View view = form.getView();
        if (StringUtils.isNotBlank((String)form.getPageId())) {
            view.setCurrentPageId(form.getPageId());
        }
        Map<String, String> parameterMap = KRADUtils.translateRequestParameterMap(request.getParameterMap());
        parameterMap.putAll(form.getViewRequestParameters());
        UifWebUtils.getViewService().buildView(view, form, parameterMap);
        form.setValidateDirty(view.isValidateDirty());
    }

    protected static ViewService getViewService() {
        return KRADServiceLocatorWeb.getViewService();
    }
}

