/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ReferenceCopy;
import org.kuali.rice.krad.uif.component.RequestParameter;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.container.ContainerBase;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.NavigationGroup;
import org.kuali.rice.krad.uif.container.PageGroup;
import org.kuali.rice.krad.uif.field.HeaderField;
import org.kuali.rice.krad.uif.field.LinkField;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.service.ViewHelperService;
import org.kuali.rice.krad.uif.util.BooleanMap;
import org.kuali.rice.krad.uif.util.ClientValidationUtils;
import org.kuali.rice.krad.uif.view.ViewAuthorizer;
import org.kuali.rice.krad.uif.view.ViewIndex;
import org.kuali.rice.krad.uif.view.ViewPresentationController;
import org.kuali.rice.krad.uif.view.ViewTheme;
import org.kuali.rice.krad.uif.widget.BreadCrumbs;
import org.kuali.rice.krad.uif.widget.Growls;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.web.form.UifFormBase;

public class View
extends ContainerBase {
    private static final long serialVersionUID = -1220009725554576953L;
    private String viewNamespaceCode;
    private String viewName;
    private ViewTheme theme;
    private int idSequence = 0;
    private HeaderField applicationHeader;
    private Group applicationFooter;
    private BreadCrumbs breadcrumbs;
    private String viewLabelFieldPropertyName;
    private String appendOption;
    private boolean breadcrumbsInApplicationHeader = false;
    private Growls growls;
    private boolean growlMessagingEnabled;
    private String entryPageId;
    @RequestParameter
    private String currentPageId;
    private NavigationGroup navigation;
    private Class<?> formClass = UifFormBase.class;
    private String defaultBindingObjectPath;
    private Map<String, Class<?>> abstractTypeClasses;
    private List<String> additionalScriptFiles;
    private List<String> additionalCssFiles;
    private UifConstants.ViewType viewTypeName = UifConstants.ViewType.DEFAULT;
    private Class<? extends ViewHelperService> viewHelperServiceClassName;
    private String viewStatus = "C";
    private ViewIndex viewIndex = new ViewIndex();
    private Map<String, String> viewRequestParameters;
    private ViewPresentationController presentationController;
    private ViewAuthorizer authorizer;
    private BooleanMap actionFlags;
    private BooleanMap editModes;
    private Map<String, String> expressionVariables;
    private boolean singlePageView = false;
    private PageGroup page;
    private List<? extends Group> items;
    private LinkField viewMenuLink;
    private String viewMenuGrouping;
    private boolean validateDirty;
    private boolean translateCodes = false;
    private String preLoadScript;
    private Map<String, Object> clientSideState;
    private boolean supportsReadOnlyFieldsOverride = true;
    @RequestParameter
    private boolean dialogMode = false;
    @ReferenceCopy
    private ViewHelperService viewHelperService;

    public View() {
        this.additionalScriptFiles = new ArrayList<String>();
        this.additionalCssFiles = new ArrayList<String>();
        this.items = new ArrayList<Group>();
        this.abstractTypeClasses = new HashMap();
        this.viewRequestParameters = new HashMap<String, String>();
        this.expressionVariables = new HashMap<String, String>();
        this.clientSideState = new HashMap<String, Object>();
    }

    @Override
    public void performInitialization(View view, Object model) {
        super.performInitialization(view, model);
        if (this.singlePageView) {
            if (this.page != null) {
                this.page.setItems(new ArrayList<Group>(this.items));
                this.items = new ArrayList<Group>();
                this.items.add(this.page);
            } else {
                throw new RuntimeException("For single paged views the page Group must be set.");
            }
        }
        for (Group group : this.getItems()) {
            if (!StringUtils.isBlank((String)group.getId())) continue;
            group.setId(view.getNextId());
        }
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        String prefixScript = "";
        if (this.getOnDocumentReadyScript() != null) {
            prefixScript = this.getPreLoadScript();
        }
        String growlScript = "";
        Growls gw = view.getGrowls();
        if (!gw.getComponentOptions().isEmpty()) {
            growlScript = "setGrowlDefaults(" + gw.getComponentOptionsJSString() + ");";
        }
        this.setPreLoadScript(prefixScript + growlScript);
        prefixScript = "";
        if (this.getOnDocumentReadyScript() != null) {
            prefixScript = this.getOnDocumentReadyScript();
        }
        this.setOnDocumentReadyScript(prefixScript + "jQuery.extend(jQuery.validator.messages, " + ClientValidationUtils.generateValidatorMessagesOption() + ");");
    }

    public void assignComponentIds(Component component) {
        LayoutManager layoutManager;
        if (component == null) {
            return;
        }
        Integer currentSequenceVal = this.idSequence;
        if (StringUtils.isBlank((String)component.getId())) {
            component.setId("u" + this.getNextId());
        }
        this.getViewIndex().addSequenceValueToSnapshot(component.getId(), currentSequenceVal);
        if (component instanceof Container && (layoutManager = ((Container)component).getLayoutManager()) != null && StringUtils.isBlank((String)layoutManager.getId())) {
            layoutManager.setId("u" + this.getNextId());
        }
        ArrayList<Component> allNested = new ArrayList<Component>(component.getComponentsForLifecycle());
        allNested.addAll(component.getComponentPrototypes());
        for (Component nestedComponent : allNested) {
            this.assignComponentIds(nestedComponent);
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.applicationHeader);
        components.add(this.applicationFooter);
        components.add(this.navigation);
        components.add(this.breadcrumbs);
        components.add(this.growls);
        components.add(this.viewMenuLink);
        if (!this.singlePageView) {
            for (Group group : this.getItems()) {
                if (!(group instanceof PageGroup) || StringUtils.equals((String)group.getId(), (String)this.getCurrentPageId()) || !components.contains(group)) continue;
                components.remove(group);
            }
        }
        return components;
    }

    @Override
    public List<Component> getComponentPrototypes() {
        List<Component> components = super.getComponentPrototypes();
        components.add(this.page);
        return components;
    }

    @Override
    public Set<Class<? extends Component>> getSupportedComponents() {
        HashSet<Class<? extends Component>> supportedComponents = new HashSet<Class<? extends Component>>();
        supportedComponents.add(Group.class);
        return supportedComponents;
    }

    @Override
    public String getComponentTypeName() {
        return "view";
    }

    public PageGroup getCurrentPage() {
        for (Group group : this.getItems()) {
            if (!StringUtils.equals((String)group.getId(), (String)this.getCurrentPageId()) || !(group instanceof PageGroup)) continue;
            return (PageGroup)group;
        }
        return null;
    }

    public String getViewNamespaceCode() {
        return this.viewNamespaceCode;
    }

    public void setViewNamespaceCode(String viewNamespaceCode) {
        this.viewNamespaceCode = viewNamespaceCode;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public HeaderField getApplicationHeader() {
        return this.applicationHeader;
    }

    public void setApplicationHeader(HeaderField applicationHeader) {
        this.applicationHeader = applicationHeader;
    }

    public Group getApplicationFooter() {
        return this.applicationFooter;
    }

    public void setApplicationFooter(Group applicationFooter) {
        this.applicationFooter = applicationFooter;
    }

    public int getIdSequence() {
        return this.idSequence;
    }

    public void setIdSequence(int idSequence) {
        this.idSequence = idSequence;
    }

    public String getNextId() {
        ++this.idSequence;
        return Integer.toString(this.idSequence);
    }

    public String getEntryPageId() {
        return this.entryPageId;
    }

    public void setEntryPageId(String entryPageId) {
        this.entryPageId = entryPageId;
    }

    public String getCurrentPageId() {
        if (StringUtils.isBlank((String)this.currentPageId)) {
            if (StringUtils.isNotBlank((String)this.entryPageId)) {
                this.currentPageId = this.entryPageId;
            } else if (this.getItems() != null && !this.getItems().isEmpty()) {
                Group firstPageGroup = this.getItems().get(0);
                this.currentPageId = firstPageGroup.getId();
            }
        }
        return this.currentPageId;
    }

    public void setCurrentPageId(String currentPageId) {
        this.currentPageId = currentPageId;
    }

    public NavigationGroup getNavigation() {
        return this.navigation;
    }

    public void setNavigation(NavigationGroup navigation) {
        this.navigation = navigation;
    }

    public Class<?> getFormClass() {
        return this.formClass;
    }

    public void setFormClass(Class<?> formClass) {
        this.formClass = formClass;
    }

    public String getDefaultBindingObjectPath() {
        return this.defaultBindingObjectPath;
    }

    public void setDefaultBindingObjectPath(String defaultBindingObjectPath) {
        this.defaultBindingObjectPath = defaultBindingObjectPath;
    }

    public Map<String, Class<?>> getAbstractTypeClasses() {
        return this.abstractTypeClasses;
    }

    public void setAbstractTypeClasses(Map<String, Class<?>> abstractTypeClasses) {
        this.abstractTypeClasses = abstractTypeClasses;
    }

    public List<String> getAdditionalScriptFiles() {
        return this.additionalScriptFiles;
    }

    public void setAdditionalScriptFiles(List<String> additionalScriptFiles) {
        this.additionalScriptFiles = additionalScriptFiles;
    }

    public List<String> getAdditionalCssFiles() {
        return this.additionalCssFiles;
    }

    public void setAdditionalCssFiles(List<String> additionalCssFiles) {
        this.additionalCssFiles = additionalCssFiles;
    }

    public boolean isDialogMode() {
        return this.dialogMode;
    }

    public void setDialogMode(boolean dialogMode) {
        this.dialogMode = dialogMode;
    }

    public UifConstants.ViewType getViewTypeName() {
        return this.viewTypeName;
    }

    public void setViewTypeName(UifConstants.ViewType viewTypeName) {
        this.viewTypeName = viewTypeName;
    }

    public Class<? extends ViewHelperService> getViewHelperServiceClassName() {
        return this.viewHelperServiceClassName;
    }

    public void setViewHelperServiceClassName(Class<? extends ViewHelperService> viewHelperServiceClassName) {
        this.viewHelperServiceClassName = viewHelperServiceClassName;
    }

    public ViewHelperService getViewHelperService() {
        if (this.viewHelperService == null) {
            this.viewHelperService = ObjectUtils.newInstance(this.viewHelperServiceClassName);
        }
        return this.viewHelperService;
    }

    public void index() {
        if (this.viewIndex == null) {
            this.viewIndex = new ViewIndex();
        }
        this.viewIndex.index(this);
    }

    public ViewIndex getViewIndex() {
        return this.viewIndex;
    }

    public Map<String, String> getViewRequestParameters() {
        return this.viewRequestParameters;
    }

    public void setViewRequestParameters(Map<String, String> viewRequestParameters) {
        this.viewRequestParameters = viewRequestParameters;
    }

    public ViewPresentationController getPresentationController() {
        return this.presentationController;
    }

    public void setPresentationController(ViewPresentationController presentationController) {
        this.presentationController = presentationController;
    }

    public void setPresentationControllerClass(Class<? extends ViewPresentationController> presentationControllerClass) {
        this.presentationController = ObjectUtils.newInstance(presentationControllerClass);
    }

    public ViewAuthorizer getAuthorizer() {
        return this.authorizer;
    }

    public void setAuthorizer(ViewAuthorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setAuthorizerClass(Class<? extends ViewAuthorizer> authorizerClass) {
        this.authorizer = ObjectUtils.newInstance(authorizerClass);
    }

    public BooleanMap getActionFlags() {
        return this.actionFlags;
    }

    public void setActionFlags(BooleanMap actionFlags) {
        this.actionFlags = actionFlags;
    }

    public BooleanMap getEditModes() {
        return this.editModes;
    }

    public void setEditModes(BooleanMap editModes) {
        this.editModes = editModes;
    }

    public Map<String, String> getExpressionVariables() {
        return this.expressionVariables;
    }

    public void setExpressionVariables(Map<String, String> expressionVariables) {
        this.expressionVariables = expressionVariables;
    }

    public boolean isSinglePageView() {
        return this.singlePageView;
    }

    public void setSinglePageView(boolean singlePageView) {
        this.singlePageView = singlePageView;
    }

    public PageGroup getPage() {
        return this.page;
    }

    public void setPage(PageGroup page) {
        this.page = page;
    }

    public List<? extends Group> getItems() {
        return this.items;
    }

    @Override
    public void setItems(List<? extends Component> items) {
        this.items = items;
    }

    public LinkField getViewMenuLink() {
        return this.viewMenuLink;
    }

    public void setViewMenuLink(LinkField viewMenuLink) {
        this.viewMenuLink = viewMenuLink;
    }

    public String getViewMenuGrouping() {
        return this.viewMenuGrouping;
    }

    public void setViewMenuGrouping(String viewMenuGrouping) {
        this.viewMenuGrouping = viewMenuGrouping;
    }

    public String getViewStatus() {
        return this.viewStatus;
    }

    public void setViewStatus(String viewStatus) {
        this.viewStatus = viewStatus;
    }

    public boolean isInitialized() {
        return StringUtils.equals((String)this.viewStatus, (String)"I") || StringUtils.equals((String)this.viewStatus, (String)"F");
    }

    public boolean isFinal() {
        return StringUtils.equals((String)this.viewStatus, (String)"F");
    }

    @Override
    public boolean getSupportsOnSubmit() {
        return true;
    }

    @Override
    public boolean getSupportsOnLoad() {
        return true;
    }

    @Override
    public boolean getSupportsOnDocumentReady() {
        return true;
    }

    public BreadCrumbs getBreadcrumbs() {
        return this.breadcrumbs;
    }

    public void setBreadcrumbs(BreadCrumbs breadcrumbs) {
        this.breadcrumbs = breadcrumbs;
    }

    public boolean isBreadcrumbsInApplicationHeader() {
        return this.breadcrumbsInApplicationHeader;
    }

    public void setBreadcrumbsInApplicationHeader(boolean breadcrumbsInApplicationHeader) {
        this.breadcrumbsInApplicationHeader = breadcrumbsInApplicationHeader;
    }

    public Growls getGrowls() {
        return this.growls;
    }

    public void setGrowls(Growls growls) {
        this.growls = growls;
    }

    public boolean isGrowlMessagingEnabled() {
        return this.growlMessagingEnabled;
    }

    public void setGrowlMessagingEnabled(boolean growlMessagingEnabled) {
        this.growlMessagingEnabled = growlMessagingEnabled;
    }

    public boolean isValidateDirty() {
        return this.validateDirty;
    }

    public void setValidateDirty(boolean validateDirty) {
        this.validateDirty = validateDirty;
    }

    public void setTranslateCodes(boolean translateCodes) {
        this.translateCodes = translateCodes;
    }

    public boolean isTranslateCodes() {
        return this.translateCodes;
    }

    public String getViewLabelFieldPropertyName() {
        return this.viewLabelFieldPropertyName;
    }

    public void setViewLabelFieldPropertyName(String viewLabelFieldPropertyName) {
        this.viewLabelFieldPropertyName = viewLabelFieldPropertyName;
    }

    public String getAppendOption() {
        return this.appendOption;
    }

    public void setAppendOption(String appendOption) {
        this.appendOption = appendOption;
    }

    public Map<String, Object> getClientSideState() {
        return this.clientSideState;
    }

    public void setClientSideState(Map<String, Object> clientSideState) {
        this.clientSideState = clientSideState;
    }

    public void addToClientSideState(String componentId, String variableName, Object value) {
        Map<String, Object> componentClientState = new HashMap<String, Object>();
        if (this.clientSideState.containsKey(componentId)) {
            Object clientState = this.clientSideState.get(componentId);
            if (clientState != null && clientState instanceof Map) {
                componentClientState = (Map)clientState;
            } else {
                throw new IllegalArgumentException("Client side state for component: " + componentId + " is not a Map");
            }
        }
        componentClientState.put(variableName, value);
        this.clientSideState.put(componentId, componentClientState);
    }

    public boolean isSupportsReadOnlyFieldsOverride() {
        return this.supportsReadOnlyFieldsOverride;
    }

    public void setSupportsReadOnlyFieldsOverride(boolean supportsReadOnlyFieldsOverride) {
        this.supportsReadOnlyFieldsOverride = supportsReadOnlyFieldsOverride;
    }

    public String getPreLoadScript() {
        return this.preLoadScript;
    }

    public void setPreLoadScript(String preLoadScript) {
        this.preLoadScript = preLoadScript;
    }

    public ViewTheme getTheme() {
        return this.theme;
    }

    public void setTheme(ViewTheme theme) {
        this.theme = theme;
    }
}

