/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.view;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.DataObjectAuthorizerBase;
import org.kuali.rice.krad.datadictionary.AttributeSecurity;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentSecurity;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.field.ActionField;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewAuthorizer;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.uif.widget.Widget;
import org.kuali.rice.krad.util.KRADUtils;

public class ViewAuthorizerBase
extends DataObjectAuthorizerBase
implements ViewAuthorizer {
    private static final long serialVersionUID = -2687378084630965412L;
    private static final Logger LOG = Logger.getLogger(ViewAuthorizerBase.class);
    private ConfigurationService configurationService;

    @Override
    public Set<String> getActionFlags(View view, ViewModel model, Person user, Set<String> actions) {
        if (actions.contains("canEdit") && !this.canEditView(view, model, user)) {
            actions.remove("canEdit");
        }
        return actions;
    }

    @Override
    public Set<String> getEditModes(View view, ViewModel model, Person user, Set<String> editModes) {
        HashSet<String> unauthorizedEditModes = new HashSet<String>();
        Object dataObjectForContext = this.getDataObjectContext(view, model);
        for (String editMode : editModes) {
            HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
            additionalPermissionDetails.put("editMode", editMode);
            if (!this.permissionExistsByTemplate(dataObjectForContext, "KR-NS", "Use Transactional Document", additionalPermissionDetails) || this.isAuthorizedByTemplate(dataObjectForContext, "KR-NS", "Use Transactional Document", user.getPrincipalId(), additionalPermissionDetails, null)) continue;
            unauthorizedEditModes.add(editMode);
        }
        editModes.removeAll(unauthorizedEditModes);
        return editModes;
    }

    @Override
    public boolean canOpenView(View view, ViewModel model, Person user) {
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("namespaceCode", view.getViewNamespaceCode());
        additionalPermissionDetails.put("viewId", model.getViewId());
        if (this.permissionExistsByTemplate(model, "KR-KRAD", "Open View", additionalPermissionDetails)) {
            return this.isAuthorizedByTemplate(model, "KR-KRAD", "Open View", user.getPrincipalId(), additionalPermissionDetails, null);
        }
        return true;
    }

    @Override
    public boolean canEditView(View view, ViewModel model, Person user) {
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("namespaceCode", view.getViewNamespaceCode());
        additionalPermissionDetails.put("viewId", model.getViewId());
        if (this.permissionExistsByTemplate(model, "KR-KRAD", "Edit View", additionalPermissionDetails)) {
            return this.isAuthorizedByTemplate(model, "KR-KRAD", "Edit View", user.getPrincipalId(), additionalPermissionDetails, null);
        }
        return true;
    }

    @Override
    public boolean canUnmaskField(View view, ViewModel model, DataField field, String propertyName, Person user) {
        AttributeSecurity attributeSecurity = field.getDataFieldSecurity().getAttributeSecurity();
        if (attributeSecurity == null || !attributeSecurity.isMask()) {
            return true;
        }
        if (this.isNonProductionEnvAndUnmaskingTurnedOff()) {
            return false;
        }
        Object dataObjectForContext = this.getDataObjectContext(view, model);
        Map<Object, Object> permissionDetails = new HashMap();
        permissionDetails = KRADUtils.getNamespaceAndComponentSimpleName(dataObjectForContext.getClass());
        permissionDetails.put("propertyName", propertyName);
        if (field.getComponentSecurity().getAdditionalPermissionDetails() != null) {
            permissionDetails.putAll(field.getComponentSecurity().getAdditionalPermissionDetails());
        }
        HashMap<String, String> roleQualifications = new HashMap<String, String>();
        if (field.getComponentSecurity().getAdditionalRoleQualifiers() != null) {
            roleQualifications.putAll(field.getComponentSecurity().getAdditionalRoleQualifiers());
        }
        return this.isAuthorizedByTemplate(dataObjectForContext, "KR-NS", "Full Unmask Field", user.getPrincipalId(), permissionDetails, roleQualifications);
    }

    @Override
    public boolean canPartialUnmaskField(View view, ViewModel model, DataField field, String propertyName, Person user) {
        AttributeSecurity attributeSecurity = field.getDataFieldSecurity().getAttributeSecurity();
        if (attributeSecurity == null || !attributeSecurity.isPartialMask()) {
            return true;
        }
        if (this.isNonProductionEnvAndUnmaskingTurnedOff()) {
            return false;
        }
        Object dataObjectForContext = this.getDataObjectContext(view, model);
        Map<Object, Object> permissionDetails = new HashMap();
        permissionDetails = KRADUtils.getNamespaceAndComponentSimpleName(dataObjectForContext.getClass());
        permissionDetails.put("propertyName", propertyName);
        if (field.getComponentSecurity().getAdditionalPermissionDetails() != null) {
            permissionDetails.putAll(field.getComponentSecurity().getAdditionalPermissionDetails());
        }
        HashMap<String, String> roleQualifications = new HashMap<String, String>();
        if (field.getComponentSecurity().getAdditionalRoleQualifiers() != null) {
            roleQualifications.putAll(field.getComponentSecurity().getAdditionalRoleQualifiers());
        }
        return this.isAuthorizedByTemplate(dataObjectForContext, "KR-NS", "Partial Unmask Field", user.getPrincipalId(), permissionDetails, roleQualifications);
    }

    @Override
    public boolean canEditField(View view, ViewModel model, Field field, String propertyName, Person user) {
        if (!field.getComponentSecurity().isEditAuthz()) {
            return true;
        }
        return this.isAuthorizedByTemplate(view, field, model, "Edit Field", user, null, null, false);
    }

    @Override
    public boolean canViewField(View view, ViewModel model, Field field, String propertyName, Person user) {
        if (!field.getComponentSecurity().isViewAuthz()) {
            return true;
        }
        return this.isAuthorizedByTemplate(view, field, model, "View Field", user, null, null, false);
    }

    @Override
    public boolean canEditGroup(View view, ViewModel model, Group group, String groupId, Person user) {
        if (!group.getComponentSecurity().isEditAuthz()) {
            return true;
        }
        return this.isAuthorizedByTemplate(view, group, model, "Edit Group", user, null, null, false);
    }

    @Override
    public boolean canViewGroup(View view, ViewModel model, Group group, String groupId, Person user) {
        if (!group.getComponentSecurity().isViewAuthz()) {
            return true;
        }
        return this.isAuthorizedByTemplate(view, group, model, "View Group", user, null, null, false);
    }

    @Override
    public boolean canEditWidget(View view, ViewModel model, Widget widget, String widgetId, Person user) {
        if (!widget.getComponentSecurity().isViewAuthz()) {
            return true;
        }
        return this.isAuthorizedByTemplate(view, widget, model, "Edit Widget", user, null, null, false);
    }

    @Override
    public boolean canViewWidget(View view, ViewModel model, Widget widget, String widgetId, Person user) {
        if (!widget.getComponentSecurity().isViewAuthz()) {
            return true;
        }
        return this.isAuthorizedByTemplate(view, widget, model, "View Widget", user, null, null, false);
    }

    @Override
    public boolean canPerformAction(View view, ViewModel model, ActionField actionField, String actionEvent, String actionId, Person user) {
        if (!actionField.getActionFieldSecurity().isPerformActionAuthz()) {
            return true;
        }
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)actionEvent)) {
            additionalPermissionDetails.put("actionEvent", actionEvent);
        }
        return this.isAuthorizedByTemplate(view, actionField, model, "Perform Action", user, additionalPermissionDetails, null, false);
    }

    @Override
    public boolean canEditLine(View view, ViewModel model, CollectionGroup collectionGroup, String collectionPropertyName, Object line, Person user) {
        if (!collectionGroup.getCollectionGroupSecurity().isEditLineAuthz()) {
            return true;
        }
        return this.isAuthorizedByTemplate(view, collectionGroup, model, "Edit Line", user, null, null, false);
    }

    @Override
    public boolean canViewLine(View view, ViewModel model, CollectionGroup collectionGroup, String collectionPropertyName, Object line, Person user) {
        if (!collectionGroup.getCollectionGroupSecurity().isViewLineAuthz()) {
            return true;
        }
        return this.isAuthorizedByTemplate(view, collectionGroup, model, "View Line", user, null, null, false);
    }

    @Override
    public boolean canEditLineField(View view, ViewModel model, CollectionGroup collectionGroup, String collectionPropertyName, Object line, Field field, String propertyName, Person user) {
        if (!field.getFieldSecurity().isEditInLineAuthz()) {
            return true;
        }
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("groupId", collectionGroup.getId());
        additionalPermissionDetails.put("collectionPropertyName", collectionGroup.getPropertyName());
        return this.isAuthorizedByTemplate(view, field, model, "Edit Line Field", user, additionalPermissionDetails, null, false);
    }

    @Override
    public boolean canViewLineField(View view, ViewModel model, CollectionGroup collectionGroup, String collectionPropertyName, Object line, Field field, String propertyName, Person user) {
        if (!field.getFieldSecurity().isViewInLineAuthz()) {
            return true;
        }
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("groupId", collectionGroup.getId());
        additionalPermissionDetails.put("collectionPropertyName", collectionGroup.getPropertyName());
        return this.isAuthorizedByTemplate(view, field, model, "View Line Field", user, additionalPermissionDetails, null, false);
    }

    @Override
    public boolean canPerformLineAction(View view, ViewModel model, CollectionGroup collectionGroup, String collectionPropertyName, Object line, ActionField actionField, String actionEvent, String actionId, Person user) {
        if (!actionField.getActionFieldSecurity().isPerformLineActionAuthz()) {
            return true;
        }
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("groupId", collectionGroup.getId());
        additionalPermissionDetails.put("collectionPropertyName", collectionGroup.getPropertyName());
        if (StringUtils.isNotBlank((String)actionEvent)) {
            additionalPermissionDetails.put("actionEvent", actionEvent);
        }
        return this.isAuthorizedByTemplate(view, actionField, model, "Perform Line Action", user, additionalPermissionDetails, null, false);
    }

    protected Object getDataObjectContext(View view, ViewModel model) {
        Object defaultObject;
        ViewModel dataObject = model;
        if (StringUtils.isNotBlank((String)view.getDefaultBindingObjectPath()) && (defaultObject = ObjectPropertyUtils.getPropertyValue(model, view.getDefaultBindingObjectPath())) != null) {
            dataObject = defaultObject;
        }
        return dataObject;
    }

    protected Map<String, String> getFieldPermissionDetails(View view, Object dataObject, Field field) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("namespaceCode", view.getViewNamespaceCode());
        permissionDetails.put("viewId", view.getId());
        permissionDetails.put("fieldId", field.getId());
        if (field instanceof DataBinding) {
            permissionDetails.put("propertyName", ((DataBinding)((Object)field)).getPropertyName());
        }
        return permissionDetails;
    }

    protected Map<String, String> getGroupPermissionDetails(View view, Object dataObject, Group group) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("namespaceCode", view.getViewNamespaceCode());
        permissionDetails.put("viewId", view.getId());
        permissionDetails.put("groupId", group.getId());
        if (group instanceof CollectionGroup) {
            permissionDetails.put("collectionPropertyName", ((CollectionGroup)group).getPropertyName());
        }
        return permissionDetails;
    }

    protected Map<String, String> getWidgetPermissionDetails(View view, Object dataObject, Widget widget) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("namespaceCode", view.getViewNamespaceCode());
        permissionDetails.put("viewId", view.getId());
        permissionDetails.put("widgetId", widget.getId());
        return permissionDetails;
    }

    protected boolean isAuthorizedByTemplate(View view, Component component, ViewModel model, String permissionTemplateName, Person user, Map<String, String> additionalPermissionDetails, Map<String, String> additionalRoleQualifications, boolean checkPermissionExistence) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        HashMap<String, String> roleQualifications = new HashMap<String, String>();
        if (additionalPermissionDetails != null) {
            permissionDetails.putAll(additionalPermissionDetails);
        }
        if (additionalRoleQualifications != null) {
            roleQualifications.putAll(additionalRoleQualifications);
        }
        Object dataObjectForContext = this.getDataObjectContext(view, model);
        if (component instanceof Field) {
            permissionDetails.putAll(this.getFieldPermissionDetails(view, dataObjectForContext, (Field)component));
        } else if (component instanceof Group) {
            permissionDetails.putAll(this.getGroupPermissionDetails(view, dataObjectForContext, (Group)component));
        } else if (component instanceof Widget) {
            permissionDetails.putAll(this.getWidgetPermissionDetails(view, dataObjectForContext, (Widget)component));
        }
        ComponentSecurity componentSecurity = component.getComponentSecurity();
        if (StringUtils.isNotBlank((String)componentSecurity.getNamespaceAttribute())) {
            permissionDetails.put("namespaceCode", componentSecurity.getNamespaceAttribute());
        }
        if (StringUtils.isNotBlank((String)componentSecurity.getComponentAttribute())) {
            permissionDetails.put("componentName", componentSecurity.getComponentAttribute());
        }
        if (StringUtils.isNotBlank((String)componentSecurity.getIdAttribute())) {
            if (component instanceof Field) {
                permissionDetails.put("fieldId", componentSecurity.getIdAttribute());
            } else if (component instanceof Group) {
                permissionDetails.put("groupId", componentSecurity.getIdAttribute());
            } else if (component instanceof Widget) {
                permissionDetails.put("widgetId", componentSecurity.getIdAttribute());
            }
        }
        if (componentSecurity.getAdditionalPermissionDetails() != null) {
            permissionDetails.putAll(componentSecurity.getAdditionalPermissionDetails());
        }
        if (componentSecurity.getAdditionalRoleQualifiers() != null) {
            roleQualifications.putAll(componentSecurity.getAdditionalRoleQualifiers());
        }
        boolean result = true;
        if (!checkPermissionExistence || checkPermissionExistence && this.permissionExistsByTemplate(dataObjectForContext, "KR-KRAD", permissionTemplateName, permissionDetails)) {
            result = this.isAuthorizedByTemplate(dataObjectForContext, "KR-KRAD", permissionTemplateName, user.getPrincipalId(), permissionDetails, roleQualifications);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Performed permission check for: " + permissionTemplateName + " and got result: " + result));
            }
        }
        return result;
    }

    private boolean isNonProductionEnvAndUnmaskingTurnedOff() {
        return !this.getConfigurationService().getPropertyValueAsString("production.environment.code").equalsIgnoreCase(this.getConfigurationService().getPropertyValueAsString("environment")) && !this.getConfigurationService().getPropertyValueAsBoolean("enable.nonproduction.data.unmasking");
    }

    protected ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            return KRADServiceLocator.getKualiConfigurationService();
        }
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

