/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.view;

import java.beans.PropertyEditor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ViewCleaner;
import org.kuali.rice.krad.uif.view.View;

public class ViewIndex
implements Serializable {
    private static final long serialVersionUID = 4700818801272201371L;
    private Map<String, Component> index = new HashMap<String, Component>();
    private Map<String, DataField> dataFieldIndex = new HashMap<String, DataField>();
    private Map<String, CollectionGroup> collectionsIndex = new HashMap<String, CollectionGroup>();
    private Map<String, Component> initialComponentStates = new HashMap<String, Component>();
    private Map<String, PropertyEditor> fieldPropertyEditors = new HashMap<String, PropertyEditor>();
    private Map<String, PropertyEditor> secureFieldPropertyEditors = new HashMap<String, PropertyEditor>();
    private Map<String, Integer> idSequenceSnapshot = new HashMap<String, Integer>();

    protected void index(View view) {
        this.index = new HashMap<String, Component>();
        this.dataFieldIndex = new HashMap<String, DataField>();
        this.collectionsIndex = new HashMap<String, CollectionGroup>();
        this.fieldPropertyEditors = new HashMap<String, PropertyEditor>();
        this.secureFieldPropertyEditors = new HashMap<String, PropertyEditor>();
        this.indexComponent(view);
    }

    public void indexComponent(Component component) {
        if (component == null) {
            return;
        }
        this.index.put(component.getId(), component);
        if (component instanceof DataField) {
            DataField field = (DataField)component;
            this.dataFieldIndex.put(field.getBindingInfo().getBindingPath(), field);
            if (component.isRender()) {
                if (field.hasSecureValue()) {
                    this.secureFieldPropertyEditors.put(field.getBindingInfo().getBindingPath(), field.getPropertyEditor());
                } else {
                    this.fieldPropertyEditors.put(field.getBindingInfo().getBindingPath(), field.getPropertyEditor());
                }
            }
        } else if (component instanceof CollectionGroup) {
            CollectionGroup collectionGroup = (CollectionGroup)component;
            this.collectionsIndex.put(collectionGroup.getBindingInfo().getBindingPath(), collectionGroup);
        }
        for (Component nestedComponent : component.getComponentsForLifecycle()) {
            this.indexComponent(nestedComponent);
        }
    }

    public void clearIndexesAfterRender() {
        HashSet<String> holdIds = new HashSet<String>();
        HashSet<String> holdFactoryIds = new HashSet<String>();
        for (Component component : this.index.values()) {
            InputField inputField;
            if (component == null) continue;
            if (StringUtils.isNotBlank((String)component.getProgressiveRender()) || StringUtils.isNotBlank((String)component.getConditionalRefresh()) || StringUtils.isNotBlank((String)component.getRefreshWhenChanged()) || component.isRefreshedByAction()) {
                holdFactoryIds.add(component.getFactoryId());
                holdIds.add(component.getId());
                continue;
            }
            if (component.isPersistInSession()) {
                holdFactoryIds.add(component.getFactoryId());
                holdIds.add(component.getId());
                continue;
            }
            if (component instanceof CollectionGroup) {
                ViewCleaner.cleanCollectionGroup((CollectionGroup)component);
                holdFactoryIds.add(component.getFactoryId());
                holdIds.add(component.getId());
                continue;
            }
            if (!(component instanceof InputField) || (inputField = (InputField)component).getFieldAttributeQuery() == null && !inputField.getFieldSuggest().isRender()) continue;
            holdIds.add(component.getId());
        }
        HashMap<String, Component> holdInitialComponentStates = new HashMap<String, Component>();
        for (String factoryId : this.initialComponentStates.keySet()) {
            if (!holdFactoryIds.contains(factoryId)) continue;
            holdInitialComponentStates.put(factoryId, this.initialComponentStates.get(factoryId));
        }
        this.initialComponentStates = holdInitialComponentStates;
        HashMap<String, Component> holdComponentStates = new HashMap<String, Component>();
        for (String id : this.index.keySet()) {
            if (!holdIds.contains(id)) continue;
            holdComponentStates.put(id, this.index.get(id));
        }
        this.index = holdComponentStates;
        this.dataFieldIndex = new HashMap<String, DataField>();
    }

    public Component getComponentById(String id) {
        return this.index.get(id);
    }

    public DataField getDataFieldByPath(String propertyPath) {
        return this.dataFieldIndex.get(propertyPath);
    }

    public DataField getDataFieldByPropertyName(String propertyName) {
        DataField dataField = null;
        for (DataField field : this.dataFieldIndex.values()) {
            if (!StringUtils.equals((String)propertyName, (String)field.getPropertyName())) continue;
            dataField = field;
            break;
        }
        return dataField;
    }

    public Map<String, DataField> getDataFieldIndex() {
        return this.dataFieldIndex;
    }

    public Map<String, CollectionGroup> getCollectionsIndex() {
        return this.collectionsIndex;
    }

    public CollectionGroup getCollectionGroupByPath(String collectionPath) {
        return this.collectionsIndex.get(collectionPath);
    }

    public Map<String, Component> getInitialComponentStates() {
        return this.initialComponentStates;
    }

    public void addInitialComponentStateIfNeeded(Component component) {
        if (StringUtils.isBlank((String)component.getFactoryId())) {
            component.setFactoryId(component.getId());
            this.initialComponentStates.put(component.getFactoryId(), ComponentUtils.copy(component));
        }
    }

    public void setInitialComponentStates(Map<String, Component> initialComponentStates) {
        this.initialComponentStates = initialComponentStates;
    }

    public Map<String, PropertyEditor> getFieldPropertyEditors() {
        return this.fieldPropertyEditors;
    }

    public void setFieldPropertyEditors(Map<String, PropertyEditor> fieldPropertyEditors) {
        this.fieldPropertyEditors = fieldPropertyEditors;
    }

    public Map<String, PropertyEditor> getSecureFieldPropertyEditors() {
        return this.secureFieldPropertyEditors;
    }

    public void setSecureFieldPropertyEditors(Map<String, PropertyEditor> secureFieldPropertyEditors) {
        this.secureFieldPropertyEditors = secureFieldPropertyEditors;
    }

    public Map<String, Integer> getIdSequenceSnapshot() {
        return this.idSequenceSnapshot;
    }

    public void setIdSequenceSnapshot(Map<String, Integer> idSequenceSnapshot) {
        this.idSequenceSnapshot = idSequenceSnapshot;
    }

    public void addSequenceValueToSnapshot(String componentId, int sequenceVal) {
        this.idSequenceSnapshot.put(componentId, sequenceVal);
    }
}

