/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.widget;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Set;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.core.api.util.type.KualiPercent;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.control.CheckboxControl;
import org.kuali.rice.krad.uif.control.CheckboxGroupControl;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.RadioGroupControl;
import org.kuali.rice.krad.uif.control.SelectControl;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.layout.TableLayoutManager;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.WidgetBase;
import org.kuali.rice.krad.web.form.UifFormBase;

public class RichTable
extends WidgetBase {
    private static final long serialVersionUID = 4671589690877390070L;
    private String emptyTableMessage;
    private boolean disableTableSort;
    private Set<String> hiddenColumns;
    private Set<String> sortableColumns;
    private boolean showSearchAndExportOptions = true;

    @Override
    public void performFinalize(View view, Object model, Component component) {
        super.performFinalize(view, model, component);
        UifFormBase formBase = (UifFormBase)model;
        if (this.isRender()) {
            String sDomOption;
            String domOption;
            if (StringUtils.isNotBlank((String)this.getEmptyTableMessage())) {
                this.getComponentOptions().put("oLanguage", "{\"sEmptyTable\" : \"" + this.getEmptyTableMessage() + "\"}");
            }
            if (!this.isShowSearchAndExportOptions() && (domOption = this.getComponentOptions().get("sDom")) instanceof String && StringUtils.isNotBlank((String)(sDomOption = domOption))) {
                sDomOption = StringUtils.remove((String)sDomOption, (String)"T");
                sDomOption = StringUtils.remove((String)sDomOption, (String)"f");
                this.getComponentOptions().put("sDom", sDomOption);
            }
            if ("addLine".equals(formBase.getActionEvent())) {
                this.getComponentOptions().put("aaSorting", "[]");
            }
            if (component instanceof CollectionGroup) {
                this.buildTableOptions((CollectionGroup)component);
            }
            if (this.isDisableTableSort()) {
                this.getComponentOptions().put("bSort", "false");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void buildTableOptions(CollectionGroup collectionGroup) {
        LayoutManager layoutManager = collectionGroup.getLayoutManager();
        if (!collectionGroup.getSubCollections().isEmpty()) {
            this.setDisableTableSort(true);
        }
        if (!this.isDisableTableSort()) {
            String colOptions;
            if (!(!collectionGroup.isRenderAddLine() || collectionGroup.isReadOnly() || layoutManager instanceof TableLayoutManager && ((TableLayoutManager)layoutManager).isSeparateAddLine())) {
                this.getComponentOptions().put("aiSortingSkipRows", "[0]");
            }
            StringBuffer tableToolsColumnOptions = new StringBuffer("[");
            if (layoutManager instanceof TableLayoutManager && ((TableLayoutManager)layoutManager).isRenderSequenceField()) {
                tableToolsColumnOptions.append(" null ,");
            }
            if (collectionGroup.isRenderSelectField()) {
                colOptions = this.constructTableColumnOptions(false, null, null);
                tableToolsColumnOptions.append(colOptions + " , ");
            }
            if (!StringUtils.isEmpty((String)this.getComponentOptions().get("aoColumns"))) {
                String jsArray = this.getComponentOptions().get("aoColumns");
                int startBrace = StringUtils.indexOf((String)jsArray, (String)"[");
                int endBrace = StringUtils.lastIndexOf((String)jsArray, (String)"]");
                tableToolsColumnOptions.append(StringUtils.substring((String)jsArray, (int)(startBrace + 1), (int)endBrace) + " , ");
            } else {
                Set<String> currentSortableColumns = this.getSortableColumns();
                Set<String> currentHiddenColumns = this.getHiddenColumns();
                if (layoutManager instanceof TableLayoutManager) {
                    TableLayoutManager tableLayoutMgr = (TableLayoutManager)layoutManager;
                    if (tableLayoutMgr.getSortableColumns() != null && !tableLayoutMgr.getSortableColumns().isEmpty()) {
                        currentSortableColumns = tableLayoutMgr.getSortableColumns();
                    }
                    if (tableLayoutMgr.getHiddenColumns() != null && !tableLayoutMgr.getHiddenColumns().isEmpty()) {
                        currentHiddenColumns = tableLayoutMgr.getHiddenColumns();
                    }
                }
                for (Component component : collectionGroup.getItems()) {
                    void var7_9;
                    if (component instanceof FieldGroup) {
                        Component component2 = ((FieldGroup)component).getItems().get(0);
                    }
                    if (var7_9 instanceof DataField) {
                        DataField field = (DataField)var7_9;
                        if (currentHiddenColumns != null && currentHiddenColumns.contains(field.getPropertyName())) {
                            tableToolsColumnOptions.append("{bVisible: false}, ");
                            continue;
                        }
                        if (currentSortableColumns != null && !currentSortableColumns.isEmpty()) {
                            if (currentSortableColumns.contains(field.getPropertyName())) {
                                tableToolsColumnOptions.append(this.getDataFieldColumnOptions(collectionGroup, field) + ", ");
                                continue;
                            }
                            tableToolsColumnOptions.append("{'bSortable': false}, ");
                            continue;
                        }
                        String colOptions2 = this.getDataFieldColumnOptions(collectionGroup, field);
                        tableToolsColumnOptions.append(colOptions2 + " , ");
                        continue;
                    }
                    String colOptions3 = this.constructTableColumnOptions(false, null, null);
                    tableToolsColumnOptions.append(colOptions3 + " , ");
                }
            }
            if (collectionGroup.isRenderLineActions() && !collectionGroup.isReadOnly()) {
                colOptions = this.constructTableColumnOptions(false, null, null);
                tableToolsColumnOptions.append(colOptions);
            } else {
                tableToolsColumnOptions = new StringBuffer(StringUtils.removeEnd((String)tableToolsColumnOptions.toString(), (String)", "));
            }
            tableToolsColumnOptions.append("]");
            this.getComponentOptions().put("aoColumns", tableToolsColumnOptions.toString());
        }
    }

    private String getDataFieldColumnOptions(CollectionGroup collectionGroup, DataField field) {
        Control control;
        String sortType = null;
        sortType = !collectionGroup.isReadOnly() && field instanceof InputField && ((InputField)field).getControl() != null ? ((control = ((InputField)field).getControl()) instanceof SelectControl ? "dom-select" : (control instanceof CheckboxControl || control instanceof CheckboxGroupControl ? "dom-checkbox" : (control instanceof RadioGroupControl ? "dom-radio" : "dom-text"))) : "dom-text";
        Class<?> dataTypeClass = ObjectPropertyUtils.getPropertyType(collectionGroup.getCollectionObjectClass(), field.getPropertyName());
        return this.constructTableColumnOptions(true, dataTypeClass, sortType);
    }

    protected String constructTableColumnOptions(boolean isSortable, Class dataTypeClass, String sortDataType) {
        String colOptions = "null";
        String sortType = "";
        if (!isSortable || dataTypeClass == null || sortType == null) {
            colOptions = "\"bSortable\" : false, \"sType\" : \"string\"";
        } else {
            sortType = ClassUtils.isAssignable((Class)dataTypeClass, KualiPercent.class) ? "kuali_percent" : (ClassUtils.isAssignable((Class)dataTypeClass, KualiInteger.class) || ClassUtils.isAssignable((Class)dataTypeClass, KualiDecimal.class) ? "kuali_currency" : (ClassUtils.isAssignable((Class)dataTypeClass, Timestamp.class) ? "date" : (ClassUtils.isAssignable((Class)dataTypeClass, Date.class) || ClassUtils.isAssignable((Class)dataTypeClass, java.util.Date.class) ? "kuali_date" : (ClassUtils.isAssignable((Class)dataTypeClass, Number.class) ? "numeric" : "string"))));
            colOptions = "\"sSortDataType\" : \"" + sortDataType + "\"";
            colOptions = colOptions + " , \"sType\" : \"" + sortType + "\"";
        }
        colOptions = "{" + colOptions + "}";
        return colOptions;
    }

    public String getEmptyTableMessage() {
        return this.emptyTableMessage;
    }

    public void setEmptyTableMessage(String emptyTableMessage) {
        this.emptyTableMessage = emptyTableMessage;
    }

    public boolean isDisableTableSort() {
        return this.disableTableSort;
    }

    public void setDisableTableSort(boolean disableTableSort) {
        this.disableTableSort = disableTableSort;
    }

    public boolean isShowSearchAndExportOptions() {
        return this.showSearchAndExportOptions;
    }

    public void setShowSearchAndExportOptions(boolean showSearchAndExportOptions) {
        this.showSearchAndExportOptions = showSearchAndExportOptions;
    }

    public Set<String> getHiddenColumns() {
        return this.hiddenColumns;
    }

    public void setHiddenColumns(Set<String> hiddenColumns) {
        this.hiddenColumns = hiddenColumns;
    }

    public Set<String> getSortableColumns() {
        return this.sortableColumns;
    }

    public void setSortableColumns(Set<String> sortableColumns) {
        this.sortableColumns = sortableColumns;
    }
}

