/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MessageUtils {
    public static String interpolate(String message, String ... data) {
        if (message != null) {
            for (int i = 0; i < data.length; ++i) {
                message = message.replaceAll("\\$\\{" + i + "\\}", "" + MessageUtils.escape(data[i]));
            }
        }
        return message;
    }

    public static String interpolate(String message, Map<String, Object> data) {
        if (message != null && data != null) {
            Set<String> fields = MessageUtils.findFields(message);
            for (String s : fields) {
                if (data.get(s) == null) continue;
                message = message.replaceAll("\\$\\{" + s + "\\}", "" + MessageUtils.escape(data.get(s).toString()));
            }
        }
        return message;
    }

    public static String interpolate(String message, String parameter, Object value) {
        message = message.replaceAll("\\$\\{" + parameter + "\\}", "" + MessageUtils.escape(value.toString()));
        return message;
    }

    private static String escape(String input) {
        char[] toEscape;
        for (char c : toEscape = new char[]{'\\', '$', '.', '*', '+', '?', '|', '(', ')', '[', ']', '{', '}'}) {
            input = input.replaceAll("\\" + c, "\\\\\\" + c);
        }
        return input;
    }

    public static Set<String> findFields(String input) {
        HashSet<String> result = new HashSet<String>();
        int begin = input.indexOf("${");
        while (begin != -1) {
            int end = input.indexOf("}", begin);
            result.add(input.substring(begin + 2, end));
            begin = input.indexOf("${", end);
        }
        return result;
    }
}

