/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.validation.Address;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.DictionaryObjectAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.constraint.AlphaNumericPatternConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.ValidCharactersConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;

public class AlphaNumericPatternConstraintTest {
    private AttributeDefinition street1Definition;
    private AttributeDefinition street2Definition;
    private AttributeDefinition postalCodeDefinition;
    private BusinessObjectEntry addressEntry;
    private DictionaryValidationResult dictionaryValidationResult;
    private ValidCharactersConstraintProcessor processor;
    private Address washingtonDCAddress = new Address("893 Presidential Ave", "(A_123) Suite 800.", "Washington", "DC", "NHW123A", "USA", null);
    private Address newYorkNYAddress = new Address("Presidential Street", "(A-123) Suite 800", "New York", "NY", "ZH 3456", "USA", null);
    private Address sydneyAUSAddress = new Address("Presidential Street-Ave.", "Suite_800.", "Sydney", "ZZ", "ZH-5656", "USA", null);
    private AlphaNumericPatternConstraint street1AlphaNumericPatternConstraint;
    private AlphaNumericPatternConstraint street2AlphaNumericPatternConstraint;
    private AlphaNumericPatternConstraint postalCodeAlphaNumericPatternConstraint;

    @Before
    public void setUp() throws Exception {
        this.processor = new ValidCharactersConstraintProcessor();
        this.dictionaryValidationResult = new DictionaryValidationResult();
        this.dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        this.addressEntry = new BusinessObjectEntry();
        ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
        this.street1AlphaNumericPatternConstraint = new AlphaNumericPatternConstraint();
        this.street1AlphaNumericPatternConstraint.setAllowWhitespace(true);
        this.street1Definition = new AttributeDefinition();
        this.street1Definition.setName("street1");
        this.street1Definition.setValidCharactersConstraint((ValidCharactersConstraint)this.street1AlphaNumericPatternConstraint);
        attributes.add(this.street1Definition);
        this.street2AlphaNumericPatternConstraint = new AlphaNumericPatternConstraint();
        this.street2AlphaNumericPatternConstraint.setAllowWhitespace(true);
        this.street2AlphaNumericPatternConstraint.setAllowParenthesis(true);
        this.street2AlphaNumericPatternConstraint.setAllowPeriod(true);
        this.street2AlphaNumericPatternConstraint.setAllowUnderscore(true);
        this.street2Definition = new AttributeDefinition();
        this.street2Definition.setName("street2");
        this.street2Definition.setValidCharactersConstraint((ValidCharactersConstraint)this.street2AlphaNumericPatternConstraint);
        attributes.add(this.street2Definition);
        this.postalCodeAlphaNumericPatternConstraint = new AlphaNumericPatternConstraint();
        this.postalCodeDefinition = new AttributeDefinition();
        this.postalCodeDefinition.setName("postalCode");
        this.postalCodeDefinition.setValidCharactersConstraint((ValidCharactersConstraint)this.postalCodeAlphaNumericPatternConstraint);
        attributes.add(this.postalCodeDefinition);
        this.addressEntry.setAttributes(attributes);
    }

    @Test
    public void testValueAllValidChars() {
        ConstraintValidationResult result = this.process(this.washingtonDCAddress, "postalCode", (ValidCharactersConstraint)this.postalCodeAlphaNumericPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Ignore
    @Test
    public void testValueNotValidChars() {
        ConstraintValidationResult result = this.process(this.newYorkNYAddress, "postalCode", (ValidCharactersConstraint)this.postalCodeAlphaNumericPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueAllValidCharsAllowWhitespace() {
        ConstraintValidationResult result = this.process(this.newYorkNYAddress, "street1", (ValidCharactersConstraint)this.street1AlphaNumericPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Ignore
    @Test
    public void testValueNotValidCharsAllowWhitespace() {
        ConstraintValidationResult result = this.process(this.sydneyAUSAddress, "street1", (ValidCharactersConstraint)this.street1AlphaNumericPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueAllValidCharsAllowWhitespaceAndPeriodAndUnderscoreAndParenthesis() {
        ConstraintValidationResult result = this.process(this.washingtonDCAddress, "street2", (ValidCharactersConstraint)this.street2AlphaNumericPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Ignore
    @Test
    public void testValueNotValidCharsAllowWhitespaceAndPeriodAndUnderscoreAndParenthesis() {
        ConstraintValidationResult result = this.process(this.newYorkNYAddress, "street2", (ValidCharactersConstraint)this.street2AlphaNumericPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    private ConstraintValidationResult process(Object object, String attributeName, ValidCharactersConstraint constraint) {
        DictionaryObjectAttributeValueReader attributeValueReader = new DictionaryObjectAttributeValueReader(object, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry);
        attributeValueReader.setAttributeName(attributeName);
        Object value = attributeValueReader.getValue();
        return this.processor.process(this.dictionaryValidationResult, value, constraint, (AttributeValueReader)attributeValueReader).getFirstConstraintValidationResult();
    }
}

