/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import java.util.ArrayList;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.framework.config.property.SimpleConfig;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.SingleAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.constraint.DatePatternConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.ValidCharactersConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;

public class DatePatternConstraintTest {
    private AttributeDefinition dateDefinition;
    private DictionaryValidationResult dictionaryValidationResult;
    private ValidCharactersConstraintProcessor processor;
    private String validDate;
    private String validDate1;
    private String invalidDateEmpty;
    private String invalidDate;
    private String invalidDate1;
    private String invalidDate2;
    private String invalidDate3;
    private DatePatternConstraint datePatternConstraint;

    @Before
    public void setUp() throws Exception {
        String formats = "MM/dd/yy;MM/dd/yyyy;MM-dd-yy;MM-dd-yyyy";
        Properties props = new Properties();
        props.put("STRING_TO_DATE_FORMATS", formats);
        SimpleConfig config = new SimpleConfig(props);
        ConfigContext.init((Config)config);
        ConfigContext.getCurrentContextConfig().putProperty("STRING_TO_DATE_FORMATS", formats);
        this.processor = new ValidCharactersConstraintProcessor();
        this.dictionaryValidationResult = new DictionaryValidationResult();
        this.dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        this.validDate = "07-28-2011";
        this.validDate1 = "12-31-83";
        this.invalidDateEmpty = "";
        this.invalidDate = "31-12-2010";
        this.invalidDate1 = "31-12-2010 12:30:45.456";
        this.invalidDate2 = "2011-07-28 IST";
        this.invalidDate3 = "12/31/2011";
        ArrayList<String> allowedFormats = new ArrayList<String>();
        allowedFormats.add("MM-dd-yy");
        allowedFormats.add("MM-dd-yyyy");
        this.datePatternConstraint = new DatePatternConstraint();
        this.datePatternConstraint.setAllowedFormats(allowedFormats);
        this.dateDefinition = new AttributeDefinition();
        this.dateDefinition.setName("date");
        this.dateDefinition.setValidCharactersConstraint((ValidCharactersConstraint)this.datePatternConstraint);
    }

    @Test
    public void testValueInvalidDateEmpty() {
        ConstraintValidationResult result = this.process(this.invalidDateEmpty, "date", (ValidCharactersConstraint)this.datePatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.INAPPLICABLE, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidDate() {
        ConstraintValidationResult result = this.process(this.validDate, "date", (ValidCharactersConstraint)this.datePatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidDate1() {
        ConstraintValidationResult result = this.process(this.validDate1, "Mdate", (ValidCharactersConstraint)this.datePatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidDate() {
        ConstraintValidationResult result = this.process(this.invalidDate, "date", (ValidCharactersConstraint)this.datePatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidDate1() {
        ConstraintValidationResult result = this.process(this.invalidDate1, "date", (ValidCharactersConstraint)this.datePatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidDate2() {
        ConstraintValidationResult result = this.process(this.invalidDate2, "date", (ValidCharactersConstraint)this.datePatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidDate3() {
        ConstraintValidationResult result = this.process(this.invalidDate3, "date", (ValidCharactersConstraint)this.datePatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    private ConstraintValidationResult process(Object object, String attributeName, ValidCharactersConstraint constraint) {
        SingleAttributeValueReader attributeValueReader = new SingleAttributeValueReader(object, "org.kuali.rice.kns.datadictionary.validation.MockAddress", attributeName, this.dateDefinition);
        Object value = attributeValueReader.getValue();
        return this.processor.process(this.dictionaryValidationResult, value, constraint, (AttributeValueReader)attributeValueReader).getFirstConstraintValidationResult();
    }
}

