/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.validation.Account;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.DictionaryObjectAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.constraint.FloatingPointPatternConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.ValidCharactersConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;

public class FloatingPointPatternConstraintTest {
    private final String PATTERN_CONSTRAINT = "validationPatternRegex.floatingPoint";
    private AttributeDefinition totalBalanceDefinition;
    private AttributeDefinition debitBalanceDefinition;
    private BusinessObjectEntry addressEntry;
    private DictionaryValidationResult dictionaryValidationResult;
    private ValidCharactersConstraintProcessor processor;
    private Account iciciAccount = new Account("11111111", "ICICI", "5000.00", "15000", "-10000");
    private Account citibankAccount = new Account("22222222", "Citi Bank", "15000.70", "14999.70", "1.");
    private Account wellsFargoAccount = new Account("33333333", "Wells Fargo", "", ".25", "-.25");
    private Account morganAccount = new Account("44444444", "J P Morgan", "-1000.00", "1000.00", "(2000.00)");
    private FloatingPointPatternConstraint totalBalanceFloatingPointPatternConstraint;
    private FloatingPointPatternConstraint debitBalanceFloatingPointPatternConstraint;

    @Before
    public void setUp() throws Exception {
        String regex = this.getProperty("validationPatternRegex.floatingPoint");
        this.processor = new ValidCharactersConstraintProcessor();
        this.dictionaryValidationResult = new DictionaryValidationResult();
        this.dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        this.addressEntry = new BusinessObjectEntry();
        ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
        this.totalBalanceFloatingPointPatternConstraint = new FloatingPointPatternConstraint();
        this.totalBalanceFloatingPointPatternConstraint.setValue(regex);
        this.totalBalanceDefinition = new AttributeDefinition();
        this.totalBalanceDefinition.setName("totalBalance");
        this.totalBalanceDefinition.setValidCharactersConstraint((ValidCharactersConstraint)this.totalBalanceFloatingPointPatternConstraint);
        attributes.add(this.totalBalanceDefinition);
        this.debitBalanceFloatingPointPatternConstraint = new FloatingPointPatternConstraint();
        this.debitBalanceFloatingPointPatternConstraint.setValue("-?" + regex);
        this.debitBalanceFloatingPointPatternConstraint.setAllowNegative(true);
        this.debitBalanceDefinition = new AttributeDefinition();
        this.debitBalanceDefinition.setName("debitBalance");
        this.debitBalanceDefinition.setValidCharactersConstraint((ValidCharactersConstraint)this.debitBalanceFloatingPointPatternConstraint);
        attributes.add(this.debitBalanceDefinition);
        this.addressEntry.setAttributes(attributes);
    }

    @Test
    public void testValueEmpty() {
        ConstraintValidationResult result = this.process(this.wellsFargoAccount, "totalBalance", (ValidCharactersConstraint)this.totalBalanceFloatingPointPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.INAPPLICABLE, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidPositiveNumber() {
        ConstraintValidationResult result = this.process(this.citibankAccount, "totalBalance", (ValidCharactersConstraint)this.totalBalanceFloatingPointPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Ignore
    @Test
    public void testValueInvalidNegativeNumber() {
        ConstraintValidationResult result = this.process(this.morganAccount, "totalBalance", (ValidCharactersConstraint)this.totalBalanceFloatingPointPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidNegativeNumber() {
        ConstraintValidationResult result = this.process(this.iciciAccount, "debitBalance", (ValidCharactersConstraint)this.debitBalanceFloatingPointPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Ignore
    @Test
    public void testValueInvalidNegativeNumber1() {
        ConstraintValidationResult result = this.process(this.morganAccount, "debitBalance", (ValidCharactersConstraint)this.debitBalanceFloatingPointPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Ignore
    @Test
    public void testValueInvalidPositiveNumber() {
        ConstraintValidationResult result = this.process(this.citibankAccount, "debitBalance", (ValidCharactersConstraint)this.debitBalanceFloatingPointPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidNegativeNumber1() {
        ConstraintValidationResult result = this.process(this.wellsFargoAccount, "debitBalance", (ValidCharactersConstraint)this.debitBalanceFloatingPointPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    private ConstraintValidationResult process(Object object, String attributeName, ValidCharactersConstraint constraint) {
        DictionaryObjectAttributeValueReader attributeValueReader = new DictionaryObjectAttributeValueReader(object, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry);
        attributeValueReader.setAttributeName(attributeName);
        Object value = attributeValueReader.getValue();
        return this.processor.process(this.dictionaryValidationResult, value, constraint, (AttributeValueReader)attributeValueReader).getFirstConstraintValidationResult();
    }

    private String getProperty(String key) {
        String value = null;
        String filePath = "org/kuali/rice/krad/ApplicationResources.properties";
        Properties properties = new Properties();
        try {
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
            properties.load(in);
            value = properties.getProperty(key);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return value;
    }
}

