/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.processor;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.uif.DataType;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.validation.Address;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.SingleAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.constraint.ExistenceConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.ExistenceConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;

public class ExistenceConstraintProcessorTest {
    private AttributeDefinition cityRequiredDefinition;
    private AttributeDefinition countryNotRequiredDefinition;
    private AttributeDefinition countryNoConstraintDefinition;
    private ExistenceConstraintProcessor processor;
    private Address noPostalCodeOrCityAddress = new Address("893 Presidential Ave", "Suite 800", "", "", "12340", "USA", null);
    private Address noPostalCodeAddress = new Address("893 Presidential Ave", "Suite 800", "Washington", "", "12340", "USA", null);
    private Address noPostalCodeOrCountryAddress = new Address("893 Presidential Ave", "Suite 800", "Washington", "", "12340", "", null);

    @Before
    public void setUp() throws Exception {
        this.cityRequiredDefinition = new AttributeDefinition(){

            public DataType getDataType() {
                return null;
            }

            public String getLabel() {
                return "City";
            }

            public String getName() {
                return "city";
            }

            public Boolean isRequired() {
                return Boolean.TRUE;
            }
        };
        this.countryNotRequiredDefinition = new AttributeDefinition(){

            public DataType getDataType() {
                return DataType.STRING;
            }

            public String getLabel() {
                return "Country";
            }

            public String getName() {
                return "country";
            }

            public Boolean isRequired() {
                return Boolean.FALSE;
            }
        };
        this.countryNoConstraintDefinition = new AttributeDefinition(){

            public DataType getDataType() {
                return DataType.STRING;
            }

            public String getLabel() {
                return "Country";
            }

            public String getName() {
                return "country";
            }

            public Boolean isRequired() {
                return null;
            }
        };
        this.processor = new ExistenceConstraintProcessor();
    }

    @Test
    public void testPresenceOfRequiredSingleAttributeSuccess() {
        SingleAttributeValueReader attributeValueReader = new SingleAttributeValueReader((Object)this.noPostalCodeAddress.getCity(), "org.kuali.rice.kns.datadictionary.validation.MockAddress", "city", this.cityRequiredDefinition);
        Object value = attributeValueReader.getValue();
        DictionaryValidationResult dictionaryValidationResult = new DictionaryValidationResult();
        dictionaryValidationResult.setErrorLevel(ErrorLevel.OK);
        ConstraintValidationResult constraintValidationResult = this.processor.process(dictionaryValidationResult, value, (ExistenceConstraint)this.cityRequiredDefinition, (AttributeValueReader)attributeValueReader).getFirstConstraintValidationResult();
        Assert.assertEquals((Object)new ExistenceConstraintProcessor().getName(), (Object)constraintValidationResult.getConstraintName());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)constraintValidationResult.getStatus());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
    }

    @Test
    public void testAbsenceOfRequiredSingleAttributeFailure() {
        SingleAttributeValueReader attributeValueReader = new SingleAttributeValueReader((Object)this.noPostalCodeOrCityAddress.getCity(), "org.kuali.rice.kns.datadictionary.validation.MockAddress", "city", this.cityRequiredDefinition);
        Object value = attributeValueReader.getValue();
        DictionaryValidationResult dictionaryValidationResult = new DictionaryValidationResult();
        ConstraintValidationResult constraintValidationResult = this.processor.process(dictionaryValidationResult, value, (ExistenceConstraint)this.cityRequiredDefinition, (AttributeValueReader)attributeValueReader).getFirstConstraintValidationResult();
        Assert.assertEquals((Object)new ExistenceConstraintProcessor().getName(), (Object)constraintValidationResult.getConstraintName());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)constraintValidationResult.getStatus());
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)"error.required", (Object)constraintValidationResult.getErrorKey());
        int countConstraints = 0;
        if (dictionaryValidationResult.getNumberOfErrors() > 0) {
            for (ConstraintValidationResult r : dictionaryValidationResult) {
                if (r.getStatus().getLevel() < ErrorLevel.WARN.getLevel()) continue;
                ++countConstraints;
            }
        }
        Assert.assertEquals((long)1L, (long)countConstraints);
    }

    @Test
    public void testPresenceNotRequiredSingleAttributeSuccess() {
        SingleAttributeValueReader attributeValueReader = new SingleAttributeValueReader((Object)this.noPostalCodeAddress.getCountry(), "org.kuali.rice.kns.datadictionary.validation.MockAddress", "country", this.countryNotRequiredDefinition);
        Object value = attributeValueReader.getValue();
        DictionaryValidationResult dictionaryValidationResult = new DictionaryValidationResult();
        dictionaryValidationResult.setErrorLevel(ErrorLevel.OK);
        ConstraintValidationResult constraintValidationResult = this.processor.process(dictionaryValidationResult, value, (ExistenceConstraint)this.countryNotRequiredDefinition, (AttributeValueReader)attributeValueReader).getFirstConstraintValidationResult();
        Assert.assertEquals((Object)new ExistenceConstraintProcessor().getName(), (Object)constraintValidationResult.getConstraintName());
        Assert.assertEquals((Object)ErrorLevel.INAPPLICABLE, (Object)constraintValidationResult.getStatus());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
    }

    @Test
    public void testAbsenceNotRequiredSingleAttributeSuccess() {
        SingleAttributeValueReader attributeValueReader = new SingleAttributeValueReader((Object)this.noPostalCodeOrCountryAddress.getCountry(), "org.kuali.rice.kns.datadictionary.validation.MockAddress", "country", this.countryNotRequiredDefinition);
        Object value = attributeValueReader.getValue();
        DictionaryValidationResult dictionaryValidationResult = new DictionaryValidationResult();
        dictionaryValidationResult.setErrorLevel(ErrorLevel.OK);
        ConstraintValidationResult constraintValidationResult = this.processor.process(dictionaryValidationResult, value, (ExistenceConstraint)this.countryNotRequiredDefinition, (AttributeValueReader)attributeValueReader).getFirstConstraintValidationResult();
        Assert.assertEquals((Object)new ExistenceConstraintProcessor().getName(), (Object)constraintValidationResult.getConstraintName());
        Assert.assertEquals((Object)ErrorLevel.INAPPLICABLE, (Object)constraintValidationResult.getStatus());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
    }

    @Test
    public void testPresenceNoConstraintSingleAttributeSuccess() {
        SingleAttributeValueReader attributeValueReader = new SingleAttributeValueReader((Object)this.noPostalCodeAddress.getCountry(), "org.kuali.rice.kns.datadictionary.validation.MockAddress", "country", this.countryNoConstraintDefinition);
        Object value = attributeValueReader.getValue();
        DictionaryValidationResult dictionaryValidationResult = new DictionaryValidationResult();
        dictionaryValidationResult.setErrorLevel(ErrorLevel.OK);
        ConstraintValidationResult constraintValidationResult = this.processor.process(dictionaryValidationResult, value, (ExistenceConstraint)this.countryNoConstraintDefinition, (AttributeValueReader)attributeValueReader).getFirstConstraintValidationResult();
        Assert.assertEquals((Object)new ExistenceConstraintProcessor().getName(), (Object)constraintValidationResult.getConstraintName());
        Assert.assertEquals((Object)ErrorLevel.NOCONSTRAINT, (Object)constraintValidationResult.getStatus());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
    }

    @Test
    public void testAbsenceNoConstraintSingleAttributeSuccess() {
        SingleAttributeValueReader attributeValueReader = new SingleAttributeValueReader((Object)this.noPostalCodeOrCountryAddress.getCountry(), "org.kuali.rice.kns.datadictionary.validation.MockAddress", "country", this.countryNoConstraintDefinition);
        Object value = attributeValueReader.getValue();
        DictionaryValidationResult dictionaryValidationResult = new DictionaryValidationResult();
        dictionaryValidationResult.setErrorLevel(ErrorLevel.OK);
        ConstraintValidationResult constraintValidationResult = this.processor.process(dictionaryValidationResult, value, (ExistenceConstraint)this.countryNoConstraintDefinition, (AttributeValueReader)attributeValueReader).getFirstConstraintValidationResult();
        Assert.assertEquals((Object)new ExistenceConstraintProcessor().getName(), (Object)constraintValidationResult.getConstraintName());
        Assert.assertEquals((Object)ErrorLevel.NOCONSTRAINT, (Object)constraintValidationResult.getStatus());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
    }
}

