/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.processor;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.uif.DataType;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.Company;
import org.kuali.rice.krad.datadictionary.validation.DictionaryObjectAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.constraint.LengthConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.LengthConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;

public class LengthConstraintProcessorTest {
    private LengthConstraintProcessor processor;
    private AttributeDefinition constrained0to2;
    private AttributeDefinition constrained0to3;
    private AttributeDefinition constrained2to4;
    private AttributeDefinition constrained3to6;
    private AttributeDefinition constrained5to12;
    private AttributeDefinition unconstrained;
    private Company companyWith3LetterName;

    @Before
    public void setUp() throws Exception {
        this.processor = new LengthConstraintProcessor();
        this.companyWith3LetterName = new Company("ABC");
        this.constrained0to2 = new AttributeDefinition(){

            public DataType getDataType() {
                return DataType.STRING;
            }

            public String getLabel() {
                return "Company Name";
            }

            public String getName() {
                return "name";
            }

            public Integer getMaxLength() {
                return 2;
            }

            public Integer getMinLength() {
                return 0;
            }
        };
        this.constrained0to3 = new AttributeDefinition(){

            public DataType getDataType() {
                return DataType.STRING;
            }

            public String getLabel() {
                return "Company Name";
            }

            public String getName() {
                return "name";
            }

            public Integer getMaxLength() {
                return 3;
            }

            public Integer getMinLength() {
                return 0;
            }
        };
        this.constrained2to4 = new AttributeDefinition(){

            public DataType getDataType() {
                return DataType.STRING;
            }

            public String getLabel() {
                return "Company Name";
            }

            public String getName() {
                return "name";
            }

            public Integer getMaxLength() {
                return 4;
            }

            public Integer getMinLength() {
                return 2;
            }
        };
        this.constrained3to6 = new AttributeDefinition(){

            public DataType getDataType() {
                return DataType.STRING;
            }

            public String getLabel() {
                return "Company Name";
            }

            public String getName() {
                return "name";
            }

            public Integer getMaxLength() {
                return 6;
            }

            public Integer getMinLength() {
                return 3;
            }
        };
        this.constrained5to12 = new AttributeDefinition(){

            public DataType getDataType() {
                return DataType.STRING;
            }

            public String getLabel() {
                return "Company Name";
            }

            public String getName() {
                return "name";
            }

            public Integer getMaxLength() {
                return 5;
            }

            public Integer getMinLength() {
                return 12;
            }
        };
        this.unconstrained = new AttributeDefinition(){

            public DataType getDataType() {
                return DataType.STRING;
            }

            public String getLabel() {
                return "Company Name";
            }

            public String getName() {
                return "name";
            }

            public Integer getMaxLength() {
                return null;
            }

            public Integer getMinLength() {
                return null;
            }
        };
    }

    @Test
    public void testNameWithinRangeSuccess() {
        DictionaryValidationResult dictionaryValidationResult = new DictionaryValidationResult();
        dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        ConstraintValidationResult result = this.process(dictionaryValidationResult, this.companyWith3LetterName, this.constrained2to4, "name");
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new LengthConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testNameAtTopOfRangeFailure() {
        DictionaryValidationResult dictionaryValidationResult = new DictionaryValidationResult();
        dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        ConstraintValidationResult result = this.process(dictionaryValidationResult, this.companyWith3LetterName, this.constrained0to3, "name");
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new LengthConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testNameAtBottomOfRangeSuccess() {
        DictionaryValidationResult dictionaryValidationResult = new DictionaryValidationResult();
        dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        ConstraintValidationResult result = this.process(dictionaryValidationResult, this.companyWith3LetterName, this.constrained3to6, "name");
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new LengthConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testNameLengthBelowRangeFailure() {
        DictionaryValidationResult dictionaryValidationResult = new DictionaryValidationResult();
        dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        ConstraintValidationResult result = this.process(dictionaryValidationResult, this.companyWith3LetterName, this.constrained5to12, "name");
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new LengthConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testNameLengthAboveRangeFailure() {
        DictionaryValidationResult dictionaryValidationResult = new DictionaryValidationResult();
        dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        ConstraintValidationResult result = this.process(dictionaryValidationResult, this.companyWith3LetterName, this.constrained0to2, "name");
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new LengthConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testNameLengthUnconstrainedSuccess() {
        DictionaryValidationResult dictionaryValidationResult = new DictionaryValidationResult();
        dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        ConstraintValidationResult result = this.process(dictionaryValidationResult, this.companyWith3LetterName, this.unconstrained, "name");
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.NOCONSTRAINT, (Object)result.getStatus());
        Assert.assertEquals((Object)new LengthConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    private ConstraintValidationResult process(DictionaryValidationResult dictionaryValidationResult, Object object, AttributeDefinition definition, String attributeName) {
        BusinessObjectEntry entry = new BusinessObjectEntry();
        entry.setAttributes(Collections.singletonList(definition));
        DictionaryObjectAttributeValueReader attributeValueReader = new DictionaryObjectAttributeValueReader(object, "org.kuali.rice.kns.datadictionary.validation.MockCompany", (DataDictionaryEntry)entry);
        attributeValueReader.setAttributeName(attributeName);
        Object value = attributeValueReader.getValue();
        return this.processor.process(dictionaryValidationResult, value, (LengthConstraint)definition, (AttributeValueReader)attributeValueReader).getFirstConstraintValidationResult();
    }
}

