/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.impl.CsrfServiceImpl;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@RunWith(value=MockitoJUnitRunner.class)
public class CsrfServiceImplTest {
    @Mock
    private ConfigurationService configurationService;
    @Mock
    private ParameterService parameterService;
    @InjectMocks
    private CsrfServiceImpl csrfService;

    @Before
    public void setUp() {
        this.setExemptPathsConfig(null);
        this.setExemptPathsParam(null);
        this.setCsrfEnabledConfig(true);
        this.setCsrfEnabledParam(null);
    }

    @Test
    public void testIsExemptPath_NoExemptPaths() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("http://localhost/myurl");
        Assert.assertFalse((boolean)this.csrfService.isExemptPath((HttpServletRequest)request));
    }

    @Test
    public void testIsExemptPath_OneExemptPath_Config() {
        this.setExemptPathsConfig("myurl");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("http://localhost/myurl");
        Assert.assertTrue((boolean)this.csrfService.isExemptPath((HttpServletRequest)request));
        request.setRequestURI("http://localhost/myurl2");
        Assert.assertTrue((boolean)this.csrfService.isExemptPath((HttpServletRequest)request));
        request.setRequestURI("http://localhost/myotherurl");
        Assert.assertFalse((boolean)this.csrfService.isExemptPath((HttpServletRequest)request));
    }

    @Test
    public void testIsExemptPath_MultipleExemptPaths_Config() {
        this.setExemptPathsConfig("one,two,http://localhost/three");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("http://localhost/one");
        Assert.assertTrue((boolean)this.csrfService.isExemptPath((HttpServletRequest)request));
        request.setRequestURI("http://localhost/two");
        Assert.assertTrue((boolean)this.csrfService.isExemptPath((HttpServletRequest)request));
        request.setRequestURI("http://localhost/three");
        Assert.assertTrue((boolean)this.csrfService.isExemptPath((HttpServletRequest)request));
    }

    @Test
    public void testIsExemptPath_OneExemptPath_Param() {
        this.setExemptPathsParam("myurl");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("http://localhost/myurl");
        Assert.assertTrue((boolean)this.csrfService.isExemptPath((HttpServletRequest)request));
        request.setRequestURI("http://localhost/myurl2");
        Assert.assertTrue((boolean)this.csrfService.isExemptPath((HttpServletRequest)request));
        request.setRequestURI("http://localhost/myotherurl");
        Assert.assertFalse((boolean)this.csrfService.isExemptPath((HttpServletRequest)request));
    }

    @Test
    public void testIsExemptPath_MultipleExemptPaths_Param() {
        this.setExemptPathsParam("one,two,http://localhost/three");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("http://localhost/one");
        Assert.assertTrue((boolean)this.csrfService.isExemptPath((HttpServletRequest)request));
        request.setRequestURI("http://localhost/two");
        Assert.assertTrue((boolean)this.csrfService.isExemptPath((HttpServletRequest)request));
        request.setRequestURI("http://localhost/three");
        Assert.assertTrue((boolean)this.csrfService.isExemptPath((HttpServletRequest)request));
    }

    @Test
    public void testIsExemptPath_Param_Overrides_Config() {
        this.setExemptPathsConfig("two");
        this.setExemptPathsParam("one,http://localhost/three");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("http://localhost/one");
        Assert.assertTrue((boolean)this.csrfService.isExemptPath((HttpServletRequest)request));
        request.setRequestURI("http://localhost/three");
        Assert.assertTrue((boolean)this.csrfService.isExemptPath((HttpServletRequest)request));
        request.setRequestURI("four");
        Assert.assertFalse((boolean)this.csrfService.isExemptPath((HttpServletRequest)request));
        request.setRequestURI("http://localhost/two");
        Assert.assertFalse((boolean)this.csrfService.isExemptPath((HttpServletRequest)request));
    }

    @Test
    public void testIsEnabled_Default() {
        Assert.assertTrue((boolean)this.csrfService.isEnabled());
    }

    @Test
    public void testIsEnabled_Config() {
        this.setCsrfEnabledConfig(false);
        Assert.assertFalse((boolean)this.csrfService.isEnabled());
        this.setCsrfEnabledConfig(true);
        Assert.assertTrue((boolean)this.csrfService.isEnabled());
    }

    @Test
    public void testIsEnabled_Param() {
        this.setCsrfEnabledParam(false);
        Assert.assertFalse((boolean)this.csrfService.isEnabled());
        this.setCsrfEnabledParam(true);
        Assert.assertTrue((boolean)this.csrfService.isEnabled());
    }

    @Test
    public void testIsEnabled_Param_Overrides_Config() {
        this.setCsrfEnabledConfig(true);
        this.setCsrfEnabledParam(false);
        Assert.assertFalse((boolean)this.csrfService.isEnabled());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidateCsrfIfNecessary_NullRequest() {
        this.csrfService.validateCsrfIfNecessary(null, (HttpServletResponse)new MockHttpServletResponse());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidateCsrfIfNecessary_NullResponse() {
        this.csrfService.validateCsrfIfNecessary((HttpServletRequest)new MockHttpServletRequest(), null);
    }

    @Test
    public void testValidateCsrfIfNecessary() {
        this.setCsrfEnabledConfig(false);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        Assert.assertTrue((boolean)this.csrfService.validateCsrfIfNecessary((HttpServletRequest)request, (HttpServletResponse)response));
        this.setCsrfEnabledConfig(true);
        Assert.assertFalse((boolean)this.csrfService.validateCsrfIfNecessary((HttpServletRequest)request, (HttpServletResponse)response));
        request = new MockHttpServletRequest();
        response = new MockHttpServletResponse();
        this.setExemptPathsConfig("a");
        request.setRequestURI("http://a");
        Assert.assertTrue((boolean)this.csrfService.validateCsrfIfNecessary((HttpServletRequest)request, (HttpServletResponse)response));
        request = new MockHttpServletRequest();
        response = new MockHttpServletResponse();
        request.setRequestURI("http://b");
        Assert.assertFalse((boolean)this.csrfService.validateCsrfIfNecessary((HttpServletRequest)request, (HttpServletResponse)response));
        Assert.assertEquals((long)403L, (long)response.getStatus());
    }

    @Test
    public void testGetSessionToken() {
        this.setCsrfEnabledConfig(true);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod("GET");
        MockHttpServletResponse response = new MockHttpServletResponse();
        this.csrfService.validateCsrfIfNecessary((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertNotNull((Object)this.csrfService.getSessionToken((HttpServletRequest)request));
    }

    private void setCsrfEnabledParam(Boolean value) {
        Mockito.when((Object)this.parameterService.getParameterValueAsBoolean("KR-SYS", "All", "CSRF_ENABLED_IND")).thenReturn((Object)value);
    }

    private void setCsrfEnabledConfig(boolean value) {
        Mockito.when((Object)this.configurationService.getPropertyValueAsBoolean("csrf.enabled", true)).thenReturn((Object)value);
    }

    private void setExemptPathsParam(String exemptPaths) {
        Mockito.when((Object)this.parameterService.getParameterValueAsString("KR-SYS", "All", "CSRF_EXEMPT_PATHS")).thenReturn((Object)exemptPaths);
    }

    private void setExemptPathsConfig(String exemptPaths) {
        Mockito.when((Object)this.configurationService.getPropertyValueAsString("csrf.exempt.paths")).thenReturn((Object)exemptPaths);
    }
}

