/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.widget;

import java.util.ArrayList;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.validation.Employee;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.layout.TableLayoutManager;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.RichTable;
import org.kuali.rice.krad.web.form.UifFormBase;

public class RichTableTest {
    private RichTable richTable;
    private CollectionGroup group;

    @Before
    public void setup() {
        this.richTable = new RichTable();
        this.group = new CollectionGroup();
        this.group.setCollectionObjectClass(Employee.class);
        TableLayoutManager layoutManager = new TableLayoutManager();
        layoutManager.setRenderSequenceField(true);
        this.group.setLayoutManager((LayoutManager)layoutManager);
        this.group.setRenderSelectField(false);
        this.group.setRenderLineActions(false);
        ArrayList<DataField> items = new ArrayList<DataField>(1);
        DataField name = new DataField();
        name.setPropertyName("employeeId");
        items.add(name);
        DataField number = new DataField();
        number.setPropertyName("positionTitle");
        items.add(number);
        DataField contactEmail = new DataField();
        contactEmail.setPropertyName("contactEmail");
        items.add(contactEmail);
        this.group.setItems(items);
    }

    @Test
    public void testComponentOptionsDefault() throws Exception {
        String expected = "[ null ,{\"sSortDataType\" : \"dom-text\" , \"sType\" : \"string\"} , {\"sSortDataType\" : \"dom-text\" , \"sType\" : \"string\"} , {\"sSortDataType\" : \"dom-text\" , \"sType\" : \"string\"} ]";
        this.assertRichTableComponentOptions(null, expected, "aoColumns");
    }

    @Test
    public void testComponentOptionsAoColumnsJSOptions() throws Exception {
        String innerColValues = "{bVisible: false}, null, null";
        String options = "[" + innerColValues + "]";
        String expected = "[ null ," + innerColValues + " ]";
        this.assertRichTableComponentOptions(options, expected, "aoColumns");
    }

    @Test
    public void testComponentOptionsHideColumnOnRichTable() {
        HashSet<String> hiddenColumns = new HashSet<String>();
        hiddenColumns.add("employeeId");
        HashSet<String> sortableColumns = new HashSet<String>();
        sortableColumns.add("positionTitle");
        this.richTable.setSortableColumns(sortableColumns);
        this.richTable.setHiddenColumns(hiddenColumns);
        String expected = "[ null ,{bVisible: false}, {\"sSortDataType\" : \"dom-text\" , \"sType\" : \"string\"}, {'bSortable': false}]";
        this.assertRichTableComponentOptions(null, expected, "aoColumns");
    }

    @Test
    public void testComponentOptionsHideColumnOnLayoutManager() {
        HashSet<String> richTableHiddenColumns = new HashSet<String>();
        richTableHiddenColumns.add("employeeId");
        HashSet<String> sortableColumns = new HashSet<String>();
        sortableColumns.add("positionTitle");
        this.richTable.setSortableColumns(sortableColumns);
        this.richTable.setHiddenColumns(richTableHiddenColumns);
        HashSet<String> lmHiddenColumns = new HashSet<String>();
        lmHiddenColumns.add("contactEmail");
        HashSet<String> lmSortableColumns = new HashSet<String>();
        lmSortableColumns.add("employeeId");
        ((TableLayoutManager)this.group.getLayoutManager()).setSortableColumns(lmSortableColumns);
        ((TableLayoutManager)this.group.getLayoutManager()).setHiddenColumns(lmHiddenColumns);
        String expected = "[ null ,{\"sSortDataType\" : \"dom-text\" , \"sType\" : \"string\"}, {'bSortable': false}, {bVisible: false}]";
        this.assertRichTableComponentOptions(null, expected, "aoColumns");
    }

    private void assertRichTableComponentOptions(String optionsOnGroup, String optionsOnRichTable, String optionKey) {
        this.richTable.getComponentOptions().put(optionKey, optionsOnGroup);
        this.richTable.performFinalize(new View(), (Object)new UifFormBase(), (Component)this.group);
        Assert.assertEquals((Object)optionsOnRichTable, this.richTable.getComponentOptions().get(optionKey));
    }
}

