/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.bo;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.provider.Provider;
import org.kuali.rice.krad.data.provider.ProviderRegistry;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ModuleConfiguration
implements InitializingBean,
ApplicationContextAware {
    private static final Logger LOG = Logger.getLogger(ModuleConfiguration.class);
    protected String namespaceCode;
    protected ApplicationContext applicationContext;
    protected List<String> packagePrefixes;
    protected List<String> databaseRepositoryFilePaths;
    protected List<String> dataDictionaryPackages;
    protected List<String> scriptConfigurationFilePaths;
    protected List<String> resourceBundleNames;
    protected String dataSourceName;
    protected Map<Class, Class> externalizableBusinessObjectImplementations;
    protected boolean initializeDataDictionary;
    protected Object persistenceService;
    protected ProviderRegistry providerRegistry;
    protected DataDictionaryService dataDictionaryService;
    protected List<Provider> providers = Collections.unmodifiableList(Collections.emptyList());

    public ModuleConfiguration() {
        this.databaseRepositoryFilePaths = new ArrayList<String>();
        this.dataDictionaryPackages = new ArrayList<String>();
        this.scriptConfigurationFilePaths = new ArrayList<String>();
        this.resourceBundleNames = new ArrayList<String>();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.isInitializeDataDictionary() && this.getDataDictionaryPackages() != null && !this.getDataDictionaryPackages().isEmpty()) {
            if (this.getDataDictionaryService() == null) {
                this.setDataDictionaryService(KRADServiceLocatorWeb.getDataDictionaryService());
            }
            if (this.getDataDictionaryService() == null) {
                this.setDataDictionaryService((DataDictionaryService)this.applicationContext.getBean("dataDictionaryService"));
            }
            if (this.dataDictionaryService != null) {
                this.dataDictionaryService.addDataDictionaryLocations(this.getNamespaceCode(), this.getDataDictionaryPackages());
            }
        }
        this.loadOjbRepositoryFiles();
        if (this.getProviders() != null) {
            ProviderRegistry providerRegistry = this.getProviderRegistry();
            if (providerRegistry != null) {
                for (Provider provider : this.getProviders()) {
                    LOG.info((Object)("Registering data module provider for module with " + this.getNamespaceCode() + ": " + provider));
                    providerRegistry.registerProvider(provider);
                }
            } else {
                LOG.error((Object)("Provider registry not initialized.  Data module provider configuration will be incomplete. (" + this.getNamespaceCode() + ")"));
            }
        }
    }

    @Deprecated
    protected void loadOjbRepositoryFiles() {
        String persistenceServiceOjbName = "persistenceServiceOjb";
        if (this.getDatabaseRepositoryFilePaths() != null) {
            for (String repositoryLocation : this.getDatabaseRepositoryFilePaths()) {
                if (this.getPersistenceService() == null) {
                    this.setPersistenceService(GlobalResourceLoader.getService((String)persistenceServiceOjbName));
                }
                if (this.persistenceService == null) {
                    this.setPersistenceService(this.applicationContext.getBean(persistenceServiceOjbName));
                }
                LOG.warn((Object)("Loading OJB Configuration in " + this.getNamespaceCode() + " module.  OJB is deprecated as of Rice 2.4: " + repositoryLocation));
                try {
                    MethodUtils.invokeExactMethod((Object)this.persistenceService, (String)"loadRepositoryDescriptor", (Object)repositoryLocation);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Deprecated
    public List<String> getDatabaseRepositoryFilePaths() {
        return this.databaseRepositoryFilePaths;
    }

    @Deprecated
    public void setDatabaseRepositoryFilePaths(List<String> databaseRepositoryFilePaths) {
        this.trimList(databaseRepositoryFilePaths);
        this.databaseRepositoryFilePaths = databaseRepositoryFilePaths;
    }

    public List<String> getDataDictionaryPackages() {
        return this.dataDictionaryPackages;
    }

    public void setDataDictionaryPackages(List<String> dataDictionaryPackages) {
        this.trimList(dataDictionaryPackages);
        this.dataDictionaryPackages = dataDictionaryPackages;
    }

    public Map<Class, Class> getExternalizableBusinessObjectImplementations() {
        if (this.externalizableBusinessObjectImplementations == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.externalizableBusinessObjectImplementations);
    }

    public void setExternalizableBusinessObjectImplementations(Map<Class, Class> externalizableBusinessObjectImplementations) {
        if (externalizableBusinessObjectImplementations != null) {
            for (Class implClass : externalizableBusinessObjectImplementations.values()) {
                int implModifiers = implClass.getModifiers();
                if (!Modifier.isInterface(implModifiers) && !Modifier.isAbstract(implModifiers)) continue;
                throw new RuntimeException("Externalizable business object implementation class " + implClass.getName() + " must be a non-interface, non-abstract class");
            }
        }
        this.externalizableBusinessObjectImplementations = externalizableBusinessObjectImplementations;
    }

    public List<String> getPackagePrefixes() {
        return this.packagePrefixes;
    }

    public void setPackagePrefixes(List<String> packagePrefixes) {
        this.trimList(packagePrefixes);
        this.packagePrefixes = packagePrefixes;
    }

    public void setInitializeDataDictionary(boolean initializeDataDictionary) {
        this.initializeDataDictionary = initializeDataDictionary;
    }

    public List<String> getScriptConfigurationFilePaths() {
        return this.scriptConfigurationFilePaths;
    }

    public List<String> getResourceBundleNames() {
        return this.resourceBundleNames;
    }

    public void setResourceBundleNames(List<String> resourceBundleNames) {
        this.resourceBundleNames = resourceBundleNames;
    }

    public boolean isInitializeDataDictionary() {
        return this.initializeDataDictionary;
    }

    public void setScriptConfigurationFilePaths(List<String> scriptConfigurationFilePaths) {
        this.scriptConfigurationFilePaths = scriptConfigurationFilePaths;
    }

    public String getNamespaceCode() {
        return this.namespaceCode;
    }

    public void setNamespaceCode(String namespaceCode) {
        this.namespaceCode = namespaceCode;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setProviders(List<Provider> providers) {
        this.providers = Collections.unmodifiableList(new ArrayList<Provider>(providers));
    }

    public List<Provider> getProviders() {
        return this.providers;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public ProviderRegistry getProviderRegistry() {
        if (this.providerRegistry == null) {
            this.providerRegistry = KradDataServiceLocator.getProviderRegistry();
        }
        return this.providerRegistry;
    }

    public void setProviderRegistry(ProviderRegistry providerRegistry) {
        this.providerRegistry = providerRegistry;
    }

    @Deprecated
    public Object getPersistenceService() {
        return this.persistenceService;
    }

    @Deprecated
    public void setPersistenceService(Object persistenceService) {
        this.persistenceService = persistenceService;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    protected void trimList(List<String> stringList) {
        if (stringList != null) {
            for (int i = 0; i < stringList.size(); ++i) {
                String elmt = stringList.get(i);
                elmt = elmt.trim();
                stringList.set(i, elmt);
            }
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("namespaceCode", (Object)this.namespaceCode).append("applicationContext", (Object)this.applicationContext.getDisplayName()).append("dataSourceName", (Object)this.dataSourceName).toString();
    }
}

