/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.data.metadata.DataObjectCollection;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.DataDictionaryDefinitionBase;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.validation.capability.CollectionSizeConstrainable;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;

@BeanTag(name="collectionDefinition")
public class CollectionDefinition
extends DataDictionaryDefinitionBase
implements CollectionSizeConstrainable {
    private static final long serialVersionUID = -2644072136271281041L;
    protected DataObjectCollection dataObjectCollection;
    protected String dataObjectClass;
    protected String name;
    protected String label;
    protected String shortLabel;
    protected String elementLabel;
    protected String summary;
    protected String description;
    protected Integer minOccurs;
    protected Integer maxOccurs;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("invalid (blank) name");
        }
        this.name = name;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        if (this.getDataObjectCollection() != null) {
            return this.getDataObjectCollection().getLabel();
        }
        return "";
    }

    public void setLabel(String label) {
        if (StringUtils.isBlank((String)label)) {
            throw new IllegalArgumentException("invalid (blank) label");
        }
        this.label = label;
    }

    public String getShortLabel() {
        if (this.shortLabel != null) {
            return this.shortLabel;
        }
        if (this.getDataObjectCollection() != null) {
            if (StringUtils.equals((String)this.getDataObjectCollection().getLabel(), (String)this.getDataObjectCollection().getShortLabel()) && this.label != null) {
                return this.getLabel();
            }
            return this.getDataObjectCollection().getShortLabel();
        }
        return this.getLabel();
    }

    public void setShortLabel(String shortLabel) {
        if (StringUtils.isBlank((String)shortLabel)) {
            throw new IllegalArgumentException("invalid (blank) shortLabel");
        }
        this.shortLabel = shortLabel;
    }

    public String getElementLabel() {
        if (this.elementLabel != null) {
            return this.elementLabel;
        }
        if (this.getDataObjectCollection() != null) {
            return this.getDataObjectCollection().getElementLabel();
        }
        return this.dataObjectClass;
    }

    public void setElementLabel(String elementLabel) {
        this.elementLabel = elementLabel;
    }

    public String getSummary() {
        if (this.summary != null) {
            return this.summary;
        }
        return "";
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        if (this.getDataObjectCollection() != null) {
            return this.getDataObjectCollection().getDescription();
        }
        return "";
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDataObjectClass() {
        if (this.dataObjectClass == null && this.getDataObjectCollection() != null) {
            this.dataObjectClass = this.getDataObjectCollection().getRelatedType().getName();
        }
        return this.dataObjectClass;
    }

    public void setDataObjectClass(String dataObjectClass) {
        this.dataObjectClass = dataObjectClass;
    }

    @Deprecated
    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass) {
        this.completeValidation(rootBusinessObjectClass, otherBusinessObjectClass, new ValidationTrace());
    }

    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass, ValidationTrace tracer) {
        tracer.addBean(this.getClass().getSimpleName(), "Attribute: " + this.getName());
        if (!DataDictionary.isCollectionPropertyOf(rootBusinessObjectClass, this.name)) {
            String[] currentValues = new String[]{"property = " + this.getName(), "Class =" + rootBusinessObjectClass};
            tracer.createError("Property is not collection property of the class", currentValues);
        }
    }

    @Override
    public Integer getMaximumNumberOfElements() {
        return this.maxOccurs;
    }

    @Override
    public Integer getMinimumNumberOfElements() {
        if (this.minOccurs != null) {
            return this.minOccurs;
        }
        if (this.getDataObjectCollection() != null) {
            return this.getDataObjectCollection().getMinItems().intValue();
        }
        return null;
    }

    public Integer getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(Integer minOccurs) {
        this.minOccurs = minOccurs;
    }

    public Integer getMaxOccurs() {
        if (this.maxOccurs != null) {
            return this.maxOccurs;
        }
        if (this.getDataObjectCollection() != null) {
            return this.getDataObjectCollection().getMaxItems().intValue();
        }
        return null;
    }

    public void setMaxOccurs(Integer maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public DataObjectCollection getDataObjectCollection() {
        return this.dataObjectCollection;
    }

    public void setDataObjectCollection(DataObjectCollection dataObjectCollection) {
        this.dataObjectCollection = dataObjectCollection;
    }
}

