/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.DataDictionaryDefinitionBase;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;

@BeanTag(name="primitiveAttributeDefinition")
public class PrimitiveAttributeDefinition
extends DataDictionaryDefinitionBase {
    private static final Logger LOG = Logger.getLogger(PrimitiveAttributeDefinition.class);
    private static final long serialVersionUID = -715128943756700821L;
    protected String sourceName;
    protected String targetName;

    @BeanTagAttribute(name="sourceName")
    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        if (StringUtils.isBlank((String)sourceName)) {
            throw new IllegalArgumentException("invalid (blank) sourceName");
        }
        this.sourceName = sourceName;
    }

    @BeanTagAttribute(name="targetName")
    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        if (StringUtils.isBlank((String)targetName)) {
            throw new IllegalArgumentException("invalid (blank) targetName");
        }
        this.targetName = targetName;
    }

    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass) {
        this.completeValidation(rootBusinessObjectClass, otherBusinessObjectClass, new ValidationTrace());
    }

    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass, ValidationTrace tracer) {
        String[] currentValues;
        String[] currentValues2;
        tracer.addBean(this.getClass().getSimpleName(), "NOBEANID");
        try {
            if (!DataDictionary.isPropertyOf(rootBusinessObjectClass, this.sourceName)) {
                currentValues2 = new String[]{"attribute = " + this.getSourceName(), "class = " + rootBusinessObjectClass};
                tracer.createError("Unable to find attribute on class", currentValues2);
            }
        }
        catch (RuntimeException ex) {
            currentValues = new String[]{"attribute = " + this.getSourceName(), "class = " + rootBusinessObjectClass, "Exception = " + ex.getMessage()};
            tracer.createError("Unable to find attribute on class", currentValues);
            LOG.error((Object)("Exception while validating PrimitiveAttributeDefintion on " + rootBusinessObjectClass + ": " + this), (Throwable)ex);
        }
        try {
            if (!DataDictionary.isPropertyOf(otherBusinessObjectClass, this.targetName)) {
                currentValues2 = new String[]{"attribute = " + this.getTargetName(), "class = " + otherBusinessObjectClass};
                tracer.createError("Unable to find attribute on class", currentValues2);
            }
        }
        catch (RuntimeException ex) {
            currentValues = new String[]{"attribute = " + this.getTargetName(), "class = " + otherBusinessObjectClass, "Exception = " + ex.getMessage()};
            tracer.createError("Unable to find attribute on class", currentValues);
            LOG.error((Object)("Exception while validating PrimitiveAttributeDefintion on " + rootBusinessObjectClass + ": " + this), (Throwable)ex);
        }
        try {
            Class sourceClass = DataDictionary.getAttributeClass(rootBusinessObjectClass, this.sourceName);
            Class targetClass = DataDictionary.getAttributeClass(otherBusinessObjectClass, this.targetName);
            if (null == sourceClass && null != targetClass || null != sourceClass && null == targetClass || !StringUtils.equals((String)sourceClass.getName(), (String)targetClass.getName())) {
                String sourceClassName = rootBusinessObjectClass.getName();
                String targetClassName = otherBusinessObjectClass.getName();
                String sourcePath = sourceClassName + "." + this.sourceName;
                String targetPath = targetClassName + "." + this.targetName;
                if (sourcePath != null && !StringUtils.contains((String)sourcePath, (String)".principalId") && targetPath != null && !StringUtils.contains((String)targetPath, (String)".principalId")) {
                    String[] currentValues3 = new String[]{"source = " + sourcePath + "' (" + sourceClass + ")", "target = " + targetPath + "' (" + targetClass + ")"};
                    tracer.createError("Source and target of different types", currentValues3);
                }
            }
        }
        catch (RuntimeException ex) {
            currentValues = new String[]{"Exception = " + ex.getMessage()};
            tracer.createError("Unable to validate property", currentValues);
            LOG.error((Object)("Exception while validating PrimitiveAttributeDefintion on " + rootBusinessObjectClass + ": " + this), (Throwable)ex);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PrimitiveAttributeDefinition [sourceName=").append(this.sourceName).append(", targetName=").append(this.targetName).append("]");
        return builder.toString();
    }
}

