/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.validation.constraint.AllowCharacterConstraint;

@BeanTags(value={@BeanTag(name="alphaPatternConstraint", parent="AlphaPatternConstraint"), @BeanTag(name="alphaWithBasicPunc", parent="AlphaWithBasicPunc")})
public class AlphaPatternConstraint
extends AllowCharacterConstraint {
    protected boolean lowerCase = false;
    protected boolean upperCase = false;

    @Override
    protected String getRegexString() {
        StringBuilder regexString = new StringBuilder("[A-Za-z");
        if (this.lowerCase) {
            regexString = new StringBuilder("[a-z");
        } else if (this.upperCase) {
            regexString = new StringBuilder("[A-Z");
        }
        regexString.append(this.getAllowedCharacterRegex());
        regexString.append("]");
        return regexString.toString();
    }

    @Override
    public String getMessageKey() {
        if (StringUtils.isEmpty((String)this.messageKey)) {
            StringBuilder key = new StringBuilder("");
            if (this.lowerCase) {
                return "validation.alphaPatternLowerCase";
            }
            if (this.upperCase) {
                return "validation.alphaPatternUpperCase";
            }
            return "validation.alphaPattern";
        }
        return this.messageKey;
    }

    @BeanTagAttribute(name="lowerCase")
    public boolean isLowerCase() {
        return this.lowerCase;
    }

    public void setLowerCase(boolean lowerCase) {
        this.lowerCase = lowerCase;
    }

    @BeanTagAttribute(name="upperCase")
    public boolean isUpperCase() {
        return this.upperCase;
    }

    public void setUpperCase(boolean upperCase) {
        this.upperCase = upperCase;
    }
}

