/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.document;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.PostLoad;
import javax.persistence.PostRemove;
import javax.persistence.PrePersist;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.UserSessionUtils;
import org.kuali.rice.krad.bo.AdHocRoutePerson;
import org.kuali.rice.krad.bo.AdHocRouteWorkgroup;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBaseAdapter;
import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.datadictionary.WorkflowAttributes;
import org.kuali.rice.krad.datadictionary.WorkflowProperties;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.exception.PessimisticLockingException;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.AttachmentService;
import org.kuali.rice.krad.service.DocumentSerializerService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.NoteService;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.NoteType;
import org.kuali.rice.krad.util.documentserializer.AlwaysFalsePropertySerializabilityEvaluator;
import org.kuali.rice.krad.util.documentserializer.AlwaysTruePropertySerializibilityEvaluator;
import org.kuali.rice.krad.util.documentserializer.BusinessObjectPropertySerializibilityEvaluator;
import org.kuali.rice.krad.util.documentserializer.PropertySerializabilityEvaluator;
import org.kuali.rice.krad.workflow.DocumentInitiator;
import org.kuali.rice.krad.workflow.KualiDocumentXmlMaterializer;
import org.kuali.rice.krad.workflow.KualiTransactionalDocumentInformation;
import org.springframework.util.CollectionUtils;

@MappedSuperclass
public abstract class DocumentBase
extends PersistableBusinessObjectBaseAdapter
implements Document,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 8530945307802647664L;
    private static final Logger LOG = Logger.getLogger(DocumentBase.class);
    @Id
    @Column(name="DOC_HDR_ID", length=14)
    protected String documentNumber;
    @Transient
    protected DocumentHeader documentHeader;
    @Transient
    protected List<PessimisticLock> pessimisticLocks;
    @Transient
    protected List<AdHocRoutePerson> adHocRoutePersons;
    @Transient
    protected List<AdHocRouteWorkgroup> adHocRouteWorkgroups;
    @Transient
    protected List<Note> notes;
    @Transient
    private String superUserAnnotation;
    private transient NoteService noteService;
    private transient AttachmentService attachmentService;

    public DocumentBase() {
        this.superUserAnnotation = "";
        this.documentHeader = new DocumentHeader();
        this.pessimisticLocks = new ArrayList<PessimisticLock>();
        this.adHocRoutePersons = new ArrayList<AdHocRoutePerson>();
        this.adHocRouteWorkgroups = new ArrayList<AdHocRouteWorkgroup>();
        this.notes = new ArrayList<Note>();
    }

    @Override
    public boolean getAllowsCopy() {
        return false;
    }

    @Override
    public String getDocumentTitle() {
        String description;
        String documentTypeLabel = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeByName(this.getDocumentHeader().getWorkflowDocument().getDocumentTypeName()).getLabel();
        if (null == documentTypeLabel) {
            documentTypeLabel = "";
        }
        if (null == (description = this.getDocumentHeader().getDocumentDescription())) {
            description = "";
        }
        return documentTypeLabel + " - " + description;
    }

    @Override
    public void prepareForSave() {
    }

    @Override
    public void processAfterRetrieve() {
    }

    @Override
    public void doRouteLevelChange(DocumentRouteLevelChange levelChangeEvent) {
    }

    @Override
    public void doActionTaken(ActionTakenEvent event) {
        if (KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDocumentEntry(this.getClass().getName()).getUseWorkflowPessimisticLocking() && !this.getNonLockingActionTakenCodes().contains(event.getActionTaken().getActionTaken().getCode())) {
            KRADServiceLocatorWeb.getPessimisticLockService().establishWorkflowPessimisticLocking(this);
        }
    }

    @Override
    public void afterActionTaken(ActionType performed, ActionTakenEvent event) {
    }

    protected List<String> getNonLockingActionTakenCodes() {
        ArrayList<String> actionTakenStatusCodes = new ArrayList<String>();
        actionTakenStatusCodes.add("S");
        actionTakenStatusCodes.add("K");
        actionTakenStatusCodes.add("F");
        actionTakenStatusCodes.add("D");
        actionTakenStatusCodes.add("X");
        actionTakenStatusCodes.add("R");
        return actionTakenStatusCodes;
    }

    @Override
    public void afterWorkflowEngineProcess(boolean successfullyProcessed) {
        if (KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDocumentEntry(this.getClass().getName()).getUseWorkflowPessimisticLocking() && successfullyProcessed) {
            KRADServiceLocatorWeb.getPessimisticLockService().releaseWorkflowPessimisticLocking(this);
        }
    }

    @Override
    public void beforeWorkflowEngineProcess() {
    }

    @Override
    public List<String> getWorkflowEngineDocumentIdsToLock() {
        return null;
    }

    public void toCopy() throws WorkflowException, IllegalStateException {
        if (!this.getAllowsCopy()) {
            throw new IllegalStateException(this.getClass().getName() + " does not support document-level copying");
        }
        String sourceDocumentHeaderId = this.getDocumentNumber();
        this.setNewDocumentHeader();
        this.notes.clear();
        this.addCopyErrorDocumentNote("copied from document " + sourceDocumentHeaderId);
    }

    protected void setNewDocumentHeader() throws WorkflowException {
        Person user = GlobalVariables.getUserSession().getPerson();
        WorkflowDocument sourceWorkflowDocument = KRADServiceLocatorWeb.getWorkflowDocumentService().loadWorkflowDocument(this.getDocumentNumber(), user);
        String sourceDocumentTypeName = sourceWorkflowDocument.getDocumentTypeName();
        WorkflowDocument workflowDocument = KRADServiceLocatorWeb.getWorkflowDocumentService().createWorkflowDocument(sourceDocumentTypeName, user);
        UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)workflowDocument);
        Document newDocument = KRADServiceLocatorWeb.getDocumentService().getNewDocument(sourceDocumentTypeName);
        DocumentHeader newDocumentHeader = newDocument.getDocumentHeader();
        newDocumentHeader.setDocumentTemplateNumber(this.getDocumentNumber());
        newDocumentHeader.setDocumentDescription(this.getDocumentHeader().getDocumentDescription());
        newDocumentHeader.setOrganizationDocumentNumber(this.getDocumentHeader().getOrganizationDocumentNumber());
        try {
            KRADServiceLocatorWeb.getLegacyDataAdapter().setObjectPropertyDeep(this, "documentNumber", this._persistence_get_documentNumber().getClass(), newDocument.getDocumentNumber());
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to set document number property in copied document " + this), (Throwable)e);
            throw new RuntimeException("Unable to set document number property in copied document " + this, e);
        }
        this.setDocumentHeader(newDocument.getDocumentHeader());
    }

    protected void addCopyErrorDocumentNote(String noteText) {
        Note note = null;
        try {
            note = KRADServiceLocatorWeb.getDocumentService().createNoteFromDocument(this, noteText);
        }
        catch (Exception e) {
            this.logErrors();
            throw new RuntimeException("Couldn't create note on copy or error", e);
        }
        this.addNote(note);
    }

    @Override
    public String getXmlForRouteReport() {
        this.prepareForSave();
        this.populateDocumentForRouting();
        return this.getDocumentHeader().getWorkflowDocument().getApplicationContent();
    }

    @Override
    public void populateDocumentForRouting() {
        this.getDocumentHeader().getWorkflowDocument().setApplicationContent(this.serializeDocumentToXml());
    }

    @Override
    public String serializeDocumentToXml() {
        DocumentSerializerService documentSerializerService = KRADServiceLocatorWeb.getDocumentSerializerService();
        String xml = documentSerializerService.serializeDocumentToXmlForRouting(this);
        return xml;
    }

    @Override
    public KualiDocumentXmlMaterializer wrapDocumentWithMetadataForXmlSerialization() {
        KualiTransactionalDocumentInformation transInfo = new KualiTransactionalDocumentInformation();
        DocumentInitiator initiator = new DocumentInitiator();
        String initiatorPrincipalId = this.getDocumentHeader().getWorkflowDocument().getDocument().getInitiatorPrincipalId();
        Person initiatorUser = KimApiServiceLocator.getPersonService().getPerson(initiatorPrincipalId);
        initiator.setPerson(initiatorUser);
        transInfo.setDocumentInitiator(initiator);
        KualiDocumentXmlMaterializer xmlWrapper = new KualiDocumentXmlMaterializer();
        xmlWrapper.setDocument(this);
        xmlWrapper.setKualiTransactionalDocumentInformation(transInfo);
        return xmlWrapper;
    }

    @Override
    public PropertySerializabilityEvaluator getDocumentPropertySerizabilityEvaluator() {
        String docTypeName = this.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        DocumentEntry documentEntry = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDocumentEntry(docTypeName);
        WorkflowProperties workflowProperties = documentEntry.getWorkflowProperties();
        WorkflowAttributes workflowAttributes = documentEntry.getWorkflowAttributes();
        return this.createPropertySerializabilityEvaluator(workflowProperties, workflowAttributes);
    }

    protected PropertySerializabilityEvaluator createPropertySerializabilityEvaluator(WorkflowProperties workflowProperties, WorkflowAttributes workflowAttributes) {
        if (workflowAttributes != null) {
            return new AlwaysFalsePropertySerializabilityEvaluator();
        }
        if (workflowProperties == null) {
            return new AlwaysTruePropertySerializibilityEvaluator();
        }
        BusinessObjectPropertySerializibilityEvaluator evaluator = new BusinessObjectPropertySerializibilityEvaluator();
        evaluator.initializeEvaluatorForDocument(this);
        return evaluator;
    }

    @Override
    public String getBasePathToDocumentDuringSerialization() {
        return "document";
    }

    @Override
    public DocumentHeader getDocumentHeader() {
        if ((this.documentHeader == null || this.documentHeader.getDocumentNumber() == null) && StringUtils.isNotBlank((String)this._persistence_get_documentNumber())) {
            this.documentHeader = KRADServiceLocatorWeb.getDocumentHeaderService().getDocumentHeaderById(this._persistence_get_documentNumber());
        }
        return this.documentHeader;
    }

    @Override
    public void setDocumentHeader(DocumentHeader documentHeader) {
        this.documentHeader = documentHeader;
    }

    @Override
    public String getDocumentNumber() {
        return this._persistence_get_documentNumber();
    }

    @Override
    public void setDocumentNumber(String documentNumber) {
        this._persistence_set_documentNumber(documentNumber);
    }

    @Override
    public List<AdHocRoutePerson> getAdHocRoutePersons() {
        return this.adHocRoutePersons;
    }

    @Override
    public void setAdHocRoutePersons(List<AdHocRoutePerson> adHocRoutePersons) {
        this.adHocRoutePersons = adHocRoutePersons;
    }

    @Override
    public List<AdHocRouteWorkgroup> getAdHocRouteWorkgroups() {
        return this.adHocRouteWorkgroups;
    }

    @Override
    public void setAdHocRouteWorkgroups(List<AdHocRouteWorkgroup> adHocRouteWorkgroups) {
        this.adHocRouteWorkgroups = adHocRouteWorkgroups;
    }

    @Override
    public void postProcessSave(DocumentEvent event) {
    }

    @Override
    public void prepareForSave(DocumentEvent event) {
    }

    @Override
    public void validateBusinessRules(DocumentEvent event) {
        if (GlobalVariables.getMessageMap().hasErrors()) {
            this.logErrors();
            throw new ValidationException("errors occured before business rule");
        }
        LOG.info((Object)("invoking rules engine on document " + this.getDocumentNumber()));
        boolean isValid = true;
        isValid = KRADServiceLocatorWeb.getKualiRuleService().applyRules(event);
        if (!isValid) {
            this.logErrors();
            throw new ValidationException("business rule evaluation failed");
        }
        if (GlobalVariables.getMessageMap().hasErrors()) {
            this.logErrors();
            throw new ValidationException("Unreported errors occured during business rule evaluation (rule developer needs to put meaningful error messages into global ErrorMap)");
        }
        LOG.debug((Object)"validation completed");
    }

    protected void logErrors() {
        if (LOG.isInfoEnabled() && GlobalVariables.getMessageMap().hasErrors()) {
            for (Map.Entry e : GlobalVariables.getMessageMap().getAllPropertiesAndErrors()) {
                StringBuffer logMessage = new StringBuffer();
                logMessage.append("[" + (String)e.getKey() + "] ");
                boolean first = true;
                List errorList = (List)e.getValue();
                for (ErrorMessage em : errorList) {
                    if (first) {
                        first = false;
                    } else {
                        logMessage.append(";");
                    }
                    logMessage.append(em);
                }
                LOG.info((Object)logMessage);
            }
        }
    }

    @Override
    public List<DocumentEvent> generateSaveEvents() {
        return new ArrayList<DocumentEvent>();
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
    }

    @Override
    public GloballyUnique getNoteTarget() {
        return this.getDocumentHeader();
    }

    @Override
    public NoteType getNoteType() {
        return NoteType.DOCUMENT_HEADER;
    }

    @Override
    public void addNote(Note note) {
        if (note == null) {
            throw new IllegalArgumentException("Note cannot be null.");
        }
        this.notes.add(note);
    }

    @Override
    public boolean removeNote(Note note) {
        if (note == null) {
            throw new IllegalArgumentException("Note cannot be null.");
        }
        return this.notes.remove(note);
    }

    @Override
    public Note getNote(int index) {
        return this.notes.get(index);
    }

    @Override
    public List<Note> getNotes() {
        if (CollectionUtils.isEmpty(this.notes) && this.getNoteType().equals((Object)NoteType.BUSINESS_OBJECT) && StringUtils.isNotBlank((String)this.getNoteTarget().getObjectId())) {
            this.notes = this.getNoteService().getByRemoteObjectId(this.getNoteTarget().getObjectId());
        }
        return this.notes;
    }

    @Override
    public void setNotes(List<Note> notes) {
        if (notes == null) {
            throw new IllegalArgumentException("List of notes must be non-null.");
        }
        this.notes = notes;
    }

    @Override
    public List<ActionRequest> getActionRequests() {
        return KewApiServiceLocator.getWorkflowDocumentService().getPendingActionRequests(this.getDocumentNumber());
    }

    @Override
    public String getSuperUserAnnotation() {
        return this.superUserAnnotation;
    }

    @Override
    public void setSuperUserAnnotation(String superUserAnnotation) {
        this.superUserAnnotation = superUserAnnotation;
    }

    @PostLoad
    protected void postLoad() {
        this.documentHeader = KRADServiceLocatorWeb.getDocumentHeaderService().getDocumentHeaderById(this._persistence_get_documentNumber());
        this.refreshPessimisticLocks();
    }

    @PrePersist
    protected void prePersist() {
        super.prePersist();
        this.documentHeader = KRADServiceLocatorWeb.getDocumentHeaderService().saveDocumentHeader(this.documentHeader);
    }

    @PostRemove
    protected void postRemove() {
        KRADServiceLocatorWeb.getDocumentHeaderService().deleteDocumentHeader(this.getDocumentHeader());
    }

    @Override
    public List<PessimisticLock> getPessimisticLocks() {
        return this.pessimisticLocks;
    }

    @Override
    public void refreshPessimisticLocks() {
        this.pessimisticLocks = KRADServiceLocatorWeb.getPessimisticLockService().getPessimisticLocksForDocument(this._persistence_get_documentNumber());
    }

    public void setPessimisticLocks(List<PessimisticLock> pessimisticLocks) {
        this.pessimisticLocks = pessimisticLocks;
    }

    @Override
    public void addPessimisticLock(PessimisticLock lock) {
        this.pessimisticLocks.add(lock);
    }

    @Override
    @Deprecated
    public List<String> getLockClearingMethodNames() {
        return this.getLockClearningMethodNames();
    }

    @Override
    @Deprecated
    public List<String> getLockClearningMethodNames() {
        ArrayList<String> methodToCalls = new ArrayList<String>();
        methodToCalls.add("close");
        methodToCalls.add("cancel");
        methodToCalls.add("route");
        methodToCalls.add("approve");
        methodToCalls.add("disapprove");
        methodToCalls.add("acknowledge");
        return methodToCalls;
    }

    @Override
    public boolean useCustomLockDescriptors() {
        return false;
    }

    @Override
    public String getCustomLockDescriptor(Person user) {
        throw new PessimisticLockingException("Document " + this.getDocumentNumber() + " is using pessimistic locking with custom lock descriptors, but the document class has not overriden the getCustomLockDescriptor method");
    }

    protected AttachmentService getAttachmentService() {
        if (this.attachmentService == null) {
            this.attachmentService = KRADServiceLocator.getAttachmentService();
        }
        return this.attachmentService;
    }

    protected NoteService getNoteService() {
        if (this.noteService == null) {
            this.noteService = KRADServiceLocator.getNoteService();
        }
        return this.noteService;
    }

    @Deprecated
    public void refreshReferenceObject(String referenceObjectName) {
        if (StringUtils.equals((String)referenceObjectName, (String)"documentHeader")) {
            this.documentHeader = KRADServiceLocatorWeb.getDocumentHeaderService().getDocumentHeaderById(this._persistence_get_documentNumber());
        } else {
            super.refreshReferenceObject(referenceObjectName);
        }
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new DocumentBase(persistenceObject);
    }

    public DocumentBase(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "documentNumber") {
            return this.documentNumber;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "documentNumber") {
            this.documentNumber = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_documentNumber() {
        this._persistence_checkFetched("documentNumber");
        return this.documentNumber;
    }

    public void _persistence_set_documentNumber(String string) {
        this._persistence_checkFetchedForSet("documentNumber");
        this._persistence_propertyChange("documentNumber", this.documentNumber, string);
        this.documentNumber = string;
    }
}

