/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.file;

import java.io.Serializable;
import java.sql.Blob;
import java.text.DecimalFormat;
import java.util.Date;
import javax.sql.rowset.serial.SerialBlob;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.file.FileMeta;
import org.springframework.web.multipart.MultipartFile;

public class FileMetaBlob
implements Serializable,
FileMeta {
    private static final long serialVersionUID = 56328058337130228L;
    private String id;
    private String name;
    private String contentType;
    private Long size;
    private Date dateUploaded;
    private String url;
    private MultipartFile multipartFile;
    private Blob blob;

    @Override
    public void init(MultipartFile multipartFile) throws Exception {
        this.name = multipartFile.getOriginalFilename();
        this.contentType = multipartFile.getContentType();
        this.size = multipartFile.getSize();
        this.multipartFile = multipartFile;
        this.blob = new SerialBlob(multipartFile.getBytes());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public Long getSize() {
        return this.size;
    }

    @Override
    public void setSize(Long size) {
        this.size = size;
    }

    @Override
    public String getSizeFormatted() {
        DecimalFormat format = new DecimalFormat("0.#");
        if (this.size >= 1000000000L) {
            return format.format((double)this.size.longValue() / 1.0E9) + " GB";
        }
        if (this.size >= 1000000L) {
            return format.format((double)this.size.longValue() / 1000000.0) + " MB";
        }
        return format.format((double)this.size.longValue() / 1000.0) + " KB";
    }

    @Override
    public Date getDateUploaded() {
        return this.dateUploaded;
    }

    @Override
    public void setDateUploaded(Date dateUploaded) {
        this.dateUploaded = dateUploaded;
    }

    @Override
    public String getDateUploadedFormatted() {
        if (this.dateUploaded != null) {
            return CoreApiServiceLocator.getDateTimeService().toDateTimeString(this.dateUploaded);
        }
        return "";
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    public MultipartFile getMultipartFile() {
        return this.multipartFile;
    }

    public void setMultipartFile(MultipartFile multipartFile) {
        this.multipartFile = multipartFile;
    }

    public Blob getBlob() {
        return this.blob;
    }

    public void setBlob(Blob blob) {
        this.blob = blob;
    }

    public String toString() {
        return "FileBase{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", contentType='" + this.contentType + '\'' + ", size=" + this.size + ", dateUploaded=" + this.dateUploaded + ", url='" + this.url + '\'' + '}';
    }
}

