/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container.collections;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.DialogGroup;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.layout.CollectionLayoutManager;
import org.kuali.rice.krad.uif.view.ViewModel;

public class LineBuilderContext
implements Serializable {
    private static final long serialVersionUID = -2025777471407211781L;
    private int lineIndex;
    private Object currentLine;
    private String bindingPath;
    private boolean bindToForm;
    private ViewModel model;
    private CollectionGroup collectionGroup;
    private List<? extends Component> lineActions;
    private List<Field> lineFields;
    private List<FieldGroup> subCollectionFields;
    private List<DialogGroup> lineDialogs;

    public LineBuilderContext() {
    }

    public LineBuilderContext(int lineIndex, Object currentLine, String bindingPath, boolean bindToForm, ViewModel model, CollectionGroup collectionGroup, List<? extends Component> lineActions) {
        this.lineIndex = lineIndex;
        this.currentLine = currentLine;
        this.bindingPath = bindingPath;
        this.bindToForm = bindToForm;
        this.model = model;
        this.collectionGroup = collectionGroup;
        this.lineActions = lineActions;
        this.lineDialogs = Collections.emptyList();
    }

    public LineBuilderContext(int lineIndex, Object currentLine, String bindingPath, boolean bindToForm, ViewModel model, CollectionGroup collectionGroup, List<? extends Component> lineActions, List<DialogGroup> lineDialogs) {
        this.lineIndex = lineIndex;
        this.currentLine = currentLine;
        this.bindingPath = bindingPath;
        this.bindToForm = bindToForm;
        this.model = model;
        this.collectionGroup = collectionGroup;
        this.lineActions = lineActions;
        this.lineDialogs = lineDialogs;
    }

    public String getIdSuffix() {
        String idSuffix = this.isAddLine() ? "_add" : "_line" + Integer.toString(this.lineIndex);
        return idSuffix;
    }

    public boolean isAddLine() {
        return this.lineIndex == -1;
    }

    public CollectionLayoutManager getLayoutManager() {
        if (this.collectionGroup != null) {
            return (CollectionLayoutManager)this.collectionGroup.getLayoutManager();
        }
        return null;
    }

    public int getLineIndex() {
        return this.lineIndex;
    }

    public void setLineIndex(int lineIndex) {
        this.lineIndex = lineIndex;
    }

    public Object getCurrentLine() {
        return this.currentLine;
    }

    public void setCurrentLine(Object currentLine) {
        this.currentLine = currentLine;
    }

    public String getBindingPath() {
        return this.bindingPath;
    }

    public void setBindingPath(String bindingPath) {
        this.bindingPath = bindingPath;
    }

    public boolean isBindToForm() {
        return this.bindToForm;
    }

    public void setBindToForm(boolean bindToForm) {
        this.bindToForm = bindToForm;
    }

    public ViewModel getModel() {
        return this.model;
    }

    public void setModel(ViewModel model) {
        this.model = model;
    }

    public CollectionGroup getCollectionGroup() {
        return this.collectionGroup;
    }

    public void setCollectionGroup(CollectionGroup collectionGroup) {
        this.collectionGroup = collectionGroup;
    }

    public List<? extends Component> getLineActions() {
        return this.lineActions;
    }

    public void setLineActions(List<? extends Component> lineActions) {
        this.lineActions = lineActions;
    }

    public List<Field> getLineFields() {
        return this.lineFields;
    }

    public void setLineFields(List<Field> lineFields) {
        this.lineFields = lineFields;
    }

    public List<FieldGroup> getSubCollectionFields() {
        return this.subCollectionFields;
    }

    public void setSubCollectionFields(List<FieldGroup> subCollectionFields) {
        this.subCollectionFields = subCollectionFields;
    }

    public List<DialogGroup> getLineDialogs() {
        return this.lineDialogs;
    }

    public void setLineDialogs(List<DialogGroup> dialogGroups) {
        this.lineDialogs = dialogGroups;
    }
}

