/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.freemarker;

import freemarker.core.InlineTemplateAdaptor;
import freemarker.core.InlineTemplateElement;
import freemarker.ext.jsp.TaglibFactory;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.uif.freemarker.FreeMarkerCloseGroupWrapAdaptor;
import org.kuali.rice.krad.uif.freemarker.FreeMarkerCollectionGroupAdaptor;
import org.kuali.rice.krad.uif.freemarker.FreeMarkerOpenGroupWrapAdaptor;
import org.kuali.rice.krad.uif.freemarker.FreeMarkerScriptAdaptor;
import org.kuali.rice.krad.uif.freemarker.FreeMarkerStackedAdaptor;
import org.kuali.rice.krad.uif.freemarker.FreeMarkerTemplateAdaptor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

public class FreeMarkerInlineRenderBootstrap
implements InitializingBean,
ApplicationContextAware,
ServletContextAware {
    private static final Logger LOG = Logger.getLogger(FreeMarkerInlineRenderBootstrap.class);
    private static Configuration freeMarkerConfig;
    private static ApplicationContext applicationContext;
    private static ServletContext servletContext;
    private static TaglibFactory taglibFactory;
    private static ObjectWrapper objectWrapper;
    private static ServletContextHashModel servletContextHashModel;

    public static Configuration getFreeMarkerConfig() {
        if (freeMarkerConfig == null) {
            throw new IllegalStateException("FreeMarker configuruation is not available, use krad-base-servlet.xml or define FreeMarkerInlineRenderBootstrap in servlet.xml");
        }
        return freeMarkerConfig;
    }

    public static ServletContext getServletContext() {
        if (servletContext == null) {
            throw new IllegalStateException("Servlet context is not available, use krad-base-servlet.xml or define FreeMarkerInlineRenderBootstrap in servlet.xml");
        }
        return servletContext;
    }

    public static TaglibFactory getTaglibFactory() {
        return taglibFactory;
    }

    public static ObjectWrapper getObjectWrapper() {
        return objectWrapper;
    }

    public static ServletContextHashModel getServletContextHashModel() {
        return servletContextHashModel;
    }

    private static void finishConfig() {
        if (freeMarkerConfig != null && servletContext != null) {
            taglibFactory = new TaglibFactory(servletContext);
            objectWrapper = freeMarkerConfig.getObjectWrapper();
            if (objectWrapper == null) {
                objectWrapper = ObjectWrapper.DEFAULT_WRAPPER;
            }
            ServletAdapter servlet = new ServletAdapter();
            try {
                servlet.init(new DelegatingServletConfig());
            }
            catch (ServletException ex) {
                throw new BeanInitializationException("Initialization of GenericServlet adapter failed", (Throwable)ex);
            }
            servletContextHashModel = new ServletContextHashModel((GenericServlet)servlet, ObjectWrapper.DEFAULT_WRAPPER);
            LOG.info((Object)"Freemarker configuration complete");
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        try {
            freeMarkerConfig = ((FreeMarkerConfigurer)applicationContext.getBean("freemarkerConfig")).createConfiguration();
            LOG.info((Object)("Set freemarker bootstrap " + freeMarkerConfig));
        }
        catch (IOException e) {
            throw new IllegalStateException("Error loading freemarker configuration", e);
        }
        catch (TemplateException e) {
            throw new IllegalStateException("Error loading freemarker configuration", e);
        }
        FreeMarkerInlineRenderBootstrap.finishConfig();
    }

    public void setServletContext(ServletContext servletContext) {
        FreeMarkerInlineRenderBootstrap.servletContext = servletContext;
        FreeMarkerInlineRenderBootstrap.finishConfig();
    }

    public void afterPropertiesSet() throws Exception {
        InlineTemplateElement.registerAdaptor((String)"script", (InlineTemplateAdaptor)new FreeMarkerScriptAdaptor());
        InlineTemplateElement.registerAdaptor((String)"template", (InlineTemplateAdaptor)new FreeMarkerTemplateAdaptor());
        InlineTemplateElement.registerAdaptor((String)"collectionGroup", (InlineTemplateAdaptor)new FreeMarkerCollectionGroupAdaptor());
        InlineTemplateElement.registerAdaptor((String)"stacked", (InlineTemplateAdaptor)new FreeMarkerStackedAdaptor());
        InlineTemplateElement.registerAdaptor((String)"groupWrap-open", (InlineTemplateAdaptor)new FreeMarkerOpenGroupWrapAdaptor());
        InlineTemplateElement.registerAdaptor((String)"groupWrap-close", (InlineTemplateAdaptor)new FreeMarkerCloseGroupWrapAdaptor());
    }

    private static class DelegatingServletConfig
    implements ServletConfig {
        private DelegatingServletConfig() {
        }

        public String getServletName() {
            return applicationContext.getDisplayName();
        }

        public ServletContext getServletContext() {
            return servletContext;
        }

        public String getInitParameter(String paramName) {
            return null;
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(new HashSet());
        }
    }

    private static class ServletAdapter
    extends GenericServlet {
        private static final long serialVersionUID = 8509364718276109450L;

        private ServletAdapter() {
        }

        public void service(ServletRequest servletRequest, ServletResponse servletResponse) {
        }
    }
}

