/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.freemarker;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class JsonStringEscapeDirective
implements TemplateDirectiveModel {
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (!params.isEmpty()) {
            throw new TemplateModelException(this.getClass().getSimpleName() + " doesn't allow parameters.");
        }
        if (loopVars.length != 0) {
            throw new TemplateModelException(this.getClass().getSimpleName() + " doesn't allow loop variables.");
        }
        if (body == null) {
            throw new RuntimeException("missing body");
        }
        body.render((Writer)new JsonEscapingFilterWriter(env.getOut()));
    }

    private static class JsonEscapingFilterWriter
    extends Writer {
        private final Writer out;

        JsonEscapingFilterWriter(Writer out) {
            this.out = out;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            int needsEscapingCount = 0;
            for (int i = 0; i < len; ++i) {
                if (!JsonEscapingFilterWriter.isNeedsEscaping(cbuf[i + off])) continue;
                ++needsEscapingCount;
            }
            char[] transformedCbuf = new char[len + needsEscapingCount];
            int escapesAddedCount = 0;
            for (int i = 0; i < len; ++i) {
                if (JsonEscapingFilterWriter.isNeedsEscaping(cbuf[i + off])) {
                    transformedCbuf[i + escapesAddedCount] = 92;
                    ++escapesAddedCount;
                }
                transformedCbuf[i + escapesAddedCount] = cbuf[i + off] == '\n' ? 110 : (cbuf[i + off] == '\r' ? 114 : cbuf[i + off]);
            }
            this.out.write(transformedCbuf);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        private static boolean isNeedsEscaping(char c) {
            return c == '\"' || c == '\n' || c == '\r';
        }
    }
}

