/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.KeepExpression;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.container.DialogGroup;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.collections.LineBuilderContext;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.layout.CollectionLayoutUtils;
import org.kuali.rice.krad.uif.layout.StackedLayoutManager;
import org.kuali.rice.krad.uif.layout.collections.CollectionLayoutManagerBase;
import org.kuali.rice.krad.uif.layout.collections.CollectionPagingHelper;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleRestriction;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleUtils;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ContextUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.UifFormBase;

@BeanTags(value={@BeanTag(name="stackedCollectionLayout-bean", parent="Uif-StackedCollectionLayoutBase"), @BeanTag(name="stackedCollectionLayout-withGridItems-bean", parent="Uif-StackedCollectionLayout-WithGridItems"), @BeanTag(name="stackedCollectionLayout-withBoxItems-bean", parent="Uif-StackedCollectionLayout-WithBoxItems"), @BeanTag(name="stackedCollectionLayout-list-bean", parent="Uif-StackedCollectionLayout-List")})
public class StackedLayoutManagerBase
extends CollectionLayoutManagerBase
implements StackedLayoutManager {
    private static final long serialVersionUID = 4602368505430238846L;
    @KeepExpression
    private String summaryTitle;
    private List<String> summaryFields = new ArrayList<String>();
    private Group lineGroupPrototype;
    private Group wrapperGroup;
    private List<Group> stackedGroups = new ArrayList<Group>();
    private boolean renderLineActionsInLineGroup;
    private boolean renderLineActionsInHeader;

    @Override
    public void performInitialization(Object model) {
        super.performInitialization(model);
        this.stackedGroups = new ArrayList<Group>();
    }

    @Override
    public void performApplyModel(Object model, LifecycleElement component) {
        super.performApplyModel(model, component);
        if (this.wrapperGroup != null) {
            this.wrapperGroup.setItems(this.stackedGroups);
        }
    }

    @Override
    public void performFinalize(Object model, LifecycleElement element) {
        boolean serverPagingEnabled;
        super.performFinalize(model, element);
        boolean bl = serverPagingEnabled = element instanceof CollectionGroup && ((CollectionGroup)element).isUseServerPaging();
        if (serverPagingEnabled && this.getPagerWidget() != null) {
            CollectionLayoutUtils.setupPagerWidget(this.getPagerWidget(), (CollectionGroup)element, model);
        }
    }

    @Override
    public void buildLine(LineBuilderContext lineBuilderContext) {
        List<Action> lineGroupActions;
        View view = ViewLifecycle.getView();
        List<Field> lineFields = lineBuilderContext.getLineFields();
        CollectionGroup collectionGroup = lineBuilderContext.getCollectionGroup();
        int lineIndex = lineBuilderContext.getLineIndex();
        String idSuffix = lineBuilderContext.getIdSuffix();
        Object currentLine = lineBuilderContext.getCurrentLine();
        String bindingPath = lineBuilderContext.getBindingPath();
        HashMap<String, Object> lineContext = new HashMap<String, Object>();
        lineContext.putAll(this.getContext());
        lineContext.put("line", currentLine);
        lineContext.put("manager", this);
        lineContext.put("view", view);
        lineContext.put("lineSuffix", idSuffix);
        lineContext.put("index", lineIndex);
        lineContext.put("collectionGroup", collectionGroup);
        lineContext.put("isAddLine", lineBuilderContext.isAddLine());
        lineContext.put("readOnlyLine", Boolean.TRUE.equals(collectionGroup.getReadOnly()));
        lineContext.put("parentLine", currentLine);
        ExpressionEvaluator expressionEvaluator = ViewLifecycle.getExpressionEvaluator();
        Group lineGroup = null;
        if (lineBuilderContext.isAddLine()) {
            this.stackedGroups = new ArrayList<Group>();
            if (this.getAddLineGroup() == null) {
                lineGroup = ComponentUtils.copy(this.lineGroupPrototype, idSuffix);
            } else {
                lineGroup = ComponentUtils.copy(this.getAddLineGroup(), idSuffix);
                lineGroup.addStyleClass(collectionGroup.getAddItemCssClass());
            }
            this.addEnterKeyDataAttributeToGroup(lineGroup, lineContext, expressionEvaluator, collectionGroup.getAddLineEnterKeyAction());
        } else {
            lineGroup = ComponentUtils.copy(this.lineGroupPrototype, idSuffix);
            this.addEnterKeyDataAttributeToGroup(lineGroup, lineContext, expressionEvaluator, collectionGroup.getLineEnterKeyAction());
        }
        if (((UifFormBase)lineBuilderContext.getModel()).isAddedCollectionItem(currentLine)) {
            lineGroup.addStyleClass(collectionGroup.getNewItemsCssClass());
        }
        if ((lineGroupActions = ViewLifecycleUtils.getElementsOfTypeDeep(lineGroup, Action.class)) != null) {
            collectionGroup.getCollectionGroupBuilder().initializeActions(lineGroupActions, collectionGroup, lineIndex);
            ContextUtils.updateContextsForLine(lineGroupActions, collectionGroup, currentLine, lineIndex, idSuffix);
        }
        ContextUtils.updateContextForLine(lineGroup, collectionGroup, currentLine, lineIndex, idSuffix);
        if (lineBuilderContext.isAddLine()) {
            if (lineGroup.getHeader() != null && StringUtils.isNotBlank((String)lineGroup.getHeaderText())) {
                Message headerMessage = ComponentUtils.copy(collectionGroup.getAddLineLabel());
                headerMessage.setMessageText(lineGroup.getHeaderText());
            }
        } else {
            List modelCollection = (List)ObjectPropertyUtils.getPropertyValue(lineBuilderContext.getModel(), collectionGroup.getBindingInfo().getBindingPath());
            String headerText = this.buildLineHeaderText(modelCollection.get(lineIndex), lineGroup);
            if (StringUtils.isNotBlank((String)headerText) && lineGroup.getHeader() != null) {
                lineGroup.getHeader().setHeaderText(headerText);
            }
        }
        ArrayList<Component> groupFields = new ArrayList<Component>();
        groupFields.addAll(lineFields);
        if (lineBuilderContext.getSubCollectionFields() != null) {
            groupFields.addAll(lineBuilderContext.getSubCollectionFields());
        }
        this.determineLineActionPlacement(lineGroup, collectionGroup, lineBuilderContext, groupFields);
        lineGroup.setItems(groupFields);
        if (lineBuilderContext.isAddLine() && this.getAddLineGroup() != null) {
            this.getAddLineGroup().setItems(lineGroup.getItems());
        }
        if (lineBuilderContext.getModel() instanceof ViewModel) {
            KRADUtils.syncClientSideStateForComponent(lineGroup.getDisclosure(), lineBuilderContext.getModel().getClientStateForSyncing());
        }
        if (!(lineGroup instanceof DialogGroup)) {
            this.stackedGroups.add(lineGroup);
        }
        ContextUtils.pushObjectToContextDeep(lineGroup.getItems(), "parentLine", lineBuilderContext.getCurrentLine());
    }

    protected void determineLineActionPlacement(Group lineGroup, CollectionGroup collectionGroup, LineBuilderContext lineBuilderContext, List<Component> groupFields) {
        boolean showActions;
        List<? extends Component> actions = lineBuilderContext.getLineActions();
        boolean bl = showActions = collectionGroup.isRenderLineActions() && !Boolean.TRUE.equals(collectionGroup.getReadOnly());
        if (!showActions) {
            return;
        }
        if (this.renderLineActionsInHeader && lineGroup.getHeader() != null && !lineBuilderContext.isAddLine()) {
            Group headerGroup = lineGroup.getHeader().getRightGroup();
            if (headerGroup == null) {
                headerGroup = ComponentFactory.getHorizontalBoxGroup();
            }
            ArrayList<Component> items = new ArrayList<Component>();
            items.addAll(headerGroup.getItems());
            items.addAll(actions);
            headerGroup.setItems(items);
            lineGroup.getHeader().setRightGroup(headerGroup);
        } else if (this.isRenderLineActionsInLineGroup()) {
            groupFields.addAll(actions);
            lineGroup.setRenderFooter(false);
        } else if (lineGroup.getFooter() != null && (lineGroup.getFooter().getItems() == null || lineGroup.getFooter().getItems().isEmpty())) {
            lineGroup.getFooter().setItems(actions);
        }
    }

    protected String buildLineHeaderText(Object line, Group lineGroup) {
        if (ViewLifecycle.getExpressionEvaluator().containsElPlaceholder(this.summaryTitle)) {
            lineGroup.getPropertyExpressions().put("headerText", this.summaryTitle);
            return null;
        }
        String summaryFieldString = "";
        for (String summaryField : this.summaryFields) {
            Object summaryFieldValue = ObjectPropertyUtils.getPropertyValue(line, summaryField);
            if (StringUtils.isNotBlank((String)summaryFieldString)) {
                summaryFieldString = summaryFieldString + " - ";
            }
            if (summaryFieldValue != null) {
                summaryFieldString = summaryFieldString + summaryFieldValue;
                continue;
            }
            summaryFieldString = summaryFieldString + "Null";
        }
        String headerText = this.summaryTitle;
        if (StringUtils.isNotBlank((String)summaryFieldString)) {
            headerText = headerText + " ( " + summaryFieldString + " )";
        }
        return headerText;
    }

    @Override
    public void processPagingRequest(Object model, CollectionGroup collectionGroup) {
        String pageNumber = ViewLifecycle.getRequest().getParameter("pageNumber");
        CollectionPagingHelper pagingHelper = new CollectionPagingHelper();
        pagingHelper.processPagingRequest(ViewLifecycle.getView(), collectionGroup, (UifFormBase)model, pageNumber);
    }

    @Override
    @BeanTagAttribute
    @ViewLifecycleRestriction(value={"INITIALIZE"})
    public Group getAddLineGroup() {
        return super.getAddLineGroup();
    }

    @Override
    public Class<? extends Container> getSupportedContainer() {
        return CollectionGroup.class;
    }

    @Override
    @BeanTagAttribute
    public String getSummaryTitle() {
        return this.summaryTitle;
    }

    @Override
    public void setSummaryTitle(String summaryTitle) {
        this.summaryTitle = summaryTitle;
    }

    @Override
    @BeanTagAttribute
    public List<String> getSummaryFields() {
        return this.summaryFields;
    }

    @Override
    public void setSummaryFields(List<String> summaryFields) {
        this.summaryFields = summaryFields;
    }

    @Override
    @ViewLifecycleRestriction(value={"INITIALIZE"})
    @BeanTagAttribute
    public Group getLineGroupPrototype() {
        return this.lineGroupPrototype;
    }

    @Override
    public void setLineGroupPrototype(Group lineGroupPrototype) {
        this.lineGroupPrototype = lineGroupPrototype;
    }

    @Override
    @BeanTagAttribute
    public Group getWrapperGroup() {
        return this.wrapperGroup;
    }

    @Override
    public void setWrapperGroup(Group wrapperGroup) {
        this.wrapperGroup = wrapperGroup;
    }

    @Override
    @ViewLifecycleRestriction
    @BeanTagAttribute
    public List<Group> getStackedGroups() {
        return this.stackedGroups;
    }

    @Override
    public List<Group> getStackedGroupsNoWrapper() {
        return this.wrapperGroup != null ? null : this.stackedGroups;
    }

    @Override
    public void setStackedGroups(List<Group> stackedGroups) {
        this.stackedGroups = stackedGroups;
    }

    @Override
    @BeanTagAttribute
    public boolean isRenderLineActionsInLineGroup() {
        return this.renderLineActionsInLineGroup;
    }

    @Override
    public void setRenderLineActionsInLineGroup(boolean renderLineActionsInLineGroup) {
        this.renderLineActionsInLineGroup = renderLineActionsInLineGroup;
    }

    @Override
    @BeanTagAttribute
    public boolean isRenderLineActionsInHeader() {
        return this.renderLineActionsInHeader;
    }

    @Override
    public void setRenderLineActionsInHeader(boolean renderLineActionsInHeader) {
        this.renderLineActionsInHeader = renderLineActionsInHeader;
    }
}

